/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import org.apache.directory.shared.ldap.name.ComplexDnParser;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.FastDnParser;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.name.TooComplexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DnParser implements NameParser
{
    INSTANCE;


    public static NameParser getNameParser() {
        return INSTANCE;
    }

    public static void parseInternal(String name, List<RDN> rdns) throws InvalidNameException {
        try {
            FastDnParser.INSTANCE.parseDn(name, rdns);
        }
        catch (TooComplexException e) {
            rdns.clear();
            new ComplexDnParser().parseDn(name, rdns);
        }
    }

    public static boolean validateInternal(String name) {
        DN dn = new DN();
        try {
            DnParser.parseInternal(name, dn.rdns);
            return true;
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    @Override
    public Name parse(String dn) throws InvalidNameException {
        return new DN(dn);
    }
}

