/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.replication.syncDoneValue;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.AbstractControl;
import org.apache.directory.shared.ldap.codec.controls.replication.syncDoneValue.SyncDoneValueControlDecoder;
import org.apache.directory.shared.ldap.util.StringTools;

public class SyncDoneValueControl
extends AbstractControl {
    public static final String CONTROL_OID = "1.3.6.1.4.1.4203.1.9.1.3";
    private byte[] cookie;
    private boolean refreshDeletes;
    private int syncDoneValueLength;

    public SyncDoneValueControl() {
        super(CONTROL_OID);
        this.decoder = new SyncDoneValueControlDecoder();
    }

    public int computeLength() {
        if (this.cookie != null) {
            this.syncDoneValueLength = 1 + TLV.getNbBytes((int)this.cookie.length) + this.cookie.length;
        }
        if (this.refreshDeletes) {
            this.syncDoneValueLength += 3;
        }
        this.valueLength = 1 + TLV.getNbBytes((int)this.syncDoneValueLength) + this.syncDoneValueLength;
        return super.computeLength(this.valueLength);
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((String)"ERR_04023", (Object[])new Object[0]));
        }
        super.encode(buffer);
        buffer.put((byte)4);
        buffer.put(TLV.getBytes((int)this.valueLength));
        buffer.put((byte)48);
        buffer.put(TLV.getBytes((int)this.syncDoneValueLength));
        if (this.cookie != null) {
            Value.encode((ByteBuffer)buffer, (byte[])this.cookie);
        }
        if (this.refreshDeletes) {
            Value.encode((ByteBuffer)buffer, (boolean)this.refreshDeletes);
        }
        return buffer;
    }

    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put((byte)48);
                buffer.put(TLV.getBytes((int)this.syncDoneValueLength));
                if (this.cookie != null) {
                    Value.encode((ByteBuffer)buffer, (byte[])this.cookie);
                }
                if (this.refreshDeletes) {
                    Value.encode((ByteBuffer)buffer, (boolean)this.refreshDeletes);
                }
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        if (cookie != null) {
            this.cookie = new byte[cookie.length];
            System.arraycopy(cookie, 0, this.cookie, 0, cookie.length);
        } else {
            this.cookie = null;
        }
    }

    public boolean isRefreshDeletes() {
        return this.refreshDeletes;
    }

    public void setRefreshDeletes(boolean refreshDeletes) {
        this.refreshDeletes = refreshDeletes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SyncDoneValue control :\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        cookie            : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
        sb.append("        refreshDeletes : '").append(this.refreshDeletes).append("'\n");
        return sb.toString();
    }
}

