/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeTypeAndValue
implements Cloneable,
Comparable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = LoggerFactory.getLogger(AttributeTypeAndValue.class);
    private String normType;
    private String upType;
    private Value<?> normValue;
    private Value<?> upValue;
    private String upName;
    private int start;
    private int length;
    private static final boolean CASE_SENSITIVE = true;
    private static final boolean CASE_INSENSITIVE = false;
    private static final boolean[] DN_ESCAPED_CHARS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

    public AttributeTypeAndValue() {
        this.normType = null;
        this.upType = null;
        this.normValue = null;
        this.upValue = null;
        this.upName = "";
        this.start = -1;
        this.length = 0;
    }

    public AttributeTypeAndValue(String upType, String normType, String upValue, String normValue) throws InvalidNameException {
        this(upType, normType, new ClientStringValue(upValue), new ClientStringValue(normValue));
    }

    public AttributeTypeAndValue(String upType, String normType, byte[] upValue, byte[] normValue) throws InvalidNameException {
        this(upType, normType, new ClientBinaryValue(upValue), new ClientBinaryValue(normValue));
    }

    public AttributeTypeAndValue(String upType, String normType, Value<?> upValue, Value<?> normValue) throws InvalidNameException {
        String upTypeTrimmed = StringTools.trim(upType);
        String normTypeTrimmed = StringTools.trim(normType);
        if (StringTools.isEmpty(upTypeTrimmed)) {
            if (StringTools.isEmpty(normTypeTrimmed)) {
                String message = "The type cannot be empty or null";
                LOG.error(message);
                throw new InvalidNameException(message);
            }
            this.normType = StringTools.lowerCaseAscii(normTypeTrimmed);
            this.upType = normType;
        } else if (StringTools.isEmpty(normTypeTrimmed)) {
            this.normType = StringTools.lowerCaseAscii(upTypeTrimmed);
            this.upType = upType;
        } else {
            this.normType = StringTools.lowerCaseAscii(normTypeTrimmed);
            this.upType = upType;
        }
        this.normValue = normValue;
        this.upValue = upValue;
        this.upName = this.upType + '=' + (this.upValue == null ? "" : this.upValue.getString());
        this.start = 0;
        this.length = this.upName.length();
    }

    AttributeTypeAndValue(String upType, String normType, Value<?> upValue, Value<?> normValue, int start, int length, String upName) {
        this.upType = upType;
        this.normType = normType;
        this.upValue = upValue;
        this.normValue = normValue;
        this.start = start;
        this.length = length;
        this.upName = upName;
    }

    public String getNormType() {
        return this.normType;
    }

    public String getUpType() {
        return this.upType;
    }

    public void setType(String upType, String type) throws InvalidNameException {
        if (StringTools.isEmpty(type) || StringTools.isEmpty(type.trim())) {
            String message = "The type cannot be empty or null";
            LOG.error(message);
            throw new InvalidNameException(message);
        }
        if (StringTools.isEmpty(upType) || StringTools.isEmpty(upType.trim())) {
            String message = "The User Provided type cannot be empty or null";
            LOG.error(message);
            throw new InvalidNameException(message);
        }
        int equalPosition = this.upName.indexOf(61);
        if (equalPosition <= 1) {
            String message = "The User provided name does not contains an '='";
            LOG.error(message);
            throw new InvalidNameException(message);
        }
        this.normType = type.trim().toLowerCase();
        this.upType = upType;
        this.upName = upType + this.upName.substring(equalPosition);
        this.start = -1;
        this.length = this.upName.length();
    }

    public void setTypeNormalized(String type) throws InvalidNameException {
        if (StringTools.isEmpty(type) || StringTools.isEmpty(type.trim())) {
            LOG.error("The type cannot be empty or null");
            throw new InvalidNameException("The AttributeTypeAndValue type cannot be null or empty ");
        }
        this.normType = type.trim().toLowerCase();
        this.upType = type;
        this.upName = type + this.upName.substring(this.upName.indexOf(61));
        this.start = -1;
        this.length = this.upName.length();
    }

    public Value<?> getNormValue() {
        return this.normValue;
    }

    public Value<?> getUpValue() {
        return this.upValue;
    }

    public String getNormalizedValue() {
        return this.normalize();
    }

    public void setValue(Value<?> upValue, Value<?> normValue) {
        this.normValue = normValue;
        this.upValue = upValue;
        this.upName = this.upName.substring(0, this.upName.indexOf(61) + 1) + upValue;
        this.start = -1;
        this.length = this.upName.length();
    }

    public int getLength() {
        return this.length;
    }

    public int getStart() {
        return this.start;
    }

    public String getUpName() {
        return this.upName;
    }

    public void setValueNormalized(String value) {
        String newValue = StringTools.trim(value);
        this.normValue = StringTools.isEmpty(newValue) ? new ClientStringValue("") : new ClientStringValue(newValue);
        this.upName = this.upName.substring(0, this.upName.indexOf(61) + 1) + value;
        this.start = -1;
        this.length = this.upName.length();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure");
        }
    }

    public int compareTo(Object object) {
        if (object instanceof AttributeTypeAndValue) {
            AttributeTypeAndValue nc = (AttributeTypeAndValue)object;
            int res = this.compareType(this.normType, nc.normType);
            if (res != 0) {
                return res;
            }
            return this.compareValue(this.normValue, nc.normValue, true);
        }
        return 1;
    }

    public int compareToIgnoreCase(Object object) {
        if (object instanceof AttributeTypeAndValue) {
            AttributeTypeAndValue nc = (AttributeTypeAndValue)object;
            int res = this.compareType(this.normType, nc.normType);
            if (res != 0) {
                return res;
            }
            return this.compareValue(this.normValue, nc.normValue, false);
        }
        return 1;
    }

    private int compareType(String val1, String val2) {
        if (StringTools.isEmpty(val1)) {
            return StringTools.isEmpty(val2) ? 0 : -1;
        }
        if (StringTools.isEmpty(val2)) {
            return 1;
        }
        return StringTools.trim(val1).compareToIgnoreCase(StringTools.trim(val2));
    }

    private int compareValue(Value<?> val1, Value<?> val2, boolean sensitivity) {
        if (!val1.isBinary()) {
            if (!val2.isBinary()) {
                int val;
                int n = val = sensitivity ? val1.getString().compareTo(val2.getString()) : val1.getString().compareToIgnoreCase(val2.getString());
                return val < 0 ? -1 : (val > 0 ? 1 : val);
            }
            return 1;
        }
        if (val2.isBinary()) {
            if (Arrays.equals(val1.getBytes(), val2.getBytes())) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    public String normalize() {
        if (!this.normValue.isBinary()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.normType).append('=');
            String normalizedValue = this.normValue.getString();
            int valueLength = normalizedValue.length();
            boolean escaped = false;
            if (normalizedValue.length() > 0) {
                char[] chars;
                for (char c : chars = normalizedValue.toCharArray()) {
                    if (c < '\u0000' || c >= DN_ESCAPED_CHARS.length || !DN_ESCAPED_CHARS[c]) continue;
                    escaped = true;
                    break;
                }
                if (escaped) {
                    for (int i = 0; i < valueLength; ++i) {
                        char c = chars[i];
                        if (c >= '\u0000' && c < DN_ESCAPED_CHARS.length && DN_ESCAPED_CHARS[c]) {
                            if (c == ' ') {
                                if (i == 0 || i == valueLength - 1) {
                                    sb.append('\\').append(c);
                                    continue;
                                }
                                sb.append(' ');
                                continue;
                            }
                            if (c == '#') {
                                if (i == 0) {
                                    sb.append("\\#");
                                    continue;
                                }
                                sb.append('#');
                                continue;
                            }
                            sb.append('\\').append(c);
                            continue;
                        }
                        sb.append(c);
                    }
                } else {
                    sb.append(normalizedValue);
                }
            }
            return sb.toString();
        }
        return this.normType + "=#" + StringTools.dumpHexPairs(this.normValue.getBytes());
    }

    public int hashCode() {
        int result = 37;
        result = result * 17 + (this.normType != null ? this.normType.hashCode() : 0);
        result = result * 17 + (this.normValue != null ? this.normValue.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AttributeTypeAndValue)) {
            return false;
        }
        AttributeTypeAndValue instance = (AttributeTypeAndValue)obj;
        if (this.normType == null ? instance.normType != null : !this.normType.equals(instance.normType)) {
            return false;
        }
        if (this.normValue.isNull()) {
            return instance.normValue.isNull();
        }
        return this.normValue.equals(instance.normValue);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (StringTools.isEmpty(this.upName) || StringTools.isEmpty(this.upType) || StringTools.isEmpty(this.normType) || this.start < 0 || this.length < 2 || this.upValue.isNull() || this.normValue.isNull()) {
            String message = "Cannot serialize an wrong ATAV, ";
            if (StringTools.isEmpty(this.upName)) {
                message = message + "the upName should not be null or empty";
            } else if (StringTools.isEmpty(this.upType)) {
                message = message + "the upType should not be null or empty";
            } else if (StringTools.isEmpty(this.normType)) {
                message = message + "the normType should not be null or empty";
            } else if (this.start < 0) {
                message = message + "the start should not be < 0";
            } else if (this.length < 2) {
                message = message + "the length should not be < 2";
            } else if (this.upValue.isNull()) {
                message = message + "the upValue should not be null";
            } else if (this.normValue.isNull()) {
                message = message + "the value should not be null";
            }
            LOG.error(message);
            throw new IOException(message);
        }
        out.writeUTF(this.upName);
        out.writeInt(this.start);
        out.writeInt(this.length);
        out.writeUTF(this.upType);
        out.writeUTF(this.normType);
        boolean isHR = !this.normValue.isBinary();
        out.writeBoolean(isHR);
        if (isHR) {
            out.writeUTF(this.upValue.getString());
            out.writeUTF(this.normValue.getString());
        } else {
            out.writeInt(this.upValue.length());
            out.write(this.upValue.getBytes());
            out.writeInt(this.normValue.length());
            out.write(this.normValue.getBytes());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.upName = in.readUTF();
        this.start = in.readInt();
        this.length = in.readInt();
        this.upType = in.readUTF();
        this.normType = in.readUTF();
        boolean isHR = in.readBoolean();
        if (isHR) {
            this.upValue = new ClientStringValue(in.readUTF());
            this.normValue = new ClientStringValue(in.readUTF());
        } else {
            int upValueLength = in.readInt();
            byte[] upValueBytes = new byte[upValueLength];
            in.readFully(upValueBytes);
            this.upValue = new ClientBinaryValue(upValueBytes);
            int valueLength = in.readInt();
            byte[] normValueBytes = new byte[valueLength];
            in.readFully(normValueBytes);
            this.normValue = new ClientBinaryValue(normValueBytes);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (StringTools.isEmpty(this.normType) || StringTools.isEmpty(this.normType.trim())) {
            return "";
        }
        sb.append(this.normType).append("=");
        if (this.normValue != null) {
            sb.append(this.normValue.getString());
        }
        return sb.toString();
    }
}

