/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.exception;

import javax.naming.AuthenticationNotSupportedException;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;

public class LdapAuthenticationNotSupportedException
extends AuthenticationNotSupportedException
implements LdapException {
    static final long serialVersionUID = 2532733848470791678L;
    private final ResultCodeEnum resultCode;

    public LdapAuthenticationNotSupportedException(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        this.checkResultCode();
    }

    public LdapAuthenticationNotSupportedException(String explanation, ResultCodeEnum resultCode) {
        super(explanation);
        this.resultCode = resultCode;
        this.checkResultCode();
    }

    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    private void checkResultCode() {
        switch (this.resultCode) {
            case INAPPROPRIATE_AUTHENTICATION: 
            case CONFIDENTIALITY_REQUIRED: 
            case AUTH_METHOD_NOT_SUPPORTED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexceptable result code for this exception type: " + (Object)((Object)this.resultCode));
            }
        }
    }
}

