/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.util;

import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.util.BooleanDecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanDecoder {
    private static final Logger log = LoggerFactory.getLogger((Class)BooleanDecoder.class);

    public static boolean parse(Value value) throws BooleanDecoderException {
        byte[] bytes = value.getData();
        if (bytes == null || bytes.length == 0) {
            throw new BooleanDecoderException("The value is 0 byte long. This is not allowed for a boolean");
        }
        if (bytes.length != 1) {
            throw new BooleanDecoderException("The value is not 1 byte long. This is not allowed for a boolean");
        }
        if (bytes[0] != 0 && bytes[0] != -1) {
            log.warn("A boolean must be encoded with a 0x00 or a 0xFF value");
        }
        return bytes[0] != 0;
    }
}

