/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.controls.ChangeType;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;

public class ReplicaEventMessage {
    private ChangeType changeType;
    private Entry entry;

    public ReplicaEventMessage(ChangeType changeType, Entry entry) {
        this.changeType = changeType;
        this.entry = entry instanceof ClonedServerEntry ? ((ClonedServerEntry)entry).getClonedEntry() : entry;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public boolean isEventOlderThan(String csn) throws LdapException {
        if (csn == null) {
            return false;
        }
        String entryCsn = this.entry.get("entryCSN").getString();
        int i = entryCsn.compareTo(csn);
        return i <= 0;
    }
}

