/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Hashtable;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.DateTime;
import org.apache.derby.client.am.DateTimeValue;
import org.apache.derby.client.am.Decimal;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.DynamicByteArrayOutputStream;
import org.apache.derby.client.net.EncodedInputStream;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetLogWriter;

public class Request {
    protected ByteBuffer buffer;
    private static final int MAX_MARKS_NESTING = 10;
    private int[] markStack_ = new int[10];
    private int top_ = 0;
    private int dssLengthLocation_ = 0;
    private int correlationID_ = 0;
    private boolean simpleDssFinalize = false;
    protected boolean passwordIncluded_ = false;
    protected int passwordStart_ = 0;
    protected int passwordLength_ = 0;
    protected NetAgent netAgent_;

    Request(NetAgent netAgent, int n) {
        this.netAgent_ = netAgent;
        this.buffer = ByteBuffer.allocate(n);
        this.clearBuffer();
    }

    protected final void clearBuffer() {
        this.buffer.clear();
        this.top_ = 0;
        for (int i = 0; i < this.markStack_.length && this.markStack_[i] != 0; ++i) {
            this.markStack_[i] = 0;
        }
        this.dssLengthLocation_ = 0;
    }

    final void initialize() {
        this.clearBuffer();
        this.correlationID_ = 0;
    }

    protected final void ensureLength(int n) {
        if (n > this.buffer.remaining()) {
            int n2 = Math.max(this.buffer.capacity() * 2, this.buffer.position() + n);
            this.buffer.flip();
            this.buffer = ByteBuffer.allocate(n2).put(this.buffer);
        }
    }

    protected final void createCommand() {
        this.buildDss(false, false, false, 1, ++this.correlationID_, false);
    }

    protected void createXACommand() {
        this.buildDss(false, false, false, 5, ++this.correlationID_, false);
    }

    final void createCommandData() {
        this.buildDss(true, false, false, 3, this.correlationID_, false);
    }

    final void createEncryptedCommandData() {
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.buildDss(true, false, false, 4, this.correlationID_, false);
        } else {
            this.buildDss(true, false, false, 3, this.correlationID_, false);
        }
    }

    private final void buildDss(boolean bl, boolean bl2, boolean bl3, int n, int n2, boolean bl4) {
        if (this.doesRequestContainData()) {
            if (this.simpleDssFinalize) {
                this.finalizeDssLength();
            } else {
                this.finalizePreviousChainedDss(bl);
            }
        }
        this.ensureLength(6);
        this.dssLengthLocation_ = this.buffer.position();
        this.buffer.putShort((short)-1);
        this.buffer.put((byte)-48);
        if (bl2) {
            n |= 0x40;
            if (bl3) {
                n |= 0x10;
            }
        }
        this.buffer.put((byte)n);
        this.buffer.putShort((short)n2);
        this.simpleDssFinalize = bl4;
    }

    final void writeScalarStream(boolean bl, boolean bl2, int n, InputStream inputStream, boolean bl3, int n2) throws DisconnectException, SqlException {
        this.writePlainScalarStream(bl, bl2, n, inputStream, bl3, n2);
    }

    final void writeScalarStream(boolean bl, boolean bl2, int n, long l, InputStream inputStream, boolean bl3, int n2) throws DisconnectException, SqlException {
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("0A000.S"), "encrypted scalar streams");
        }
        this.writePlainScalarStream(bl, bl2, n, l, inputStream, bl3, n2);
    }

    private final void writePlainScalarStream(boolean bl, boolean bl2, int n, long l, InputStream inputStream, boolean bl3, int n2) throws DisconnectException, SqlException {
        boolean bl4 = this.netAgent_.netConnection_.serverSupportsEXTDTAAbort();
        long l2 = l;
        long l3 = bl4 ? l2 + 1L : l2;
        int n3 = this.prepScalarStream(bl, bl2, bl3, l3);
        int n4 = bl3 ? 1 : 0;
        int n5 = 32757 - n4 - n3;
        int n6 = (int)Math.min(l3, (long)n5);
        if (bl4 && (long)n6 == l3) {
            --n6;
        }
        this.buildLengthAndCodePointForLob(n, l3, bl3, n3);
        byte by = 127;
        int n7 = 0;
        while (true) {
            try {
                n7 = inputStream.read(this.buffer.array(), this.buffer.position(), n6);
            }
            catch (Exception exception) {
                by = 1;
                this.padScalarStreamForError(l2, n6, bl4, by);
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN014.S"), (Object)new Integer(n2), (Object)exception.getMessage(), (Throwable)exception));
                return;
            }
            if (n7 == -1) {
                by = 2;
                this.padScalarStreamForError(l2, n6, bl4, by);
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN017.S"), new Integer(n2)));
                return;
            }
            this.buffer.position(this.buffer.position() + n7);
            l2 -= (long)n7;
            if ((n6 -= n7) > 0) continue;
            n6 = this.flushScalarStreamSegment(l2, n6);
            if (l2 <= 0L) break;
        }
        try {
            if (inputStream.read() != -1) {
                by = 4;
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN015.S"), new Integer(n2)));
            }
        }
        catch (Exception exception) {
            by = 1;
            this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN016.S"), (Object)new Integer(n2), (Object)exception.getMessage(), (Throwable)exception));
        }
        if (bl4) {
            this.writeEXTDTAStatus(by);
        }
    }

    private final void writePlainScalarStream(boolean bl, boolean bl2, int n, InputStream inputStream, boolean bl3, int n2) throws DisconnectException {
        boolean bl4 = this.netAgent_.netConnection_.serverSupportsEXTDTAAbort();
        inputStream = new BufferedInputStream(inputStream);
        this.flushExistingDSS();
        this.ensureLength(Short.MAX_VALUE - this.buffer.position());
        this.buildDss(true, bl, bl2, 3, this.correlationID_, true);
        int n3 = bl3 ? 32756 : 32757;
        this.buildLengthAndCodePointForLob(n, bl3);
        try {
            int n4 = 0;
            while ((n4 = inputStream.read(this.buffer.array(), this.buffer.position(), n3)) > -1) {
                this.buffer.position(this.buffer.position() + n4);
                if ((n3 -= n4) > 0) continue;
                if (Request.peekStream((BufferedInputStream)inputStream)) {
                    this.flushScalarStreamSegment();
                    this.buffer.putShort((short)-1);
                    n3 = 32765;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            if (bl4) {
                this.writeEXTDTAStatus((byte)1);
            }
            SqlException sqlException = new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN014.S"), (Object)new Integer(n2), (Object)exception.getMessage(), (Throwable)exception);
            this.netAgent_.accumulateReadException(sqlException);
            return;
        }
        if (bl4) {
            this.writeEXTDTAStatus((byte)127);
        }
    }

    final void writeScalarStream(boolean bl, boolean bl2, int n, int n2, Reader reader, boolean bl3, int n3) throws DisconnectException, SqlException {
        this.writeScalarStream(bl, bl2, n, (long)n2 * 2L, EncodedInputStream.createUTF16BEStream(reader), bl3, n3);
    }

    final void writeScalarStream(boolean bl, boolean bl2, int n, Reader reader, boolean bl3, int n2) throws DisconnectException, SqlException {
        this.writeScalarStream(bl, bl2, n, EncodedInputStream.createUTF16BEStream(reader), bl3, n2);
    }

    protected final int prepScalarStream(boolean bl, boolean bl2, boolean bl3, long l) throws DisconnectException {
        int n = bl3 ? 1 : 0;
        int n2 = this.calculateExtendedLengthByteCount(l + 4L + (long)n);
        if ((long)(10 + n2 + n) + l + (long)this.buffer.position() > 32767L) {
            try {
                if (this.simpleDssFinalize) {
                    this.finalizeDssLength();
                } else {
                    this.finalizePreviousChainedDss(true);
                }
                this.sendBytes(this.netAgent_.getOutputStream());
            }
            catch (IOException iOException) {
                this.netAgent_.throwCommunicationsFailure(iOException);
            }
        }
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.buildDss(true, bl, bl2, 4, this.correlationID_, true);
        } else {
            this.buildDss(true, bl, bl2, 3, this.correlationID_, true);
        }
        return n2;
    }

    protected final void flushExistingDSS() throws DisconnectException {
        try {
            if (this.simpleDssFinalize) {
                this.finalizeDssLength();
            } else {
                this.finalizePreviousChainedDss(true);
            }
            this.sendBytes(this.netAgent_.getOutputStream());
        }
        catch (IOException iOException) {
            this.netAgent_.throwCommunicationsFailure(iOException);
        }
    }

    protected final int flushScalarStreamSegment(long l, int n) throws DisconnectException {
        int n2 = n;
        if (l != 0L) {
            if (Math.min(2L + l, 32767L) > (long)this.buffer.remaining()) {
                try {
                    this.sendBytes(this.netAgent_.getOutputStream());
                }
                catch (IOException iOException) {
                    this.netAgent_.throwCommunicationsFailure(iOException);
                }
            }
            this.dssLengthLocation_ = this.buffer.position();
            this.buffer.putShort((short)-1);
            n2 = (int)Math.min(l, 32765L);
        }
        return n2;
    }

    protected final int flushScalarStreamSegment() throws DisconnectException {
        try {
            this.sendBytes(this.netAgent_.getOutputStream());
        }
        catch (IOException iOException) {
            this.netAgent_.throwCommunicationsFailure(iOException);
        }
        this.dssLengthLocation_ = this.buffer.position();
        return Short.MAX_VALUE;
    }

    protected final void padScalarStreamForError(long l, int n, boolean bl, byte by) throws DisconnectException {
        while (true) {
            this.buffer.put((byte)0);
            --l;
            if (--n > 0) continue;
            n = this.flushScalarStreamSegment(l, n);
            if (l <= 0L) break;
        }
        if (bl) {
            this.writeEXTDTAStatus(by);
        }
    }

    private final void writeExtendedLengthBytes(int n, long l) {
        int n2 = (n - 1) * 8;
        for (int i = 0; i < n; ++i) {
            this.buffer.put((byte)(l >>> n2));
            n2 -= 8;
        }
    }

    protected final void finalizePreviousChainedDss(boolean bl) {
        this.finalizeDssLength();
        int n = this.dssLengthLocation_ + 3;
        byte by = this.buffer.get(n);
        by = (byte)(by | 0x40);
        if (bl) {
            by = (byte)(by | 0x10);
        }
        this.buffer.put(n, by);
    }

    protected final boolean doesRequestContainData() {
        return this.buffer.position() != 0;
    }

    protected final void finalizeDssLength() {
        int n = this.buffer.position() - this.dssLengthLocation_;
        int n2 = n - Short.MAX_VALUE;
        if (n2 > 0) {
            int n3;
            int n4 = n2 / 32765;
            if (n2 % 32765 != 0) {
                ++n4;
            }
            int n5 = this.buffer.position() - 1;
            int n6 = n4 * 2;
            this.ensureLength(n6);
            this.buffer.position(this.buffer.position() + n6);
            boolean bl = true;
            do {
                if ((n3 = n2 % 32765) == 0) {
                    n3 = 32765;
                }
                byte[] byArray = this.buffer.array();
                System.arraycopy(byArray, (n5 -= n3) + 1, byArray, n5 + n6 + 1, n3);
                int n7 = n3 + 2;
                if (bl) {
                    bl = false;
                } else if (n7 == Short.MAX_VALUE) {
                    n7 = 65535;
                }
                this.buffer.putShort(n5 + n6 - 1, (short)n7);
                n6 -= 2;
            } while ((n2 -= n3) > 0);
            n = 65535;
        }
        this.buffer.putShort(this.dssLengthLocation_, (short)n);
    }

    protected final void markLengthBytes(int n) {
        this.ensureLength(4);
        this.mark();
        this.buffer.position(this.buffer.position() + 2);
        this.buffer.putShort((short)n);
    }

    private final void mark() {
        this.markStack_[this.top_++] = this.buffer.position();
    }

    private final int popMark() {
        return this.markStack_[--this.top_];
    }

    protected final void markForCachingPKGNAMCSN() {
        this.mark();
    }

    protected final int popMarkForCachingPKGNAMCSN() {
        return this.popMark();
    }

    protected final void updateLengthBytes() throws SqlException {
        int n = this.popMark();
        int n2 = this.buffer.position() - n;
        int n3 = this.calculateExtendedLengthByteCount(n2);
        if (n3 != 0) {
            this.ensureLength(n3);
            int n4 = n2 - 4;
            int n5 = n + 4;
            byte[] byArray = this.buffer.array();
            System.arraycopy(byArray, n5, byArray, n5 + n3, n4);
            int n6 = (n3 - 1) * 8;
            for (int i = 0; i < n3; ++i) {
                this.buffer.put(n5++, (byte)(n4 >>> n6));
                n6 -= 8;
            }
            this.buffer.position(this.buffer.position() + n3);
            n2 = n3 + 4;
            n2 |= 0x8000;
        }
        this.buffer.putShort(n, (short)n2);
    }

    private final int calculateExtendedLengthByteCount(long l) {
        if (l <= 32767L) {
            return 0;
        }
        if (l <= Integer.MAX_VALUE) {
            return 4;
        }
        if (l <= 0x7FFFFFFFFFFFL) {
            return 6;
        }
        return 8;
    }

    final void padBytes(byte by, int n) {
        this.ensureLength(n);
        for (int i = 0; i < n; ++i) {
            this.buffer.put(by);
        }
    }

    final void write1Byte(int n) {
        this.writeByte((byte)n);
    }

    final void buildTripletHeader(int n, int n2, int n3) {
        this.ensureLength(3);
        this.buffer.put((byte)n);
        this.buffer.put((byte)n2);
        this.buffer.put((byte)n3);
    }

    final void writeLidAndLengths(int[][] nArray, int n, int n2) {
        this.ensureLength(n * 3);
        int n3 = 0;
        while (n3 < n) {
            this.buffer.put((byte)nArray[n2][0]);
            this.buffer.putShort((short)nArray[n2][1]);
            ++n3;
            ++n2;
        }
    }

    final void writeLidAndLengths(int[][] nArray, int n, int n2, boolean bl, Hashtable hashtable) {
        if (!bl) {
            this.writeLidAndLengths(nArray, n, n2);
        } else {
            this.ensureLength(n * 3);
            int n3 = 0;
            while (n3 < n) {
                int n4 = nArray[n2][0];
                Object v = hashtable.get(new Integer(n4));
                int n5 = v == null ? n4 : (Integer)v;
                this.buffer.put((byte)n5);
                this.buffer.putShort((short)nArray[n2][1]);
                ++n3;
                ++n2;
            }
        }
    }

    final void write2Bytes(int n) {
        this.writeShort((short)n);
    }

    final void write4Bytes(long l) {
        this.writeInt((int)l);
    }

    final void writeBytes(byte[] byArray, int n) {
        this.ensureLength(n);
        this.buffer.put(byArray, 0, n);
    }

    final void writeBytes(byte[] byArray) {
        this.writeBytes(byArray, byArray.length);
    }

    final void writeCodePoint4Bytes(int n, int n2) {
        this.ensureLength(4);
        this.buffer.putShort((short)n);
        this.buffer.putShort((short)n2);
    }

    protected final void writeScalar1Byte(int n, int n2) {
        this.ensureLength(5);
        this.buffer.put((byte)0);
        this.buffer.put((byte)5);
        this.buffer.putShort((short)n);
        this.buffer.put((byte)n2);
    }

    final void writeScalar2Bytes(int n, int n2) {
        this.ensureLength(6);
        this.buffer.put((byte)0);
        this.buffer.put((byte)6);
        this.buffer.putShort((short)n);
        this.buffer.putShort((short)n2);
    }

    protected final void writeScalar4Bytes(int n, long l) {
        this.ensureLength(8);
        this.buffer.put((byte)0);
        this.buffer.put((byte)8);
        this.buffer.putShort((short)n);
        this.buffer.putInt((int)l);
    }

    final void writeScalar8Bytes(int n, long l) {
        this.ensureLength(12);
        this.buffer.put((byte)0);
        this.buffer.put((byte)12);
        this.buffer.putShort((short)n);
        this.buffer.putLong(l);
    }

    final void writeLengthCodePoint(int n, int n2) {
        this.ensureLength(4);
        this.buffer.putShort((short)n);
        this.buffer.putShort((short)n2);
    }

    final void writeScalarBytes(int n, byte[] byArray, int n2) {
        this.writeScalarBytes(n, byArray, 0, n2);
    }

    final void writeScalarHeader(int n, int n2) {
        this.writeLengthCodePoint(n2 + 4, n);
        this.ensureLength(n2);
    }

    final void writeScalarString(int n, String string) throws SqlException {
        this.writeScalarString(n, string, 0, Integer.MAX_VALUE, null);
    }

    final void writeScalarString(int n, String string, int n2, int n3, String string2) throws SqlException {
        CcsidManager ccsidManager = this.netAgent_.getCurrentCcsidManager();
        int n4 = this.buffer.position();
        this.writeLengthCodePoint(0, n);
        int n5 = this.encodeString(string);
        if (n5 > n3) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId(string2), string);
        }
        if (n5 < n2) {
            this.padBytes(ccsidManager.space_, n2 - n5);
            n5 = n2;
        }
        this.buffer.putShort(n4, (short)(n5 + 4));
    }

    private int encodeString(String string) throws SqlException {
        int n = this.buffer.position();
        CharBuffer charBuffer = CharBuffer.wrap(string);
        CcsidManager ccsidManager = this.netAgent_.getCurrentCcsidManager();
        ccsidManager.startEncoding();
        while (!ccsidManager.encode(charBuffer, this.buffer, this.netAgent_)) {
            this.ensureLength(this.buffer.remaining() + 1);
        }
        return this.buffer.position() - n;
    }

    final void writeScalarBytes(int n, byte[] byArray) {
        this.writeScalarBytes(n, byArray, 0, byArray.length);
    }

    final void writeScalarBytes(int n, byte[] byArray, int n2, int n3) {
        this.writeLengthCodePoint(n3 + 4, n);
        this.ensureLength(n3);
        this.buffer.put(byArray, n2, n3);
    }

    final void writeScalarPaddedBytes(int n, byte[] byArray, int n2, byte by) {
        this.writeLengthCodePoint(n2 + 4, n);
        this.writeScalarPaddedBytes(byArray, n2, by);
    }

    final void writeScalarPaddedBytes(byte[] byArray, int n, byte by) {
        this.writeBytes(byArray);
        this.padBytes(by, n - byArray.length);
    }

    protected void flush(OutputStream outputStream) throws IOException {
        if (this.doesRequestContainData()) {
            this.finalizeDssLength();
            this.sendBytes(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendBytes(OutputStream outputStream) throws IOException {
        try {
            outputStream.write(this.buffer.array(), 0, this.buffer.position());
            outputStream.flush();
        }
        finally {
            if (this.netAgent_.logWriter_ != null && this.passwordIncluded_) {
                this.maskOutPassword();
                this.passwordIncluded_ = false;
            }
            if (this.netAgent_.loggingEnabled()) {
                ((NetLogWriter)this.netAgent_.logWriter_).traceProtocolFlow(this.buffer.array(), 0, this.buffer.position(), 1, "Request", "flush", 1);
            }
            this.clearBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void maskOutPassword() {
        int n = this.buffer.position();
        try {
            String string = "*";
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.passwordLength_; ++i) {
                stringBuffer.append(string);
            }
            this.buffer.position(this.passwordStart_);
            this.encodeString(stringBuffer.toString());
        }
        catch (SqlException sqlException) {
            for (int i = 0; i < this.passwordLength_; ++i) {
                this.buffer.put(this.passwordStart_ + i, (byte)-1);
            }
        }
        finally {
            this.buffer.position(n);
        }
    }

    final void writeByte(byte by) {
        this.ensureLength(1);
        this.buffer.put(by);
    }

    final void writeShort(short s) {
        this.ensureLength(2);
        this.buffer.putShort(s);
    }

    void writeInt(int n) {
        this.ensureLength(4);
        this.buffer.putInt(n);
    }

    final void writeLong6Bytes(long l) {
        this.ensureLength(6);
        this.buffer.putShort((short)(l >> 32));
        this.buffer.putInt((int)l);
    }

    final void writeLong(long l) {
        this.ensureLength(8);
        this.buffer.putLong(l);
    }

    protected void writeShortFdocaData(short s) {
        this.writeShort(s);
    }

    protected void writeIntFdocaData(int n) {
        this.writeInt(n);
    }

    protected void writeLongFdocaData(long l) {
        this.writeLong(l);
    }

    protected void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    protected void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    final void writeBigDecimal(BigDecimal bigDecimal, int n, int n2) throws SqlException {
        this.ensureLength(16);
        int n3 = Decimal.bigDecimalToPackedDecimalBytes(this.buffer.array(), this.buffer.position(), bigDecimal, n, n2);
        this.buffer.position(this.buffer.position() + n3);
    }

    final void writeDate(DateTimeValue dateTimeValue) throws SqlException {
        try {
            this.ensureLength(10);
            DateTime.dateToDateBytes(this.buffer.array(), this.buffer.position(), dateTimeValue);
            this.buffer.position(this.buffer.position() + 10);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"java.sql.Date", (Object)"DATE", (Throwable)unsupportedEncodingException);
        }
    }

    final void writeTime(DateTimeValue dateTimeValue) throws SqlException {
        try {
            this.ensureLength(8);
            DateTime.timeToTimeBytes(this.buffer.array(), this.buffer.position(), dateTimeValue);
            this.buffer.position(this.buffer.position() + 8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"java.sql.Time", (Object)"TIME", (Throwable)unsupportedEncodingException);
        }
    }

    final void writeTimestamp(DateTimeValue dateTimeValue) throws SqlException {
        try {
            boolean bl = this.netAgent_.netConnection_.serverSupportsTimestampNanoseconds();
            int n = DateTime.getTimestampLength(bl);
            this.ensureLength(n);
            DateTime.timestampToTimestampBytes(this.buffer.array(), this.buffer.position(), dateTimeValue, bl);
            this.buffer.position(this.buffer.position() + n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"java.sql.Timestamp", (Object)"TIMESTAMP", (Throwable)unsupportedEncodingException);
        }
    }

    final void writeBoolean(boolean bl) {
        this.write1Byte(bl ? 1 : 0);
    }

    final void writeSingleorMixedCcsidLDString(String string, String string2) throws SqlException {
        byte[] byArray;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"String", (Object)"byte", (Throwable)unsupportedEncodingException);
        }
        if (byArray.length > Short.MAX_VALUE) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22028"), "32767");
        }
        this.writeLDBytes(byArray);
    }

    final void writeLDBytes(byte[] byArray) {
        this.writeLDBytesX(byArray.length, byArray);
    }

    private final void writeLDBytesX(int n, byte[] byArray) {
        this.writeLDBytesXSubset(n, byArray.length, byArray);
    }

    private final void writeLDBytesXSubset(int n, int n2, byte[] byArray) {
        this.writeShort((short)n);
        this.writeBytes(byArray, n2);
    }

    final void writeUDT(Object object) throws SqlException {
        byte[] byArray = null;
        int n = 0;
        try {
            DynamicByteArrayOutputStream dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(dynamicByteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byArray = dynamicByteArrayOutputStream.getByteArray();
            n = dynamicByteArrayOutputStream.getUsed();
        }
        catch (Exception exception) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN020.S"), (Object)exception.getMessage(), (Throwable)exception);
        }
        if (n > Short.MAX_VALUE) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22003"), (Object)Integer.toString(Short.MAX_VALUE), object.getClass().getName());
        }
        this.writeLDBytesXSubset(n, n, byArray);
    }

    final void writeDDMString(String string) throws SqlException {
        this.encodeString(string);
    }

    private void buildLengthAndCodePointForLob(int n, long l, boolean bl, int n2) throws DisconnectException {
        int n3;
        int n4 = n3 = bl ? 1 : 0;
        if (n2 > 0) {
            this.writeLengthCodePoint(32772 + n2, n);
            this.writeExtendedLengthBytes(n2, l + (long)n3);
        } else {
            this.writeLengthCodePoint((int)(l + 4L + (long)n3), n);
        }
        if (bl) {
            this.write1Byte(0);
        }
    }

    private void buildLengthAndCodePointForLob(int n, boolean bl) throws DisconnectException {
        this.writeLengthCodePoint(32772, n);
        if (bl) {
            this.write1Byte(0);
        }
    }

    private void writeEXTDTAStatus(byte by) throws DisconnectException {
        if (this.buffer.remaining() == 0) {
            this.flushScalarStreamSegment(1L, 0);
        }
        this.buffer.put(by);
    }

    public void setDssLengthLocation(int n) {
        this.dssLengthLocation_ = n;
    }

    public void setCorrelationID(int n) {
        this.correlationID_ = n;
    }

    private static boolean peekStream(BufferedInputStream bufferedInputStream) throws IOException {
        bufferedInputStream.mark(1);
        boolean bl = bufferedInputStream.read() > -1;
        bufferedInputStream.reset();
        return bl;
    }
}

