/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.developer.StreamingAttachmentFeature;
import com.sun.xml.ws.developer.WSBindingProvider;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ACLService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.DiscoveryService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.MultiFilingService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.NavigationService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ObjectService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.PolicyService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RelationshipService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningService;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class PortProvider
extends AbstractPortProvider {
    private static final Log log = LogFactory.getLog(PortProvider.class);

    protected Object createPortObject(Service service) {
        RepositoryServicePort portObject;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating Web Service port object of " + (service == null ? "???" : service.getServiceName()) + "..."));
        }
        try {
            int readTimeout;
            int threshold;
            if (service instanceof RepositoryService) {
                portObject = ((RepositoryService)service).getRepositoryServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof NavigationService) {
                portObject = ((NavigationService)service).getNavigationServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof ObjectService) {
                threshold = this.getSession().get("org.apache.chemistry.opencmis.binding.webservices.memoryThreshold", 0x400000);
                portObject = ((ObjectService)service).getObjectServicePort(new WebServiceFeature[]{new MTOMFeature(), new StreamingAttachmentFeature(null, true, (long)threshold)});
                ((BindingProvider)portObject).getRequestContext().put("com.sun.xml.ws.transport.http.client.streaming.chunk.size", 65535);
            } else if (service instanceof VersioningService) {
                threshold = this.getSession().get("org.apache.chemistry.opencmis.binding.webservices.memoryThreshold", 0x400000);
                portObject = ((VersioningService)service).getVersioningServicePort(new WebServiceFeature[]{new MTOMFeature(), new StreamingAttachmentFeature(null, true, (long)threshold)});
                ((BindingProvider)portObject).getRequestContext().put("com.sun.xml.ws.transport.http.client.streaming.chunk.size", 65535);
            } else if (service instanceof DiscoveryService) {
                portObject = ((DiscoveryService)service).getDiscoveryServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof MultiFilingService) {
                portObject = ((MultiFilingService)service).getMultiFilingServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof RelationshipService) {
                portObject = ((RelationshipService)service).getRelationshipServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof PolicyService) {
                portObject = ((PolicyService)service).getPolicyServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof ACLService) {
                portObject = ((ACLService)service).getACLServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else {
                throw new CmisRuntimeException("Cannot find Web Services service object!");
            }
            AuthenticationProvider authProvider = CmisBindingsHelper.getAuthenticationProvider(this.getSession());
            Map httpHeaders = null;
            if (authProvider != null) {
                Element soapHeader = authProvider.getSOAPHeaders((Object)portObject);
                if (soapHeader != null) {
                    ((WSBindingProvider)portObject).setOutboundHeaders(new Header[]{Headers.create((Element)soapHeader)});
                }
                httpHeaders = authProvider.getHTTPHeaders(service.getWSDLDocumentLocation().toString());
            }
            this.setHTTPHeaders(portObject, httpHeaders);
            int connectTimeout = this.getSession().get("org.apache.chemistry.opencmis.binding.connecttimeout", -1);
            if (connectTimeout >= 0) {
                ((BindingProvider)portObject).getRequestContext().put("com.sun.xml.ws.connect.timeout", connectTimeout);
            }
            if ((readTimeout = this.getSession().get("org.apache.chemistry.opencmis.binding.readtimeout", -1)) >= 0) {
                ((BindingProvider)portObject).getRequestContext().put("com.sun.xml.ws.request.timeout", readTimeout);
            }
        }
        catch (CmisBaseException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CmisConnectionException("Cannot initalize Web Services port object: " + e.getMessage(), (Throwable)e);
        }
        return portObject;
    }
}

