/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursor;
import org.apache.activemq.broker.region.cursors.OrderedPendingList;
import org.apache.activemq.broker.region.cursors.PendingList;
import org.apache.activemq.broker.region.cursors.PrioritizedPendingList;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.store.MessageRecoveryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStoreCursor
extends AbstractPendingMessageCursor
implements MessageRecoveryListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStoreCursor.class);
    protected final Destination regionDestination;
    protected final PendingList batchList;
    private Iterator<MessageReference> iterator = null;
    protected boolean batchResetNeeded = false;
    private boolean storeHasMessages = false;
    protected int size;
    private MessageId lastCachedId;
    private TransactionId lastTx;
    protected boolean hadSpace = false;
    final LinkedList<Message> duplicatesFromStore = new LinkedList();

    protected AbstractStoreCursor(Destination destination) {
        super(destination != null ? destination.isPrioritizedMessages() : false);
        this.regionDestination = destination;
        this.batchList = this.prioritizedMessages ? new PrioritizedPendingList() : new OrderedPendingList();
    }

    @Override
    public final synchronized void start() throws Exception {
        if (!this.isStarted()) {
            super.start();
            this.resetBatch();
            this.resetSize();
            this.setCacheEnabled(!this.storeHasMessages && this.useCache);
        }
    }

    protected void resetSize() {
        this.size = this.getStoreSize();
        this.storeHasMessages = this.size > 0;
    }

    @Override
    public void rebase() {
        this.resetSize();
    }

    @Override
    public final synchronized void stop() throws Exception {
        this.resetBatch();
        super.stop();
        this.gc();
    }

    @Override
    public final boolean recoverMessage(Message message) throws Exception {
        return this.recoverMessage(message, false);
    }

    public synchronized boolean recoverMessage(Message message, boolean cached) throws Exception {
        boolean recovered = false;
        if (this.recordUniqueId(message.getMessageId())) {
            if (!cached) {
                message.setRegionDestination((Message.MessageDestination)this.regionDestination);
                if (message.getMemoryUsage() == null) {
                    message.setMemoryUsage(this.getSystemUsage().getMemoryUsage());
                }
            }
            message.incrementReferenceCount();
            this.batchList.addMessageLast((MessageReference)message);
            this.clearIterator(true);
            recovered = true;
            this.storeHasMessages = true;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " - cursor got duplicate: " + message.getMessageId() + "," + message.getPriority() + ", cached=" + cached, new Throwable("duplicate message detected"));
            } else {
                LOG.warn("{} - cursor got duplicate {}", (Object)this.regionDestination.getActiveMQDestination(), (Object)message.getMessageId());
            }
            if (!cached || message.getMessageId().getEntryLocator() != null) {
                this.duplicate(message);
            }
        }
        return recovered;
    }

    private void duplicate(Message message) {
        this.duplicatesFromStore.add(message);
    }

    void dealWithDuplicates() {
        for (Message message : this.duplicatesFromStore) {
            this.regionDestination.duplicateFromStore(message, this.getSubscription());
        }
        this.duplicatesFromStore.clear();
    }

    @Override
    public final synchronized void reset() {
        if (this.batchList.isEmpty()) {
            try {
                this.fillBatch();
            }
            catch (Exception e) {
                LOG.error("{} - Failed to fill batch", (Object)this, (Object)e);
                throw new RuntimeException(e);
            }
        }
        this.clearIterator(true);
        this.size();
    }

    @Override
    public synchronized void release() {
        this.clearIterator(false);
    }

    private synchronized void clearIterator(boolean ensureIterator) {
        boolean haveIterator = this.iterator != null;
        this.iterator = null;
        if (haveIterator && ensureIterator) {
            this.ensureIterator();
        }
    }

    private synchronized void ensureIterator() {
        if (this.iterator == null) {
            this.iterator = this.batchList.iterator();
        }
    }

    public final void finished() {
    }

    @Override
    public final synchronized boolean hasNext() {
        if (this.batchList.isEmpty()) {
            try {
                this.fillBatch();
            }
            catch (Exception e) {
                LOG.error("{} - Failed to fill batch", (Object)this, (Object)e);
                throw new RuntimeException(e);
            }
        }
        this.ensureIterator();
        return this.iterator.hasNext();
    }

    @Override
    public final synchronized MessageReference next() {
        MessageReference result = null;
        if (!this.batchList.isEmpty() && this.iterator.hasNext()) {
            result = this.iterator.next();
        }
        this.last = result;
        if (result != null) {
            result.incrementReferenceCount();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final synchronized void addMessageLast(MessageReference node) throws Exception {
        boolean disableCache = false;
        if (this.hasSpace()) {
            if (!this.isCacheEnabled() && this.size == 0 && this.isStarted() && this.useCache) {
                LOG.trace("{} - enabling cache for empty store {}", (Object)this, (Object)node.getMessageId());
                this.setCacheEnabled(true);
            }
            if (this.isCacheEnabled()) {
                if (!this.recoverMessage(node.getMessage(), true)) {
                    this.dealWithDuplicates();
                    return;
                }
                this.lastCachedId = node.getMessageId();
                this.lastTx = node.getMessage().getTransactionId();
            }
        } else {
            disableCache = true;
        }
        if (disableCache && this.isCacheEnabled()) {
            this.setCacheEnabled(false);
            if (this.lastCachedId != null) {
                LOG.debug("{} - disabling cache, lastCachedId: {} last-tx: {} current node Id: {} node-tx: {} batchList size: {}", new Object[]{this, this.lastCachedId, this.lastTx, node.getMessageId(), node.getMessage().getTransactionId(), this.batchList.size()});
                this.setBatch(this.lastCachedId);
                this.lastCachedId = null;
                this.lastTx = null;
            }
        }
        this.storeHasMessages = true;
        ++this.size;
    }

    protected void setBatch(MessageId messageId) throws Exception {
    }

    @Override
    public synchronized void addMessageFirst(MessageReference node) throws Exception {
        this.setCacheEnabled(false);
        ++this.size;
    }

    @Override
    public final synchronized void remove() {
        --this.size;
        if (this.iterator != null) {
            this.iterator.remove();
        }
        if (this.last != null) {
            this.last.decrementReferenceCount();
        }
    }

    @Override
    public final synchronized void remove(MessageReference node) {
        if (this.batchList.remove(node) != null) {
            --this.size;
            this.setCacheEnabled(false);
        }
    }

    @Override
    public final synchronized void clear() {
        this.gc();
    }

    @Override
    public synchronized void gc() {
        for (MessageReference msg : this.batchList) {
            this.rollback(msg.getMessageId());
            msg.decrementReferenceCount();
        }
        this.batchList.clear();
        this.clearIterator(false);
        this.batchResetNeeded = true;
        this.setCacheEnabled(false);
    }

    @Override
    protected final synchronized void fillBatch() {
        if (this.batchResetNeeded) {
            this.resetSize();
            this.setMaxBatchSize(Math.min(this.regionDestination.getMaxPageSize(), this.size));
            this.resetBatch();
            this.batchResetNeeded = false;
        }
        if (this.batchList.isEmpty() && this.storeHasMessages && this.size > 0) {
            try {
                this.doFillBatch();
            }
            catch (Exception e) {
                LOG.error("{} - Failed to fill batch", (Object)this, (Object)e);
                throw new RuntimeException(e);
            }
            this.storeHasMessages = !this.batchList.isEmpty() || !this.hadSpace;
        }
    }

    @Override
    public final synchronized boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final synchronized boolean hasMessagesBufferedToDeliver() {
        return !this.batchList.isEmpty();
    }

    @Override
    public final synchronized int size() {
        if (this.size < 0) {
            this.size = this.getStoreSize();
        }
        return this.size;
    }

    public String toString() {
        return super.toString() + ":" + this.regionDestination.getActiveMQDestination().getPhysicalName() + ",batchResetNeeded=" + this.batchResetNeeded + ",storeHasMessages=" + this.storeHasMessages + ",size=" + this.size + ",cacheEnabled=" + this.isCacheEnabled() + ",maxBatchSize:" + this.maxBatchSize + ",hasSpace:" + this.hasSpace();
    }

    protected abstract void doFillBatch() throws Exception;

    protected abstract void resetBatch();

    protected abstract int getStoreSize();

    protected abstract boolean isStoreEmpty();

    public Subscription getSubscription() {
        return null;
    }
}

