/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.repositories.mdr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofPackage;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.metafacade.ModelAccessFacade;
import org.andromda.core.repository.RepositoryFacade;
import org.andromda.core.repository.RepositoryFacadeException;
import org.andromda.repositories.mdr.MDRXmiReferenceResolver;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.netbeans.api.mdr.CreationFailedException;
import org.netbeans.api.mdr.MDRManager;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.xmi.XMIInputConfig;
import org.netbeans.api.xmi.XMIReader;
import org.netbeans.api.xmi.XMIReaderFactory;
import org.netbeans.api.xmi.XMIWriter;
import org.netbeans.api.xmi.XMIWriterFactory;

public class MDRepositoryFacade
implements RepositoryFacade {
    private static final Logger logger = Logger.getLogger(MDRepositoryFacade.class);
    private ModelAccessFacade modelFacade = null;
    private MDRepository repository = null;
    protected URL metamodelUri;
    protected RefPackage model = null;
    private boolean open = false;
    private static final String DEFAULT_XMI_VERSION = "1.2";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private String metamodelPackage;
    private String xmiReaderFactory;
    private Map<String, XMIReaderFactory> xmiReaderFactoryInstances = new HashMap<String, XMIReaderFactory>();
    private Class modelAccessFacade;
    private static final String EXTENT_NAME = "model";

    public MDRepositoryFacade() {
        System.setProperty("org.netbeans.mdr.storagemodel.StorageFactoryClassName", "org.netbeans.mdr.persistence.memoryimpl.StorageFactoryImpl");
        MDRManager mdrManager = MDRManager.getDefault();
        if (mdrManager == null) {
            throw new RepositoryFacadeException("Could not retrieve the MDR manager");
        }
        this.repository = mdrManager.getDefaultRepository();
    }

    public void open() {
        if (!this.open) {
            this.repository.beginTrans(true);
            this.open = true;
        }
    }

    public void close() {
        if (this.open) {
            this.repository.endTrans(false);
            this.clear();
            MDRManager.getDefault().shutdownAll();
            this.open = false;
        }
    }

    public void readModel(String[] uris, String[] moduleSearchPath) {
        try {
            MofPackage metaModel = this.loadMetaModel(this.getMetamodelUri());
            this.model = this.loadModel(uris, moduleSearchPath, metaModel);
        }
        catch (Throwable throwable) {
            throw new RepositoryFacadeException(throwable);
        }
    }

    private URL getMetamodelUri() {
        if (this.metamodelUri == null) {
            throw new RepositoryFacadeException("No metamodel was defined");
        }
        return this.metamodelUri;
    }

    public void readModel(InputStream[] streams, String[] uris, String[] moduleSearchPath) {
        if (streams != null && uris != null && uris.length != streams.length) {
            throw new IllegalArgumentException("'streams' and 'uris' must be of the same length");
        }
        try {
            MofPackage metaModel = this.loadMetaModel(this.getMetamodelUri());
            this.model = this.loadModel(streams, uris, moduleSearchPath, metaModel);
        }
        catch (Throwable throwable) {
            throw new RepositoryFacadeException(throwable);
        }
    }

    public void writeModel(Object model, String outputLocation, String xmiVersion) {
        this.writeModel(model, outputLocation, xmiVersion, null);
    }

    public void setMetamodelLocation(String metamodelLocation) {
        this.metamodelUri = MDRepositoryFacade.class.getResource(metamodelLocation);
        if (this.metamodelUri == null) {
            ResourceUtils.toURL((String)metamodelLocation);
        }
        if (this.metamodelUri == null) {
            throw new RepositoryFacadeException("No metamodel could be loaded from --> '" + metamodelLocation + '\'');
        }
    }

    public void setMetamodelPackage(String metamodelPackage) {
        this.metamodelPackage = metamodelPackage;
    }

    public void setXmiReaderFactory(String xmiReaderFactory) {
        this.xmiReaderFactory = xmiReaderFactory;
    }

    private synchronized XMIReaderFactory getXMIReaderFactory() throws InstantiationException, IllegalAccessException {
        XMIReaderFactory factory = this.xmiReaderFactoryInstances.get(this.xmiReaderFactory);
        if (factory == null) {
            if (StringUtils.isBlank((String)this.xmiReaderFactory)) {
                throw new RepositoryFacadeException("No 'xmiReaderFactory' has been set");
            }
            Object instance = ClassUtils.loadClass((String)this.xmiReaderFactory).newInstance();
            if (instance instanceof XMIReaderFactory) {
                factory = (XMIReaderFactory)instance;
                this.xmiReaderFactoryInstances.put(this.xmiReaderFactory, factory);
            } else {
                throw new RepositoryFacadeException("The 'xmiReaderFactory' must be an instance of '" + XMIReaderFactory.class.getName() + '\'');
            }
        }
        return factory;
    }

    public void writeModel(Object model, String outputLocation, String xmiVersion, String encoding) {
        ExceptionUtils.checkNull((String)EXTENT_NAME, (Object)model);
        ExceptionUtils.checkNull((String)"outputLocation", (Object)outputLocation);
        ExceptionUtils.checkAssignable(RefPackage.class, (String)EXTENT_NAME, model.getClass());
        if (StringUtils.isEmpty((String)xmiVersion)) {
            xmiVersion = DEFAULT_XMI_VERSION;
        }
        if (StringUtils.isEmpty((String)encoding)) {
            encoding = DEFAULT_ENCODING;
        }
        try {
            File file = new File(outputLocation);
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            FileOutputStream outputStream = new FileOutputStream(file);
            XMIWriter xmiWriter = XMIWriterFactory.getDefault().createXMIWriter();
            xmiWriter.getConfiguration().setEncoding(encoding);
            xmiWriter.write((OutputStream)outputStream, outputLocation, (RefPackage)model, xmiVersion);
            outputStream.close();
            outputStream = null;
        }
        catch (Throwable throwable) {
            throw new RepositoryFacadeException(throwable);
        }
    }

    public void setModelAccessFacade(Class modelAccessFacade) {
        this.modelAccessFacade = modelAccessFacade;
    }

    public ModelAccessFacade getModel() {
        if (this.modelFacade == null) {
            try {
                this.modelFacade = (ModelAccessFacade)ComponentContainer.instance().newComponent(this.modelAccessFacade, ModelAccessFacade.class);
            }
            catch (Throwable throwable) {
                throw new RepositoryFacadeException(throwable);
            }
        }
        if (this.model != null) {
            this.modelFacade.setModel((Object)this.model);
        } else {
            this.modelFacade = null;
        }
        return this.modelFacade;
    }

    private MofPackage loadMetaModel(URL metamodelUri) throws Exception {
        MofPackage metaModelPackage;
        ModelPackage metaModelExtent;
        long start = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("creating MetaModel using URL --> '" + metamodelUri + '\''));
        }
        if ((metaModelExtent = (ModelPackage)this.repository.getExtent(metamodelUri.toExternalForm())) == null) {
            metaModelExtent = (ModelPackage)this.repository.createExtent(metamodelUri.toExternalForm());
        }
        if ((metaModelPackage = this.findPackage(this.metamodelPackage, metaModelExtent)) == null) {
            XMIReader xmiReader = this.getXMIReaderFactory().createXMIReader();
            xmiReader.read(metamodelUri.toExternalForm(), (RefPackage)metaModelExtent);
            metaModelPackage = this.findPackage(this.metamodelPackage, metaModelExtent);
        }
        if (logger.isDebugEnabled()) {
            long duration = System.currentTimeMillis() - start;
            logger.debug((Object)("MDRepositoryFacade: loaded metamodel in " + duration + " milliseconds"));
        }
        return metaModelPackage;
    }

    public void clear() {
        this.removeModel(EXTENT_NAME);
        this.model = null;
        this.modelFacade = null;
    }

    private void removeModel(String modelUri) {
        RefPackage model = this.repository.getExtent(modelUri);
        if (model != null) {
            model.refDelete();
        }
    }

    private RefPackage loadModel(String[] modelUris, String[] moduleSearchPath, MofPackage metaModel) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("loadModel: starting to load model from '" + modelUris[0] + '\''));
        }
        long start = System.currentTimeMillis();
        RefPackage model = null;
        if (modelUris != null) {
            model = this.createModel(metaModel);
            XMIReader xmiReader = this.getXMIReaderFactory().createXMIReader((XMIInputConfig)new MDRXmiReferenceResolver(new RefPackage[]{model}, moduleSearchPath));
            try {
                int uriNumber = modelUris.length;
                for (int ctr = 0; ctr < uriNumber; ++ctr) {
                    String uri = modelUris[ctr];
                    if (uri == null) continue;
                    xmiReader.read(modelUris[ctr], model);
                }
            }
            catch (Throwable throwable) {
                throw new RepositoryFacadeException(throwable);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"read URIs and created model");
            }
        }
        if (logger.isDebugEnabled()) {
            long duration = System.currentTimeMillis() - start;
            logger.debug((Object)("loadModel: finished loading model in " + duration + " milliseconds."));
        }
        return model;
    }

    private RefPackage loadModel(InputStream[] modelStreams, String[] uris, String[] moduleSearchPaths, MofPackage metaModel) throws Exception {
        RefPackage model = this.createModel(metaModel);
        if (modelStreams != null) {
            XMIReader xmiReader = this.getXMIReaderFactory().createXMIReader((XMIInputConfig)new MDRXmiReferenceResolver(new RefPackage[]{model}, moduleSearchPaths));
            try {
                int streamNumber = modelStreams.length;
                for (int ctr = 0; ctr < streamNumber; ++ctr) {
                    InputStream stream = modelStreams[ctr];
                    String uri = null;
                    if (uris != null) {
                        uri = uris[ctr];
                    }
                    if (stream == null) continue;
                    xmiReader.read(stream, uri, model);
                }
            }
            catch (Throwable throwable) {
                throw new RepositoryFacadeException(throwable);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"read URIs and created model");
            }
        }
        return model;
    }

    private RefPackage createModel(MofPackage metaModel) throws CreationFailedException {
        RefPackage model = this.repository.getExtent(EXTENT_NAME);
        if (model != null) {
            this.removeModel(EXTENT_NAME);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"creating the new meta model");
        }
        model = this.repository.createExtent(EXTENT_NAME, (RefObject)metaModel);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"created model extent");
        }
        return model;
    }

    private MofPackage findPackage(String packageName, ModelPackage metaModel) {
        MofPackage mofPackage = null;
        for (ModelElement element : metaModel.getMofPackage().refAllOfClass()) {
            if (!element.getName().equals(packageName)) continue;
            mofPackage = (MofPackage)element;
            break;
        }
        return mofPackage;
    }
}

