/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.repositories.mdr;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jmi.reflect.RefPackage;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ResourceUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.netbeans.api.xmi.XMIInputConfig;
import org.netbeans.lib.jmi.xmi.XmiContext;

public class MDRXmiReferenceResolverContext
extends XmiContext {
    private String[] moduleSearchPaths;
    private static final Logger logger = Logger.getLogger(MDRXmiReferenceResolverContext.class);
    private static final Map<String, URL> urlMap = new HashMap<String, URL>();
    private final Collection<URL> loggedReferencedModels = new ArrayList<URL>();
    protected static final String[] CLASSPATH_MODEL_SUFFIXES = new String[]{"xml", "xmi"};

    public MDRXmiReferenceResolverContext(RefPackage[] extents, XMIInputConfig config, String[] moduleSearchPaths) {
        super(extents, config);
        this.moduleSearchPaths = moduleSearchPaths;
    }

    public URL toURL(String systemId) {
        String exts;
        String suffix;
        String suffixWithExt;
        URL modelUrl;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("attempting to resolve Xmi Href --> '" + systemId + '\''));
        }
        if ((modelUrl = urlMap.get(suffixWithExt = (suffix = this.getSuffix(systemId)).replaceAll(exts = "\\.jar|\\.zip", ""))) == null) {
            modelUrl = this.getValidURL(systemId);
            if (modelUrl == null) {
                String modelUrlAsString = this.findModuleUrl(suffix);
                if (StringUtils.isNotBlank((String)modelUrlAsString)) {
                    modelUrl = this.getValidURL(modelUrlAsString);
                }
                if (modelUrl == null) {
                    modelUrl = this.findModelUrlOnClasspath(systemId);
                }
                if (modelUrl == null) {
                    modelUrl = super.toURL(systemId);
                }
            }
            if (modelUrl != null) {
                urlMap.put(suffixWithExt, modelUrl);
            }
        }
        if (modelUrl != null && !this.loggedReferencedModels.contains(modelUrl)) {
            AndroMDALogger.info((Object)("referenced model --> '" + modelUrl + '\''));
            this.loggedReferencedModels.add(modelUrl);
        }
        return modelUrl;
    }

    private final String findModuleUrl(String moduleName) {
        String moduleUrl = null;
        if (this.moduleSearchPaths != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("findModuleURL: moduleSearchPath.length=" + this.moduleSearchPaths.length));
            }
            for (int ctr = 0; ctr < this.moduleSearchPaths.length; ++ctr) {
                String moduleSearchPath = this.moduleSearchPaths[ctr];
                if (!StringUtils.isNotBlank((String)moduleSearchPath)) continue;
                if (moduleSearchPath.endsWith(moduleName)) {
                    moduleUrl = moduleSearchPath;
                } else {
                    File candidate = new File(moduleSearchPath, moduleName);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("candidate '" + candidate.toString() + "' exists=" + candidate.exists()));
                    }
                    if (candidate.exists()) {
                        try {
                            moduleUrl = candidate.toURI().toURL().toExternalForm();
                        }
                        catch (MalformedURLException exception) {
                            // empty catch block
                        }
                    }
                }
                if (moduleUrl != null && moduleName.endsWith(".zip") || moduleName.endsWith(".jar")) {
                    moduleUrl = "jar:" + moduleUrl + "!/" + moduleName.substring(0, moduleName.length() - 4);
                }
                if (StringUtils.isNotBlank((String)moduleUrl)) break;
            }
        }
        return moduleUrl;
    }

    private final String getSuffix(String systemId) {
        int lastSlash = systemId.lastIndexOf(47);
        if (lastSlash > 0) {
            String suffix = systemId.substring(lastSlash + 1);
            return suffix;
        }
        return systemId;
    }

    private final URL findModelUrlOnClasspath(String systemId) {
        String modelName = StringUtils.substringAfterLast((String)systemId, (String)"/");
        String dot = ".";
        modelName = StringUtils.substringBeforeLast((String)modelName, (String)dot);
        URL modelUrl = null;
        if (StringUtils.isNotBlank((String)modelName) && (modelUrl = ResourceUtils.getResource((String)modelName)) == null && CLASSPATH_MODEL_SUFFIXES != null && CLASSPATH_MODEL_SUFFIXES.length > 0) {
            int suffixNum = CLASSPATH_MODEL_SUFFIXES.length;
            for (int ctr = 0; ctr < suffixNum; ++ctr) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("searching for model reference --> '" + modelUrl + '\''));
                }
                String suffix = CLASSPATH_MODEL_SUFFIXES[ctr];
                modelUrl = ResourceUtils.getResource((String)(modelName + dot + suffix));
                if (modelUrl != null) break;
            }
        }
        return modelUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final URL getValidURL(String systemId) {
        InputStream stream = null;
        URL url = null;
        try {
            url = new URL(systemId);
            stream = url.openStream();
            stream.close();
        }
        catch (Exception exception) {
            url = null;
        }
        finally {
            stream = null;
        }
        return url;
    }
}

