/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml14;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.ConstraintFacade;
import org.andromda.metafacades.uml.DependencyFacade;
import org.andromda.metafacades.uml.MetafacadeUtils;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.NameMasker;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.ParameterFacade;
import org.andromda.metafacades.uml.TypeMappings;
import org.andromda.metafacades.uml.UMLProfile;
import org.andromda.metafacades.uml14.OperationFacadeLogic;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.Operation;
import org.omg.uml.foundation.core.Parameter;
import org.omg.uml.foundation.datatypes.CallConcurrencyKind;
import org.omg.uml.foundation.datatypes.CallConcurrencyKindEnum;
import org.omg.uml.foundation.datatypes.ParameterDirectionKindEnum;
import org.omg.uml.foundation.datatypes.ScopeKindEnum;

public class OperationFacadeLogicImpl
extends OperationFacadeLogic {
    private static final long serialVersionUID = 34L;
    private static final Logger logger = Logger.getLogger(OperationFacadeLogicImpl.class);

    public OperationFacadeLogicImpl(Operation metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetName() {
        String nameMask = String.valueOf(this.getConfiguredProperty("operationNameMask"));
        return NameMasker.mask((String)super.handleGetName(), (String)nameMask);
    }

    public ClassifierFacade getValidationOwner() {
        return this.getOwner();
    }

    @Override
    protected String handleGetSignature() {
        return this.getSignature(true);
    }

    @Override
    protected String handleGetSignature(boolean withArgumentNames) {
        return MetafacadeUtils.getSignature((String)this.getName(), this.getArguments(), (boolean)withArgumentNames, null);
    }

    @Override
    protected String handleGetTypedArgumentList() {
        return this.getTypedArgumentList(true);
    }

    private String getTypedArgumentList(boolean withArgumentNames) {
        return this.getTypedArgumentList(withArgumentNames, null);
    }

    @Override
    protected String handleGetCall() {
        return this.getCall(this.getName());
    }

    private String getCall(String name) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(name);
        buffer.append('(');
        buffer.append(this.getArgumentNames());
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    protected String handleGetArgumentNames() {
        StringBuilder buffer = new StringBuilder();
        Iterator iterator = this.metaObject.getParameter().iterator();
        boolean commaNeeded = false;
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (ParameterDirectionKindEnum.PDK_RETURN.equals((Object)parameter.getKind())) continue;
            if (commaNeeded) {
                buffer.append(", ");
            }
            ParameterFacade facade = (ParameterFacade)this.shieldedElement(parameter);
            buffer.append(facade.getName());
            commaNeeded = true;
        }
        return buffer.toString();
    }

    @Override
    protected String handleGetArgumentTypeNames() {
        StringBuilder buffer = new StringBuilder();
        Iterator iterator = this.metaObject.getParameter().iterator();
        boolean commaNeeded = false;
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (ParameterDirectionKindEnum.PDK_RETURN.equals((Object)parameter.getKind())) continue;
            if (commaNeeded) {
                buffer.append(", ");
            }
            ParameterFacade facade = (ParameterFacade)this.shieldedElement(parameter);
            buffer.append(facade.getType().getFullyQualifiedName());
            commaNeeded = true;
        }
        return buffer.toString();
    }

    @Override
    protected String handleGetGetterSetterReturnTypeName() {
        if (this.getReturnType() == null) {
            return "";
        }
        return this.getReturnType().getFullyQualifiedName();
    }

    protected Classifier handleGetReturnType() {
        Classifier type = null;
        List parms = this.metaObject.getParameter();
        for (Parameter parameter : parms) {
            if (!ParameterDirectionKindEnum.PDK_RETURN.equals((Object)parameter.getKind())) continue;
            type = parameter.getType();
            break;
        }
        return type;
    }

    @Override
    protected Collection<Parameter> handleGetArguments() {
        ArrayList<Parameter> arguments = new ArrayList<Parameter>(this.metaObject.getParameter());
        CollectionUtils.filter(arguments, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return !ParameterDirectionKindEnum.PDK_RETURN.equals((Object)((Parameter)object).getKind());
            }
        });
        return arguments;
    }

    @Override
    protected String handleGetMethodBody() {
        return null;
    }

    protected Classifier handleGetOwner() {
        return this.metaObject.getOwner();
    }

    @Override
    protected Collection<Parameter> handleGetParameters() {
        return this.metaObject.getParameter();
    }

    @Override
    protected Object handleFindTaggedValue(String name, boolean follow) {
        name = StringUtils.trimToEmpty((String)name);
        Object value = this.findTaggedValue(name);
        if (follow) {
            for (ClassifierFacade type = this.getReturnType(); value == null && type != null; type = (ClassifierFacade)type.getGeneralization()) {
                value = type.findTaggedValue(name);
            }
        }
        return value;
    }

    @Override
    protected boolean handleIsStatic() {
        return ScopeKindEnum.SK_CLASSIFIER.equals((Object)this.metaObject.getOwnerScope());
    }

    @Override
    protected boolean handleIsAbstract() {
        return this.metaObject.isAbstract();
    }

    @Override
    protected boolean handleIsLeaf() {
        return this.metaObject.isLeaf();
    }

    @Override
    protected boolean handleIsMany() {
        boolean isMany = false;
        if (null != this.getReturnParameter()) {
            isMany = this.getReturnParameter().isMany();
        }
        return isMany;
    }

    @Override
    protected boolean handleIsOrdered() {
        return false;
    }

    @Override
    protected boolean handleIsUnique() {
        return this.hasStereotype(UMLProfile.STEREOTYPE_UNIQUE);
    }

    @Override
    protected boolean handleIsQuery() {
        return this.metaObject.isQuery();
    }

    @Override
    protected boolean handleIsExceptionsPresent() {
        return !this.getExceptions().isEmpty();
    }

    @Override
    protected Collection<ModelElementFacade> handleGetExceptions() {
        final class ExceptionFilter
        implements Predicate {
            ExceptionFilter() {
            }

            public boolean evaluate(Object object) {
                DependencyFacade dependency;
                boolean hasException = object instanceof DependencyFacade;
                if (hasException && !(hasException = (dependency = (DependencyFacade)object).hasStereotype(UMLProfile.STEREOTYPE_EXCEPTION_REF))) {
                    ModelElementFacade targetElement = dependency.getTargetElement();
                    hasException = targetElement != null && targetElement.hasStereotype(UMLProfile.STEREOTYPE_EXCEPTION);
                }
                return hasException;
            }
        }
        ArrayList<DependencyFacade> operationDependencies;
        LinkedHashSet<ModelElementFacade> exceptions = new LinkedHashSet<ModelElementFacade>();
        ArrayList ownerDependencies = new ArrayList(this.getOwner().getSourceDependencies());
        if (!ownerDependencies.isEmpty()) {
            CollectionUtils.filter(ownerDependencies, (Predicate)new ExceptionFilter());
            exceptions.addAll(ownerDependencies);
        }
        if (!(operationDependencies = new ArrayList<DependencyFacade>(this.getSourceDependencies())).isEmpty()) {
            CollectionUtils.filter(operationDependencies, (Predicate)new ExceptionFilter());
            exceptions.addAll(operationDependencies);
        }
        CollectionUtils.transform(exceptions, (Transformer)new Transformer(){

            public ModelElementFacade transform(Object object) {
                return ((DependencyFacade)object).getTargetElement();
            }
        });
        return exceptions;
    }

    @Override
    protected String handleGetExceptionList() {
        return this.getExceptionList(null);
    }

    @Override
    protected boolean handleIsReturnTypePresent() {
        boolean hasReturnType = false;
        if (this.getReturnType() != null) {
            hasReturnType = !"void".equalsIgnoreCase(StringUtils.trimToEmpty((String)this.getReturnType().getFullyQualifiedName())) && !StringUtils.trimToEmpty((String)this.getReturnType().getFullyQualifiedName(true)).equals(UMLProfile.VOID_TYPE_NAME);
        }
        return hasReturnType;
    }

    @Override
    protected String handleGetExceptionList(String initialExceptions) {
        initialExceptions = StringUtils.trimToEmpty((String)initialExceptions);
        StringBuilder exceptionList = new StringBuilder(initialExceptions);
        Collection exceptions = this.getExceptions();
        if (exceptions != null && !exceptions.isEmpty()) {
            if (StringUtils.isNotBlank((String)initialExceptions)) {
                exceptionList.append(", ");
            }
            Iterator exceptionIt = exceptions.iterator();
            while (exceptionIt.hasNext()) {
                ModelElementFacade exception = (ModelElementFacade)exceptionIt.next();
                exceptionList.append(exception.getFullyQualifiedName());
                if (!exceptionIt.hasNext()) continue;
                exceptionList.append(", ");
            }
        }
        return exceptionList.toString();
    }

    @Override
    protected String handleGetTypedArgumentList(String modifier) {
        return this.getTypedArgumentList(true, modifier);
    }

    @Override
    protected String handleGetSignature(String argumentModifier) {
        return MetafacadeUtils.getSignature((String)this.getName(), this.getArguments(), (boolean)true, (String)argumentModifier);
    }

    private String getTypedArgumentList(boolean withArgumentNames, String modifier) {
        StringBuilder buffer = new StringBuilder();
        Iterator parameterIterator = this.metaObject.getParameter().iterator();
        boolean commaNeeded = false;
        while (parameterIterator.hasNext()) {
            Parameter paramter = (Parameter)parameterIterator.next();
            if (ParameterDirectionKindEnum.PDK_RETURN.equals((Object)paramter.getKind())) continue;
            String type = null;
            if (paramter.getType() == null) {
                logger.error((Object)("ERROR! No type specified for parameter --> '" + paramter.getName() + "' on operation --> '" + this.getName() + "', please check your model"));
            } else {
                type = ((ClassifierFacade)this.shieldedElement(paramter.getType())).getFullyQualifiedName();
            }
            if (commaNeeded) {
                buffer.append(", ");
            }
            if (StringUtils.isNotBlank((String)modifier)) {
                buffer.append(modifier);
                buffer.append(' ');
            }
            buffer.append(type);
            if (withArgumentNames) {
                buffer.append(' ');
                buffer.append(paramter.getName());
            }
            commaNeeded = true;
        }
        return buffer.toString();
    }

    @Override
    protected String handleGetConcurrency() {
        CallConcurrencyKind concurrencyKind = this.metaObject.getConcurrency();
        String concurrency = concurrencyKind == null || CallConcurrencyKindEnum.CCK_CONCURRENT.equals((Object)concurrencyKind) ? "concurrent" : (CallConcurrencyKindEnum.CCK_GUARDED.equals((Object)concurrencyKind) ? "guarded" : "sequential");
        TypeMappings languageMappings = this.getLanguageMappings();
        if (languageMappings != null) {
            concurrency = languageMappings.getTo(concurrency);
        }
        return concurrency;
    }

    @Override
    protected String handleGetPreconditionName() {
        return this.getPreconditionPattern().replaceAll("\\{0\\}", this.getName());
    }

    @Override
    protected String handleGetPostconditionName() {
        return this.getPostconditionPattern().replaceAll("\\{0\\}", this.getName());
    }

    @Override
    protected String handleGetPreconditionSignature() {
        return MetafacadeUtils.getSignature((String)this.getPreconditionName(), this.getArguments(), (boolean)true, null);
    }

    @Override
    protected String handleGetPreconditionCall() {
        return this.getCall(this.getPreconditionName());
    }

    private String getPreconditionPattern() {
        return String.valueOf(this.getConfiguredProperty("preconditionNamePattern"));
    }

    private String getPostconditionPattern() {
        return String.valueOf(this.getConfiguredProperty("postconditionNamePattern"));
    }

    @Override
    protected boolean handleIsPreconditionsPresent() {
        Collection<ConstraintFacade> preconditions = this.getPreconditions();
        return preconditions != null && !preconditions.isEmpty();
    }

    @Override
    protected boolean handleIsPostconditionsPresent() {
        Collection<ConstraintFacade> postconditions = this.getPostconditions();
        return postconditions != null && !postconditions.isEmpty();
    }

    @Override
    protected Collection<ConstraintFacade> handleGetPreconditions() {
        return this.getConstraints("pre");
    }

    @Override
    protected Collection<ConstraintFacade> handleGetPostconditions() {
        return this.getConstraints("post");
    }

    @Override
    protected ParameterFacade handleFindParameter(final String name) {
        return (ParameterFacade)CollectionUtils.find(this.getParameters(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                ParameterFacade parameter = (ParameterFacade)object;
                return StringUtils.trimToEmpty((String)parameter.getName()).equals(name);
            }
        });
    }

    @Override
    protected int handleGetUpper() {
        if (this.isMany()) {
            return -1;
        }
        return 1;
    }

    @Override
    protected int handleGetLower() {
        if (!this.getReturnParameter().hasStereotype("Nullable") && this.getReturnType().isPrimitive()) {
            return 1;
        }
        return 0;
    }

    @Override
    public ParameterFacade handleGetReturnParameter() {
        ParameterFacade facade = null;
        List parms = this.metaObject.getParameter();
        for (Parameter parameter : parms) {
            if (!ParameterDirectionKindEnum.PDK_RETURN.equals((Object)parameter.getKind())) continue;
            facade = (ParameterFacade)this.shieldedElement(parameter);
            break;
        }
        return facade;
    }

    @Override
    protected boolean handleIsOverriding() {
        return this.getOverriddenOperation() != null;
    }

    protected OperationFacade handleGetOverriddenOperation() {
        OperationFacade overriddenOperation = null;
        String signature = this.getSignature(false);
        for (ClassifierFacade ancestor = this.getOwner().getSuperClass(); overriddenOperation == null && ancestor != null; ancestor = ancestor.getSuperClass()) {
            Iterator operationIterator = ancestor.getOperations().iterator();
            while (overriddenOperation == null && operationIterator.hasNext()) {
                OperationFacade ancestorOperation = (OperationFacade)operationIterator.next();
                if (!signature.equals(ancestorOperation.getSignature(false))) continue;
                overriddenOperation = ancestorOperation;
            }
        }
        return overriddenOperation;
    }

    private boolean isPluralizeAssociationEndNames() {
        Object value = this.getConfiguredProperty("pluralizeAssociationEndNames");
        return value != null && Boolean.valueOf(String.valueOf(value)) != false;
    }
}

