/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml14;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.andromda.core.metafacade.MetafacadeBase;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.andromda.metafacades.uml.BindingFacade;
import org.andromda.metafacades.uml.ConstraintFacade;
import org.andromda.metafacades.uml.DependencyFacade;
import org.andromda.metafacades.uml.EnumerationLiteralFacade;
import org.andromda.metafacades.uml.MetafacadeUtils;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.NameMasker;
import org.andromda.metafacades.uml.ParameterFacade;
import org.andromda.metafacades.uml.RedefinableTemplateSignatureFacade;
import org.andromda.metafacades.uml.StereotypeFacade;
import org.andromda.metafacades.uml.TaggedValueFacade;
import org.andromda.metafacades.uml.TemplateArgumentFacade;
import org.andromda.metafacades.uml.TemplateParameterFacade;
import org.andromda.metafacades.uml.TypeMappings;
import org.andromda.metafacades.uml.UMLMetafacadeUtils;
import org.andromda.metafacades.uml.UMLProfile;
import org.andromda.metafacades.uml14.ModelElementFacadeLogic;
import org.andromda.metafacades.uml14.UML14MetafacadeUtils;
import org.andromda.utils.StringUtilsHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.omg.uml.behavioralelements.statemachines.StateMachine;
import org.omg.uml.foundation.core.Abstraction;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.Comment;
import org.omg.uml.foundation.core.Dependency;
import org.omg.uml.foundation.core.Feature;
import org.omg.uml.foundation.core.ModelElement;
import org.omg.uml.foundation.core.Namespace;
import org.omg.uml.foundation.datatypes.VisibilityKind;
import org.omg.uml.foundation.datatypes.VisibilityKindEnum;
import org.omg.uml.modelmanagement.UmlPackage;

public class ModelElementFacadeLogicImpl
extends ModelElementFacadeLogic {
    private static final long serialVersionUID = 34L;
    private static final Logger logger = Logger.getLogger(ModelElementFacadeLogicImpl.class);
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z_$][a-zA-Z\\d_$]*");

    public ModelElementFacadeLogicImpl(ModelElement metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected Collection handleGetTaggedValues() {
        return this.metaObject.getTaggedValue();
    }

    @Override
    protected String handleGetPackageName() {
        boolean modelName = false;
        String packageName = UML14MetafacadeUtils.getPackageName(this.metaObject, this.getNamespaceScope(false), false);
        String nameMask = null;
        try {
            nameMask = String.valueOf(this.getConfiguredProperty("modelElementNameMask"));
        }
        catch (Exception ignore) {
            logger.warn((Object)("modelElementNameMask not found in " + this.toString() + " (getPackageName)"));
            nameMask = "none";
        }
        return NameMasker.mask((String)packageName, (String)nameMask);
    }

    @Override
    protected String handleGetPackageName(boolean modelName) {
        String packageName = this.getPackageName();
        if (modelName) {
            packageName = StringUtils.replace((String)packageName, (String)ObjectUtils.toString((Object)this.getConfiguredProperty("namespaceSeparator")), (String)"::");
        }
        return packageName;
    }

    @Override
    protected String handleGetFullyQualifiedName(boolean modelName) {
        return this.handleGetBindedFullyQualifiedName(modelName, Collections.<BindingFacade>emptyList());
    }

    private String getNamespaceScope(boolean modelName) {
        String namespaceScope = "::";
        if (!modelName) {
            namespaceScope = ObjectUtils.toString((Object)this.getConfiguredProperty("namespaceSeparator"));
        }
        return namespaceScope;
    }

    @Override
    protected String handleGetFullyQualifiedName() {
        return this.getFullyQualifiedName(false);
    }

    @Override
    protected Collection<Object> handleFindTaggedValues(String name) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (StringUtils.isNotBlank((String)name)) {
            name = StringUtils.trimToEmpty((String)name);
            for (TaggedValueFacade taggedValue : this.getTaggedValues()) {
                String tagName = taggedValue.getName();
                if (!name.equals(tagName) && !MetafacadeUtils.getEmfTaggedValue((String)name).equals(tagName) && !MetafacadeUtils.getUml14TaggedValue((String)name).equals(tagName)) continue;
                for (Object value : taggedValue.getValues()) {
                    if (value == null) continue;
                    if (value instanceof EnumerationLiteralFacade) {
                        values.add(((EnumerationLiteralFacade)value).getValue(true));
                        continue;
                    }
                    if (value instanceof String) {
                        String valueString = (String)value;
                        if (!StringUtils.isNotBlank((String)valueString)) continue;
                        values.add(value);
                        continue;
                    }
                    values.add(value);
                }
            }
        }
        return values;
    }

    @Override
    protected Object handleFindTaggedValue(String name) {
        Collection taggedValues = this.findTaggedValues(name);
        return taggedValues.isEmpty() ? null : taggedValues.iterator().next();
    }

    @Override
    protected boolean handleHasStereotype(final String stereotypeName) {
        boolean hasStereotype;
        Collection<StereotypeFacade> stereotypes = this.getStereotypes();
        boolean bl = hasStereotype = StringUtils.isNotBlank((String)stereotypeName) && stereotypes != null && !stereotypes.isEmpty();
        if (hasStereotype) {
            class StereotypeFilter
            implements Predicate {
                StereotypeFilter() {
                }

                public boolean evaluate(Object object) {
                    StereotypeFacade facade = (StereotypeFacade)object;
                    String name = StringUtils.trimToEmpty((String)facade.getName());
                    boolean valid = stereotypeName.equals(name);
                    while (!valid && facade != null) {
                        valid = (facade = (StereotypeFacade)facade.getGeneralization()) != null && StringUtils.trimToEmpty((String)facade.getName()).equals(stereotypeName);
                    }
                    return valid;
                }
            }
            hasStereotype = CollectionUtils.find(this.getStereotypes(), (Predicate)new StereotypeFilter()) != null;
        }
        return hasStereotype;
    }

    @Override
    protected String handleGetId() {
        return this.metaObject.refMofId();
    }

    @Override
    protected boolean handleHasExactStereotype(String stereotypeName) {
        return this.getStereotypeNames().contains(StringUtils.trimToEmpty((String)stereotypeName));
    }

    @Override
    protected String handleGetVisibility() {
        VisibilityKind visibilityKind = this.metaObject.getVisibility();
        String visibility = visibilityKind == null || VisibilityKindEnum.VK_PRIVATE.equals((Object)visibilityKind) ? "private" : (VisibilityKindEnum.VK_PROTECTED.equals((Object)visibilityKind) ? "protected" : (VisibilityKindEnum.VK_PUBLIC.equals((Object)visibilityKind) ? "public" : "package"));
        TypeMappings languageMappings = this.getLanguageMappings();
        if (languageMappings != null) {
            visibility = languageMappings.getTo(visibility);
        }
        return visibility;
    }

    @Override
    protected Collection<String> handleGetStereotypeNames() {
        ArrayList<String> stereotypeNames = new ArrayList<String>();
        Collection stereotypes = this.metaObject.getStereotype();
        for (ModelElement stereotype : stereotypes) {
            if (stereotype == null) continue;
            stereotypeNames.add(StringUtils.trimToEmpty((String)stereotype.getName()));
        }
        return stereotypeNames;
    }

    @Override
    protected String handleGetFullyQualifiedNamePath() {
        return StringUtils.replace((String)this.getFullyQualifiedName(), (String)String.valueOf(this.getConfiguredProperty("namespaceSeparator")), (String)"/");
    }

    @Override
    protected String handleGetPackagePath() {
        return StringUtils.replace((String)this.getPackageName(), (String)String.valueOf(this.getConfiguredProperty("namespaceSeparator")), (String)"/");
    }

    @Override
    protected String handleGetDocumentation(String indent) {
        return this.getDocumentation(indent, 64);
    }

    @Override
    protected String handleGetDocumentation(String indent, int lineLength) {
        return this.getDocumentation(indent, lineLength, true);
    }

    @Override
    protected String handleGetDocumentation(String indent, int lineLength, boolean htmlStyle) {
        Collection comments;
        StringBuilder documentation = new StringBuilder();
        if (lineLength < 1) {
            lineLength = Integer.MAX_VALUE;
        }
        if ((comments = this.metaObject.getComment()) != null && !comments.isEmpty()) {
            for (Comment comment : comments) {
                String commentString = StringUtils.trimToEmpty((String)comment.getBody());
                if (StringUtils.isBlank((String)commentString)) {
                    commentString = StringUtils.trimToEmpty((String)comment.getName());
                }
                documentation.append(StringUtils.trimToEmpty((String)commentString));
                documentation.append(SystemUtils.LINE_SEPARATOR);
            }
        }
        if (StringUtils.isBlank((String)documentation.toString())) {
            documentation.append(StringUtils.trimToEmpty((String)((String)this.findTaggedValue(UMLProfile.TAGGEDVALUE_DOCUMENTATION))));
        }
        String rtn = StringUtilsHelper.format((String)StringUtils.trimToEmpty((String)documentation.toString()), (String)indent, (int)lineLength, (boolean)htmlStyle);
        return rtn;
    }

    @Override
    protected boolean handleIsDocumentationPresent() {
        boolean rtn = false;
        Collection comments = this.metaObject.getComment();
        if (comments != null && !comments.isEmpty()) {
            for (Comment comment : comments) {
                if (!StringUtils.isNotBlank((String)comment.getBody()) && !StringUtils.isNotBlank((String)comment.getName())) continue;
                rtn = true;
                break;
            }
        }
        if (!rtn && StringUtils.isNotBlank((String)((String)this.findTaggedValue(UMLProfile.TAGGEDVALUE_DOCUMENTATION)))) {
            rtn = true;
        }
        return rtn;
    }

    @Override
    protected String handleGetLabel() {
        return null;
    }

    @Override
    protected Collection<String> handleGetKeywords() {
        return new ArrayList<String>();
    }

    @Override
    protected String handleGetQualifiedName() {
        return null;
    }

    @Override
    protected boolean handleHasKeyword(String keyword) {
        return this.handleHasExactStereotype(keyword);
    }

    @Override
    protected String handleGetName() {
        String name = this.metaObject.getName();
        if (name != null) {
            String nameMask = null;
            try {
                nameMask = String.valueOf(this.getConfiguredProperty("modelElementNameMask"));
            }
            catch (Exception ignore) {
                logger.warn((Object)("modelElementNameMask not found in " + this.toString()));
                nameMask = "none";
            }
            name = NameMasker.mask((String)name, (String)nameMask);
        }
        return name;
    }

    protected String getArraySuffix() {
        return String.valueOf(this.getConfiguredProperty("arrayNameSuffix"));
    }

    @Override
    protected TypeMappings handleGetLanguageMappings() {
        String propertyName = "languageMappingsUri";
        Object property = this.getConfiguredProperty("languageMappingsUri");
        TypeMappings mappings = null;
        if (property instanceof String) {
            String uri = (String)property;
            try {
                mappings = TypeMappings.getInstance((String)uri);
                mappings.setArraySuffix(this.getArraySuffix());
                this.setProperty("languageMappingsUri", mappings);
            }
            catch (Throwable throwable) {
                String message = "Error getting 'languageMappingsUri' --> '" + uri + '\'';
                logger.error((Object)message, throwable);
            }
        } else {
            mappings = (TypeMappings)property;
        }
        return mappings;
    }

    protected Object handleGetOwner() {
        if (this.metaObject instanceof Feature) {
            Feature feature = (Feature)this.metaObject;
            return feature.getOwner();
        }
        return this.metaObject.getNamespace();
    }

    protected Collection handleGetOwnedElements() {
        if (this.metaObject instanceof Classifier) {
            Classifier classifier = (Classifier)this.metaObject;
            return classifier.getFeature();
        }
        if (this.metaObject instanceof Namespace) {
            Namespace namespace = (Namespace)this.metaObject;
            return namespace.getOwnedElement();
        }
        return null;
    }

    protected Namespace handleGetPackage() {
        return this.metaObject.getNamespace();
    }

    protected UmlPackage handleGetRootPackage() {
        return UML14MetafacadeUtils.getRootPackage();
    }

    @Override
    protected Collection<DependencyFacade> handleGetSourceDependencies() {
        ArrayList<DependencyFacade> dependencies = new ArrayList<DependencyFacade>();
        Collection clientDependencies = UML14MetafacadeUtils.getCorePackage().getAClientClientDependency().getClientDependency(this.metaObject);
        if (clientDependencies != null) {
            dependencies.addAll(clientDependencies);
        }
        CollectionUtils.filter(dependencies, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return object instanceof Dependency && !(object instanceof Abstraction);
            }
        });
        return dependencies;
    }

    @Override
    protected Collection<DependencyFacade> handleGetTargetDependencies() {
        ArrayList<DependencyFacade> dependencies = new ArrayList<DependencyFacade>();
        Collection supplierDependencies = UML14MetafacadeUtils.getCorePackage().getASupplierSupplierDependency().getSupplierDependency(this.metaObject);
        if (supplierDependencies != null) {
            dependencies.addAll(supplierDependencies);
        }
        CollectionUtils.filter(dependencies, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return object instanceof Dependency && !(object instanceof Abstraction);
            }
        });
        return dependencies;
    }

    @Override
    protected Collection<StereotypeFacade> handleGetStereotypes() {
        return this.metaObject.getStereotype();
    }

    @Override
    protected Object handleGetModel() {
        return MetafacadeFactory.getInstance().getModel().getModel();
    }

    @Override
    protected Collection<ConstraintFacade> handleGetConstraints() {
        return this.metaObject.getConstraint();
    }

    @Override
    protected Collection<ConstraintFacade> handleGetConstraints(final String kind) {
        return CollectionUtils.select(this.getConstraints(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                if (object instanceof ConstraintFacade) {
                    ConstraintFacade constraint = (ConstraintFacade)object;
                    return "body".equals(kind) && constraint.isBodyExpression() || "def".equals(kind) && constraint.isDefinition() || "inv".equals(kind) && constraint.isInvariant() || "pre".equals(kind) && constraint.isPreCondition() || "post".equals(kind) && constraint.isPostCondition();
                }
                return false;
            }
        });
    }

    @Override
    protected String handleTranslateConstraint(final String name, String translation) {
        String translatedExpression = "";
        ConstraintFacade constraint = (ConstraintFacade)CollectionUtils.find(this.getConstraints(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                ConstraintFacade constraint = (ConstraintFacade)object;
                return StringUtils.trimToEmpty((String)constraint.getName()).equals(StringUtils.trimToEmpty((String)name));
            }
        });
        if (constraint != null) {
            translatedExpression = constraint.getTranslation(translation);
        }
        return translatedExpression;
    }

    @Override
    protected String[] handleTranslateConstraints(String translation) {
        return this.translateConstraints(this.getConstraints(), translation);
    }

    private String[] translateConstraints(Collection<ConstraintFacade> constraints, String translation) {
        String[] translatedExpressions = null;
        if (constraints != null && !constraints.isEmpty()) {
            translatedExpressions = new String[constraints.size()];
            Iterator<ConstraintFacade> constraintIt = constraints.iterator();
            int ctr = 0;
            while (constraintIt.hasNext()) {
                ConstraintFacade constraint = constraintIt.next();
                translatedExpressions[ctr] = constraint.getTranslation(translation);
                ++ctr;
            }
        }
        return translatedExpressions;
    }

    @Override
    protected String[] handleTranslateConstraints(final String kind, String translation) {
        Collection<ConstraintFacade> constraints = this.getConstraints();
        CollectionUtils.filter(constraints, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                ConstraintFacade constraint = (ConstraintFacade)object;
                return UMLMetafacadeUtils.isConstraintKind((String)constraint.getBody(), (String)kind);
            }
        });
        return this.translateConstraints(constraints, translation);
    }

    protected StateMachine handleGetStateMachineContext() {
        StateMachine machineContext = null;
        Collection machines = UML14MetafacadeUtils.getModel().getStateMachines().getStateMachine().refAllOfType();
        for (StateMachine machine : machines) {
            ModelElement contextElement = machine.getContext();
            if (!this.metaObject.equals(contextElement)) continue;
            machineContext = machine;
        }
        return machineContext;
    }

    @Override
    protected Collection handleGetTemplateParameters() {
        return this.metaObject.getTemplateParameter();
    }

    public String getValidationName() {
        StringBuilder validationName = new StringBuilder();
        String seperator = "::";
        for (Namespace namespace = this.metaObject.getNamespace(); namespace != null; namespace = namespace.getNamespace()) {
            if (validationName.length() == 0) {
                validationName.append(namespace.getName());
                continue;
            }
            validationName.insert(0, "::");
            validationName.insert(0, namespace.getName());
        }
        if (validationName.length() > 0) {
            validationName.append("::");
        }
        if (StringUtils.isNotBlank((String)this.getName())) {
            validationName.append(this.getName());
        } else {
            validationName.append(this.getConfiguredProperty("undefinedName"));
        }
        return validationName.toString();
    }

    @Override
    protected boolean handleIsConstraintsPresent() {
        return this.getConstraints() != null && !this.getConstraints().isEmpty();
    }

    @Override
    protected boolean handleIsBindingDependenciesPresent() {
        Collection<DependencyFacade> dependencies = this.getSourceDependencies();
        CollectionUtils.filter(dependencies, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return object instanceof BindingFacade;
            }
        });
        return !dependencies.isEmpty();
    }

    @Override
    protected boolean handleIsReservedWord() {
        return UMLMetafacadeUtils.isReservedWord((String)this.metaObject.getName());
    }

    @Override
    protected boolean handleIsTemplateParametersPresent() {
        Collection<TemplateParameterFacade> params = this.getTemplateParameters();
        return params != null && !params.isEmpty();
    }

    @Override
    protected void handleCopyTaggedValues(ModelElementFacade element) {
        MetafacadeBase metafacade;
        Object metaObject;
        if (element instanceof MetafacadeBase && (metaObject = (metafacade = (MetafacadeBase)element).getMetaObject()) instanceof ModelElement) {
            ModelElement elementMetaObject = (ModelElement)metaObject;
            this.metaObject.getTaggedValue().addAll(elementMetaObject.getTaggedValue());
        }
    }

    protected TemplateParameterFacade handleGetTemplateParameter(String parameterName) {
        TemplateParameterFacade templateParameter = null;
        if (StringUtils.isNotBlank((String)parameterName)) {
            parameterName = StringUtils.trimToEmpty((String)parameterName);
            Collection<TemplateParameterFacade> parameters = this.getTemplateParameters();
            if (parameters != null && !parameters.isEmpty()) {
                for (TemplateParameterFacade currentTemplateParameter : parameters) {
                    ModelElementFacade parameter;
                    if (currentTemplateParameter.getParameter() == null || !parameterName.equals((parameter = currentTemplateParameter.getParameter()).getName())) continue;
                    templateParameter = currentTemplateParameter;
                    break;
                }
            }
        }
        return templateParameter;
    }

    @Override
    protected String handleGetBindedFullyQualifiedName(ModelElementFacade bindedElement) {
        ArrayList<BindingFacade> bindingFacades = new ArrayList<BindingFacade>(bindedElement.getSourceDependencies());
        CollectionUtils.filter(bindingFacades, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return object instanceof BindingFacade;
            }
        });
        return this.handleGetBindedFullyQualifiedName(false, bindingFacades);
    }

    private String handleGetBindedFullyQualifiedName(boolean modelName, Collection<BindingFacade> bindingFacades) {
        TypeMappings languageMappings;
        String fullName = StringUtils.trimToEmpty((String)this.getName());
        String packageName = this.getPackageName(true);
        String metafacadeNamespaceScopeOperator = "::";
        if (StringUtils.isNotBlank((String)packageName)) {
            fullName = packageName + "::" + fullName;
        }
        if (!modelName && (languageMappings = this.getLanguageMappings()) != null) {
            fullName = StringUtils.trimToEmpty((String)languageMappings.getTo(fullName));
            String namespaceScopeOperator = String.valueOf(this.getConfiguredProperty("namespaceSeparator"));
            fullName = StringUtils.replace((String)fullName, (String)"::", (String)namespaceScopeOperator);
        }
        if (this.isTemplateParametersPresent() && BooleanUtils.toBoolean((String)ObjectUtils.toString((Object)this.getConfiguredProperty("enableTemplating")))) {
            Collection<TemplateParameterFacade> templateParameters = this.getTemplateParameters();
            HashMap<TemplateParameterFacade, ModelElementFacade> bindedParameters = new HashMap<TemplateParameterFacade, ModelElementFacade>();
            for (BindingFacade bindingFacade : bindingFacades) {
                ModelElementFacade targetElement = bindingFacade.getTargetElement();
                if (targetElement instanceof RedefinableTemplateSignatureFacade) {
                    targetElement = ((RedefinableTemplateSignatureFacade)targetElement).getClassifier();
                }
                if (!this.equals(targetElement)) continue;
                Collection arguments = bindingFacade.getArguments();
                if (arguments.size() != this.getTemplateParameters().size()) {
                    throw new IllegalStateException("The size of the arguments of the BindingFacace must be equals to the size of the TemplateParameter collection of this element.");
                }
                Iterator<TemplateParameterFacade> templateParametersIterator = templateParameters.iterator();
                Iterator templateArgumentsIterator = arguments.iterator();
                while (templateParametersIterator.hasNext()) {
                    TemplateParameterFacade templateParameter = templateParametersIterator.next();
                    TemplateArgumentFacade templateArgument = (TemplateArgumentFacade)templateArgumentsIterator.next();
                    bindedParameters.put(templateParameter, templateArgument.getElement());
                }
            }
            if (bindedParameters.isEmpty()) {
                for (TemplateParameterFacade templateParameterFacade : templateParameters) {
                    bindedParameters.put(templateParameterFacade, templateParameterFacade.getParameter());
                }
            }
            StringBuilder buffer = new StringBuilder(fullName + '<');
            Iterator<TemplateParameterFacade> parameterIterator = templateParameters.iterator();
            while (parameterIterator.hasNext()) {
                ModelElementFacade modelElement = (ModelElementFacade)bindedParameters.get(parameterIterator.next());
                if (modelElement instanceof ParameterFacade) {
                    buffer.append(((ParameterFacade)modelElement).getType().getFullyQualifiedName());
                } else {
                    buffer.append(modelElement.getFullyQualifiedName());
                }
                if (!parameterIterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('>');
            fullName = buffer.toString();
        }
        return fullName;
    }

    protected boolean handleIsValidIdentifierName() {
        String name = this.handleGetName();
        return IDENTIFIER_PATTERN.matcher(name).matches();
    }
}

