/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4;

import java.io.File;
import net.timewalker.ffmq4.FFMQAdminClient;
import net.timewalker.ffmq4.FFMQAdminConstants;
import net.timewalker.ffmq4.logging.Log4JTools;
import net.timewalker.ffmq4.utils.Settings;
import net.timewalker.ffmq4.utils.StringTools;

public final class FFMQAdminClientLauncher {
    private static final String DEFAULT_ADMIN_CLIENT_CONF_FILE = "../conf/ffmq-admin-client.properties";

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                FFMQAdminClientLauncher.printUsage();
            } else {
                Settings globalSettings = new Settings();
                Settings paramSettings = new Settings();
                FFMQAdminClientLauncher.parseCommandLine(args, globalSettings, paramSettings);
                new FFMQAdminClient(globalSettings, paramSettings, System.out, System.err).run();
            }
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-2);
        }
    }

    private static void printUsage() {
        System.out.println(" Command-line parameters");
        System.out.println("-------------------------");
        System.out.println("  -command <command>      : the command to execute (" + StringTools.join((Object[])FFMQAdminConstants.ADM_COMMAND_ALL, (String)",") + ")");
        System.out.println("  -conf <propertiesFile>  : path to a properties file (optional)");
        System.out.println();
        System.out.println("    All other variables should be passed as variable=value");
        System.out.println();
        System.out.println("    Examples:");
        System.out.println();
        System.out.println("      # Create queue FOO with a non-persistent message capacity of 1000");
        System.out.println("      ffmq-admin-client -command createQueue name=FOO memoryStore.maxMessages=1000");
        System.out.println();
        System.out.println("      # Delete topic BAR");
        System.out.println("      ffmq-admin-client -command deleteTopic name=BAR");
    }

    private static void parseCommandLine(String[] args, Settings globalSettings, Settings paramSettings) throws Exception {
        String confFilePath = DEFAULT_ADMIN_CLIENT_CONF_FILE;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-conf")) continue;
            if (++i == args.length) {
                throw new IllegalArgumentException("Missing value after parameter " + args[i]);
            }
            confFilePath = args[i];
        }
        File confFile = new File(confFilePath);
        if (!confFile.canRead()) {
            throw new IllegalArgumentException("Cannot access config file : " + confFile.getAbsolutePath());
        }
        globalSettings.readFrom(confFile);
        Log4JTools.initializeLog4J(globalSettings.asProperties());
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-conf")) {
                if (i + 1 == args.length) {
                    throw new IllegalArgumentException("Missing value after parameter " + args[i]);
                }
                ++i;
                continue;
            }
            if (args[i].equals("-command")) {
                if (i + 1 == args.length) {
                    throw new IllegalArgumentException("Missing value after parameter " + args[i]);
                }
                globalSettings.setStringProperty("admin.command", args[++i]);
                continue;
            }
            int sepIdx = args[i].indexOf(61);
            if (sepIdx == -1) {
                throw new IllegalArgumentException("Invalid command-line parameter : " + args[i]);
            }
            String paramName = args[i].substring(0, sepIdx).trim();
            String paramValue = args[i].substring(sepIdx + 1).trim();
            if (paramName.length() == 0 || paramValue.length() == 0) {
                throw new IllegalArgumentException("Invalid command-line parameter : " + args[i]);
            }
            paramSettings.setStringProperty(paramName, paramValue);
        }
    }
}

