/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.utils.SystemTools;

public final class Settings {
    private Properties settings = new Properties();

    public Settings() {
    }

    public Settings(Properties settings) {
        this.settings.putAll((Map<?, ?>)settings);
    }

    public void readFrom(File settingsFile) throws JMSException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(settingsFile);
            this.settings.load(in);
            in.close();
        }
        catch (Exception e) {
            throw new FFMQException("Cannot load settings from " + settingsFile.getAbsolutePath() + " : " + e, "FS_ERROR");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                throw new FFMQException("Cannot close settings file " + settingsFile.getAbsolutePath() + " : " + e, "FS_ERROR");
            }
        }
    }

    public void writeTo(File settingsFile, String title) throws JMSException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(settingsFile);
            this.settings.store(out, title);
            out.close();
        }
        catch (Exception e) {
            throw new FFMQException("Cannot save settings to " + settingsFile.getAbsolutePath() + " : " + e, "FS_ERROR");
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                throw new FFMQException("Cannot close settings file " + settingsFile.getAbsolutePath() + " : " + e, "FS_ERROR");
            }
        }
    }

    public String getStringProperty(String key) {
        return this.getStringProperty(key, null, true);
    }

    public String getStringProperty(String key, String defaultValue) {
        return this.getStringProperty(key, defaultValue, true);
    }

    public String getStringProperty(String key, String defaultValue, boolean replaceSystemProperties) {
        String value = System.getProperty("ffmq4." + key);
        if (value == null) {
            value = this.settings.getProperty(key);
        }
        if (value == null) {
            value = defaultValue;
        }
        if (replaceSystemProperties) {
            value = SystemTools.replaceSystemProperties(value);
        }
        return value != null ? value.trim() : null;
    }

    public int getIntProperty(String key, int defaultValue) {
        String value = this.getStringProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public long getLongProperty(String key, long defaultValue) {
        String value = this.getStringProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = this.getStringProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value.trim());
    }

    public void setStringProperty(String key, String value) {
        this.settings.setProperty(key, value);
    }

    public void setIntProperty(String key, int value) {
        this.settings.setProperty(key, String.valueOf(value));
    }

    public void setLongProperty(String key, long value) {
        this.settings.setProperty(key, String.valueOf(value));
    }

    public void setBooleanProperty(String key, boolean value) {
        this.settings.setProperty(key, String.valueOf(value));
    }

    public String removeProperty(String key) {
        return (String)this.settings.remove(key);
    }

    public Properties asProperties() {
        return this.settings;
    }

    public Set<Object> keySet() {
        return this.settings.keySet();
    }
}

