/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class RawDataBuffer
implements DataOutput,
DataInput {
    private static final byte NULL_VALUE = 0;
    private static final byte NOT_NULL_VALUE = 1;
    private static final byte TYPE_BOOLEAN = 10;
    private static final byte TYPE_BYTE = 11;
    private static final byte TYPE_SHORT = 12;
    private static final byte TYPE_INT = 13;
    private static final byte TYPE_LONG = 14;
    private static final byte TYPE_FLOAT = 15;
    private static final byte TYPE_DOUBLE = 16;
    private static final byte TYPE_STRING = 17;
    private static final byte TYPE_BYTEARRAY = 18;
    private static final byte TYPE_CHARACTER = 19;
    private static final byte UTF_TYPE_1 = 1;
    private static final byte UTF_TYPE_2 = 2;
    private static final byte UTF_TYPE_4 = 4;
    private byte[] buf;
    private int capacity;
    private int size;
    private int pos;

    public RawDataBuffer(int initialCapacity) {
        this.buf = new byte[initialCapacity];
        this.capacity = initialCapacity;
    }

    public RawDataBuffer(byte[] initialBuffer) {
        this.buf = initialBuffer;
        this.size = this.capacity = initialBuffer.length;
    }

    public void writeNullableUTF(String str) {
        if (str == null) {
            this.write(0);
        } else {
            this.write(1);
            this.writeUTF(str);
        }
    }

    public final void ensureCapacity(int targetCapacity) {
        if (targetCapacity > this.capacity) {
            int newLength = Math.max(this.capacity << 1, targetCapacity);
            byte[] copy = new byte[newLength];
            System.arraycopy(this.buf, 0, copy, 0, this.capacity);
            this.buf = copy;
            this.capacity = newLength;
        }
    }

    public void setSize(int size) {
        this.ensureCapacity(size);
        this.size = size;
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.size + 1);
        this.buf[this.size++] = (byte)b;
    }

    @Override
    public void write(byte[] data) {
        int newCount = this.size + data.length;
        this.ensureCapacity(newCount);
        System.arraycopy(data, 0, this.buf, this.size, data.length);
        this.size = newCount;
    }

    @Override
    public void writeBytes(String s) {
        int len = s.length();
        this.ensureCapacity(this.size + len);
        for (int i = 0; i < len; ++i) {
            this.buf[this.pos++] = (byte)s.charAt(i);
        }
    }

    @Override
    public void writeChars(String s) {
        int len = s.length();
        this.ensureCapacity(this.size + len * 2);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.buf[this.pos++] = (byte)(v >>> 8 & 0xFF);
            this.buf[this.pos++] = (byte)(v >>> 0 & 0xFF);
        }
    }

    @Override
    public void write(byte[] data, int offset, int len) {
        int newCount = this.size + len;
        this.ensureCapacity(newCount);
        System.arraycopy(data, offset, this.buf, this.size, len);
        this.size = newCount;
    }

    @Override
    public void writeByte(int b) {
        this.ensureCapacity(this.size + 1);
        this.buf[this.size++] = (byte)b;
    }

    @Override
    public void writeBoolean(boolean v) {
        this.write(v ? 1 : 0);
    }

    public byte readByte(int position) {
        return this.buf[position];
    }

    public void writeByte(byte v, int position) {
        this.buf[position] = v;
    }

    @Override
    public void writeShort(int v) {
        this.ensureCapacity(this.size + 2);
        this.buf[this.size++] = (byte)(v >>> 8 & 0xFF);
        this.buf[this.size++] = (byte)(v >>> 0 & 0xFF);
    }

    @Override
    public void writeInt(int v) {
        this.ensureCapacity(this.size + 4);
        this.buf[this.size++] = (byte)(v >>> 24 & 0xFF);
        this.buf[this.size++] = (byte)(v >>> 16 & 0xFF);
        this.buf[this.size++] = (byte)(v >>> 8 & 0xFF);
        this.buf[this.size++] = (byte)(v >>> 0 & 0xFF);
    }

    public void writeInt(int v, int pos) {
        this.buf[pos++] = (byte)(v >>> 24 & 0xFF);
        this.buf[pos++] = (byte)(v >>> 16 & 0xFF);
        this.buf[pos++] = (byte)(v >>> 8 & 0xFF);
        this.buf[pos] = (byte)(v >>> 0 & 0xFF);
    }

    @Override
    public void writeLong(long v) {
        this.ensureCapacity(this.size + 8);
        this.buf[this.size++] = (byte)(v >>> 56);
        this.buf[this.size++] = (byte)(v >>> 48);
        this.buf[this.size++] = (byte)(v >>> 40);
        this.buf[this.size++] = (byte)(v >>> 32);
        this.buf[this.size++] = (byte)(v >>> 24);
        this.buf[this.size++] = (byte)(v >>> 16);
        this.buf[this.size++] = (byte)(v >>> 8);
        this.buf[this.size++] = (byte)(v >>> 0);
    }

    @Override
    public void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeChar(int v) {
        this.ensureCapacity(this.size + 2);
        this.buf[this.size++] = (byte)(v >>> 8 & 0xFF);
        this.buf[this.size++] = (byte)(v >>> 0 & 0xFF);
    }

    @Override
    public void writeUTF(String str) {
        int strlen = str.length();
        if (strlen < 255) {
            this.writeUTF(str, (byte)1);
        } else if (strlen < 65535) {
            this.writeUTF(str, (byte)2);
        } else {
            this.writeUTF(str, (byte)4);
        }
    }

    private void writeUTF(String str, byte type) {
        char c;
        int strlen = str.length();
        int rawlen = this.size + type + strlen + 1;
        this.ensureCapacity(rawlen);
        this.buf[this.size++] = type;
        switch (type) {
            case 1: {
                this.buf[this.size++] = (byte)(strlen >>> 0 & 0xFF);
                break;
            }
            case 2: {
                this.buf[this.size++] = (byte)(strlen >>> 8 & 0xFF);
                this.buf[this.size++] = (byte)(strlen >>> 0 & 0xFF);
                break;
            }
            case 4: {
                this.buf[this.size++] = (byte)(strlen >>> 24 & 0xFF);
                this.buf[this.size++] = (byte)(strlen >>> 16 & 0xFF);
                this.buf[this.size++] = (byte)(strlen >>> 8 & 0xFF);
                this.buf[this.size++] = (byte)(strlen >>> 0 & 0xFF);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid UTF type : " + type);
            }
        }
        int i = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            this.buf[this.size++] = (byte)c;
        }
        if (i == strlen) {
            return;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.buf[this.size++] = (byte)c;
            } else if (c > '\u07ff') {
                this.ensureCapacity(rawlen += 3);
                this.buf[this.size++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buf[this.size++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buf[this.size++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                this.ensureCapacity(rawlen += 2);
                this.buf[this.size++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.buf[this.size++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
    }

    public void writeNullableByteArray(byte[] value) {
        if (value == null) {
            this.write(0);
        } else {
            this.write(1);
            this.writeInt(value.length);
            this.write(value);
        }
    }

    public void writeByteArray(byte[] value) {
        this.writeInt(value.length);
        this.write(value);
    }

    public void writeGeneric(Object value) {
        if (value == null) {
            this.write(0);
        } else if (value instanceof String) {
            this.writeByte(17);
            this.writeUTF((String)value);
        } else if (value instanceof Boolean) {
            this.writeByte(10);
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte(11);
            this.writeByte(((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.writeByte(12);
            this.writeShort(((Short)value).shortValue());
        } else if (value instanceof Integer) {
            this.writeByte(13);
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeByte(14);
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeByte(15);
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeByte(16);
            this.writeDouble((Double)value);
        } else if (value instanceof byte[]) {
            this.writeByte(18);
            this.writeByteArray((byte[])value);
        } else if (value instanceof Character) {
            this.writeByte(19);
            this.writeChar(((Character)value).charValue());
        } else {
            throw new IllegalArgumentException("Unsupported type : " + value.getClass().getName());
        }
    }

    @Override
    public boolean readBoolean() {
        byte ch;
        return (ch = this.buf[this.pos++]) != 0;
    }

    public void read(byte[] b) {
        this.read(b, 0, b.length);
    }

    public void read(byte[] b, int off, int len) {
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
    }

    public byte[] readBytes(int len) {
        byte[] data = new byte[len];
        this.readFully(data);
        return data;
    }

    @Override
    public void readFully(byte[] b) {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
    }

    @Override
    public byte readByte() {
        return this.buf[this.pos++];
    }

    @Override
    public int readUnsignedByte() {
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public String readLine() {
        throw new IllegalStateException("Unsupported operation (deprecated)");
    }

    @Override
    public int skipBytes(int n) {
        int skippable = Math.min(n, this.size - this.pos);
        this.pos += skippable;
        return skippable;
    }

    @Override
    public short readShort() {
        int ch1 = this.buf[this.pos++] & 0xFF;
        int ch2 = this.buf[this.pos++] & 0xFF;
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public int readUnsignedShort() {
        int ch1 = this.buf[this.pos++] & 0xFF;
        int ch2 = this.buf[this.pos++] & 0xFF;
        return (ch1 << 8) + (ch2 << 0);
    }

    @Override
    public int readInt() {
        int ch1 = this.buf[this.pos++] & 0xFF;
        int ch2 = this.buf[this.pos++] & 0xFF;
        int ch3 = this.buf[this.pos++] & 0xFF;
        int ch4 = this.buf[this.pos++] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    @Override
    public long readLong() {
        return ((long)this.buf[this.pos++] << 56) + ((long)(this.buf[this.pos++] & 0xFF) << 48) + ((long)(this.buf[this.pos++] & 0xFF) << 40) + ((long)(this.buf[this.pos++] & 0xFF) << 32) + ((long)(this.buf[this.pos++] & 0xFF) << 24) + (long)((this.buf[this.pos++] & 0xFF) << 16) + (long)((this.buf[this.pos++] & 0xFF) << 8) + (long)((this.buf[this.pos++] & 0xFF) << 0);
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public char readChar() {
        int ch1 = this.buf[this.pos++] & 0xFF;
        int ch2 = this.buf[this.pos++] & 0xFF;
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public String readUTF() {
        int c;
        int strlen;
        int type = this.buf[this.pos++] & 0xFF;
        switch (type) {
            case 1: {
                strlen = this.buf[this.pos++] & 0xFF;
                break;
            }
            case 2: {
                int ch1 = this.buf[this.pos++] & 0xFF;
                int ch2 = this.buf[this.pos++] & 0xFF;
                strlen = (ch1 << 8) + (ch2 << 0);
                break;
            }
            case 4: {
                int ch1 = this.buf[this.pos++] & 0xFF;
                int ch2 = this.buf[this.pos++] & 0xFF;
                int ch3 = this.buf[this.pos++] & 0xFF;
                int ch4 = this.buf[this.pos++] & 0xFF;
                strlen = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid UTF type : " + type);
            }
        }
        char[] chars = new char[strlen];
        int count = 0;
        while (count < strlen && (c = this.buf[this.pos] & 0xFF) <= 127) {
            ++this.pos;
            chars[count++] = (char)c;
        }
        block11: while (count < strlen) {
            c = this.buf[this.pos++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[count++] = (char)c;
                    continue block11;
                }
                case 12: 
                case 13: {
                    byte char2 = this.buf[this.pos++];
                    chars[count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block11;
                }
                case 14: {
                    byte char2 = this.buf[this.pos++];
                    byte char3 = this.buf[this.pos++];
                    chars[count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block11;
                }
            }
            throw new IllegalStateException("Malformed input around byte " + count);
        }
        return new String(chars);
    }

    public String readNullableUTF() {
        byte isNull = this.readByte();
        if (isNull == 0) {
            return null;
        }
        return this.readUTF();
    }

    public byte[] readNullableByteArray() {
        byte isNull = this.readByte();
        if (isNull == 0) {
            return null;
        }
        int arraySize = this.readInt();
        byte[] value = new byte[arraySize];
        this.readFully(value);
        return value;
    }

    public byte[] readByteArray() {
        int arraySize = this.readInt();
        byte[] value = new byte[arraySize];
        this.readFully(value);
        return value;
    }

    public Object readGeneric() {
        byte type = this.readByte();
        switch (type) {
            case 0: {
                return null;
            }
            case 17: {
                return this.readUTF();
            }
            case 10: {
                return this.readBoolean();
            }
            case 11: {
                return this.readByte();
            }
            case 12: {
                return this.readShort();
            }
            case 13: {
                return this.readInt();
            }
            case 14: {
                return this.readLong();
            }
            case 15: {
                return new Float(this.readFloat());
            }
            case 16: {
                return new Double(this.readDouble());
            }
            case 18: {
                return this.readByteArray();
            }
            case 19: {
                return new Character(this.readChar());
            }
        }
        throw new IllegalArgumentException("Unsupported type : " + type);
    }

    public void clear() {
        this.size = 0;
    }

    public void reset() {
        this.pos = 0;
    }

    public int size() {
        return this.size;
    }

    public int pos() {
        return this.pos;
    }

    public byte[] toByteArray() {
        byte[] copy = new byte[this.size];
        System.arraycopy(this.buf, 0, copy, 0, this.size);
        return copy;
    }

    public byte[] toByteArray(int offset, int len) {
        byte[] copy = new byte[len];
        System.arraycopy(this.buf, offset, copy, 0, len);
        return copy;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.size);
    }

    public void putTo(ByteBuffer byteBuffer, int offset, int len) {
        byteBuffer.put(this.buf, offset, len);
    }

    public int readFrom(InputStream in, int offset, int len) throws IOException {
        this.ensureCapacity(offset + len);
        int readSize = in.read(this.buf, offset, len);
        if (readSize == -1) {
            return -1;
        }
        if (offset + readSize > this.size) {
            this.size = offset + readSize;
        }
        return readSize;
    }

    public void getFrom(ByteBuffer byteBuffer, int offset, int len) {
        this.ensureCapacity(offset + len);
        byteBuffer.get(this.buf, offset, len);
    }

    public void writeTo(RawDataBuffer otherBuffer) {
        otherBuffer.write(this.buf, 0, this.size);
    }

    public RawDataBuffer copy() {
        RawDataBuffer copy = new RawDataBuffer(this.capacity);
        System.arraycopy(this.buf, 0, copy.buf, 0, this.capacity);
        copy.size = this.size;
        copy.pos = this.pos;
        return copy;
    }
}

