/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport.tcp.io;

import java.io.OutputStream;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import net.timewalker.ffmq4.transport.PacketTransportListener;
import net.timewalker.ffmq4.transport.packet.AbstractPacket;
import net.timewalker.ffmq4.transport.packet.PacketSerializer;
import net.timewalker.ffmq4.transport.packet.query.PingQuery;
import net.timewalker.ffmq4.transport.tcp.io.AbstractTcpPacketHandler;
import net.timewalker.ffmq4.transport.tcp.io.NetworkOutputChannel;
import net.timewalker.ffmq4.transport.tcp.io.TcpPacketTransport;
import net.timewalker.ffmq4.utils.RawDataBuffer;
import net.timewalker.ffmq4.utils.SerializationTools;
import net.timewalker.ffmq4.utils.watchdog.ActivityWatchdog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TcpPacketSender
extends AbstractTcpPacketHandler
implements Runnable {
    private static final Log log = LogFactory.getLog(TcpPacketSender.class);
    private TcpPacketTransport transport;
    private NetworkOutputChannel outChannel;
    private int pingInterval;
    private int sendQueueMaxSize;
    private LinkedList<AbstractPacket> sendQueue = new LinkedList();
    private LinkedList<AbstractPacket> pipeline = new LinkedList();
    private Semaphore waitLock = new Semaphore(0);
    private volatile boolean stopRequired;

    protected TcpPacketSender(TcpPacketTransport transport, NetworkOutputChannel outputChannel, PacketTransportListener listener, int pingInterval, int sendQueueMaxSize) {
        super(transport.getId(), listener);
        this.transport = transport;
        this.outChannel = outputChannel;
        this.pingInterval = pingInterval;
        if (pingInterval > 0) {
            ActivityWatchdog.getInstance().register(this);
        }
        this.sendQueueMaxSize = sendQueueMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(AbstractPacket packet) {
        LinkedList<AbstractPacket> linkedList = this.sendQueue;
        synchronized (linkedList) {
            this.sendQueue.addLast(packet);
        }
        this.waitLock.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsThrottling() {
        LinkedList<AbstractPacket> linkedList = this.sendQueue;
        synchronized (linkedList) {
            return this.sendQueueMaxSize > 0 && this.sendQueue.size() >= this.sendQueueMaxSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.stopRequired) {
                AbstractPacket packet;
                this.waitLock.acquire();
                if (this.stopRequired) break;
                LinkedList<AbstractPacket> linkedList = this.sendQueue;
                synchronized (linkedList) {
                    while (!this.sendQueue.isEmpty() && this.pipeline.size() < 16) {
                        packet = this.sendQueue.removeFirst();
                        this.pipeline.add(packet);
                    }
                }
                if (this.pipeline.size() <= 0) continue;
                boolean updateLastTwoWayActivityTimestamp = false;
                while (this.pipeline.size() > 0) {
                    packet = this.pipeline.removeFirst();
                    RawDataBuffer buffer = this.outChannel.ioBuffer;
                    buffer.clear();
                    PacketSerializer.serializeTo(packet, buffer);
                    OutputStream out = this.outChannel.socketOutputStream;
                    SerializationTools.writeInt(buffer.size(), out);
                    buffer.writeTo(out);
                    if (this.pingInterval <= 0 || !packet.isResponseExpected()) continue;
                    updateLastTwoWayActivityTimestamp = true;
                }
                this.outChannel.flush();
                if (!updateLastTwoWayActivityTimestamp) continue;
                this.lastActivity = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            if (!this.stopRequired) {
                log.error((Object)("#" + this.id + " transport failed : " + e.toString()));
                this.transport.closeTransport(true);
            }
        }
        catch (Throwable e) {
            log.fatal((Object)("#" + this.id + " TCP packet receiver died"), e);
        }
        log.debug((Object)("#" + this.id + " stopping."));
    }

    @Override
    public long getTimeoutDelay() {
        return (long)this.pingInterval * 1000L;
    }

    @Override
    public boolean onActivityTimeout() throws Exception {
        try {
            this.send(new PingQuery());
            return false;
        }
        catch (Exception e) {
            log.warn((Object)("#" + this.id + " cannot send ping to server : " + e.toString()));
            return true;
        }
    }

    public void pleaseStop() {
        this.stopRequired = true;
        this.waitLock.release();
        if (this.pingInterval > 0) {
            ActivityWatchdog.getInstance().unregister(this);
        }
    }
}

