/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.data.impl;

import java.io.IOException;
import net.timewalker.ffmq4.management.destination.definition.QueueDefinition;
import net.timewalker.ffmq4.storage.data.DataStoreException;
import net.timewalker.ffmq4.storage.data.impl.AbstractBlockBasedDataStore;
import net.timewalker.ffmq4.utils.concurrent.SynchronizationBarrier;

public final class BlockBasedDataStore
extends AbstractBlockBasedDataStore {
    public BlockBasedDataStore(QueueDefinition queueDef) {
        super(queueDef);
    }

    @Override
    protected void initFilesystem() throws DataStoreException {
        super.initFilesystem();
        this.integrityCheck();
    }

    @Override
    protected void writeFirstBlock() throws DataStoreException {
        try {
            this.allocationTableRandomAccessFile.seek(8L);
            this.allocationTableRandomAccessFile.writeInt(this.firstBlock);
        }
        catch (IOException e) {
            throw new DataStoreException("Cannot write to allocation table file : " + this.allocationTableFile.getAbsolutePath(), e);
        }
    }

    @Override
    protected void writeAllocationBlock(int blockIndex) throws DataStoreException {
        byte[] allocationBlock = this.serializeAllocationBlock(blockIndex);
        try {
            this.allocationTableRandomAccessFile.seek(12 + blockIndex * 13);
            this.allocationTableRandomAccessFile.write(allocationBlock);
        }
        catch (IOException e) {
            throw new DataStoreException("Cannot write to allocation table file : " + this.allocationTableFile.getAbsolutePath(), e);
        }
    }

    @Override
    protected void writeDataBlock(byte[] data, int offset, int len, int blockHandle) throws DataStoreException {
        try {
            this.dataRandomAccessFile.seek((long)blockHandle * (long)this.blockSize);
            this.dataRandomAccessFile.write(data, offset, len);
        }
        catch (IOException e) {
            throw new DataStoreException("Cannot write data block " + blockHandle + " : " + this.dataFile.getAbsolutePath(), e);
        }
    }

    @Override
    protected void readDataBlock(byte[] data, int offset, int len, int blockHandle) throws DataStoreException {
        try {
            this.dataRandomAccessFile.seek((long)blockHandle * (long)this.blockSize);
            if (this.dataRandomAccessFile.read(data, offset, len) != len) {
                throw new DataStoreException("Cannot read " + len + " bytes from store file");
            }
        }
        catch (DataStoreException e) {
            throw e;
        }
        catch (IOException e) {
            throw new DataStoreException("Could not read data block " + blockHandle + " : " + this.dataFile.getAbsolutePath(), e);
        }
    }

    @Override
    protected void extendStoreFiles(int oldBlockCount, int newBlockCount) throws DataStoreException {
        try {
            this.allocationTableRandomAccessFile.setLength(12L + (long)newBlockCount * 13L);
            for (int n = oldBlockCount; n < newBlockCount; ++n) {
                this.writeAllocationBlock(n);
            }
            this.allocationTableRandomAccessFile.seek(0L);
            this.allocationTableRandomAccessFile.writeInt(newBlockCount);
            this.dataRandomAccessFile.setLength((long)this.blockSize * (long)newBlockCount);
        }
        catch (IOException e) {
            throw new DataStoreException("Could not extends store to " + newBlockCount + " blocks : " + this.dataFile.getAbsolutePath(), e);
        }
    }

    @Override
    public void commitChanges() throws DataStoreException {
    }

    @Override
    public void commitChanges(SynchronizationBarrier barrier) throws DataStoreException {
    }

    @Override
    protected void flush() throws DataStoreException {
    }
}

