/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.management;

import java.io.File;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.utils.Settings;
import net.timewalker.ffmq4.utils.StringTools;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FFMQEngineSetup {
    private static final Log log = LogFactory.getLog(FFMQEngineSetup.class);
    private Settings settings;
    private boolean securityEnabled;
    private File destinationDefinitionsDir;
    private File bridgeDefinitionsDir;
    private File templatesDir;
    private File templateMappingFile;
    private File defaultDataDir;
    private boolean autoCreateQueues;
    private boolean autoCreateTopics;
    private boolean deployQueuesOnStartup;
    private boolean deployTopicsOnStartup;
    private int consumerPrefetchSize;
    private int notificationAsyncTaskManagerThreadPoolMinSize;
    private int notificationAsyncTaskManagerThreadPoolMaxIdle;
    private int notificationAsyncTaskManagerThreadPoolMaxSize;
    private int deliveryAsyncTaskManagerThreadPoolMinSize;
    private int deliveryAsyncTaskManagerThreadPoolMaxIdle;
    private int deliveryAsyncTaskManagerThreadPoolMaxSize;
    private int diskIOAsyncTaskManagerThreadPoolMinSize;
    private int diskIOAsyncTaskManagerThreadPoolMaxIdle;
    private int diskIOAsyncTaskManagerThreadPoolMaxSize;
    private int watchdogConsumerInactivityTimeout;
    private String securityConnectorType;
    private long redeliveryDelay;
    private int internalNotificationQueueMaxSize;

    public FFMQEngineSetup(Settings settings) throws FFMQException {
        this.settings = settings;
        this.setup(settings);
    }

    public Settings getSettings() {
        return this.settings;
    }

    private void setup(Settings settings) throws FFMQException {
        String defaultDataDirPath;
        String templatesDirPath;
        String bridgeDefinitionDirPath;
        this.securityEnabled = settings.getBooleanProperty("security.enabled", false);
        this.securityConnectorType = settings.getStringProperty("security.connector", "undefined");
        String destinationDefinitionDirPath = settings.getStringProperty("management.destinationDefinitions.directory", null);
        if (destinationDefinitionDirPath != null) {
            this.destinationDefinitionsDir = new File(destinationDefinitionDirPath);
            if (!this.destinationDefinitionsDir.isDirectory()) {
                throw new FFMQException("Destination definitions directory does not exist : " + this.destinationDefinitionsDir.getAbsolutePath(), "FS_ERROR");
            }
        } else {
            log.warn((Object)"Destination definitions directory is not set, running in memory only mode.");
        }
        if ((bridgeDefinitionDirPath = settings.getStringProperty("management.bridgeDefinitions.directory", null)) != null) {
            this.bridgeDefinitionsDir = new File(bridgeDefinitionDirPath);
            if (!this.bridgeDefinitionsDir.isDirectory()) {
                throw new FFMQException("Bridge definitions directory does not exist : " + this.bridgeDefinitionsDir.getAbsolutePath(), "FS_ERROR");
            }
        }
        if ((templatesDirPath = settings.getStringProperty("management.templates.directory", null)) == null) {
            throw new FFMQException("Templates directory not defined : management.templates.directory", "MISSING_SETTING");
        }
        this.templatesDir = new File(templatesDirPath);
        if (!this.templatesDir.isDirectory()) {
            throw new FFMQException("Templates directory does not exist : " + this.templatesDir.getAbsolutePath(), "FS_ERROR");
        }
        String templatesMappingPath = settings.getStringProperty("management.templates.mapping", null);
        if (!StringTools.isEmpty(templatesMappingPath)) {
            this.templateMappingFile = new File(templatesMappingPath);
            if (!this.templateMappingFile.canRead()) {
                throw new FFMQException("Template mapping file does not exist : " + this.templateMappingFile.getAbsolutePath(), "FS_ERROR");
            }
        }
        if ((defaultDataDirPath = settings.getStringProperty("management.defaultData.directory", null)) == null) {
            throw new FFMQException("Default data directory not defined : management.defaultData.directory", "MISSING_SETTING");
        }
        this.defaultDataDir = new File(defaultDataDirPath);
        if (!this.defaultDataDir.isDirectory()) {
            throw new FFMQException("Default data directory does not exist : " + this.defaultDataDir.getAbsolutePath(), "FS_ERROR");
        }
        this.autoCreateQueues = settings.getBooleanProperty("management.autoCreate.queues", false);
        this.autoCreateTopics = settings.getBooleanProperty("management.autoCreate.topics", false);
        this.deployQueuesOnStartup = settings.getBooleanProperty("management.deployOnStartup.queues", false);
        this.deployTopicsOnStartup = settings.getBooleanProperty("management.deployOnStartup.topics", false);
        this.notificationAsyncTaskManagerThreadPoolMinSize = settings.getIntProperty("asyncTaskManager.notification.threadPool.minSize", 5);
        this.notificationAsyncTaskManagerThreadPoolMaxIdle = settings.getIntProperty("asyncTaskManager.notification.threadPool.maxIdle", 10);
        this.notificationAsyncTaskManagerThreadPoolMaxSize = settings.getIntProperty("asyncTaskManager.notification.threadPool.maxSize", 15);
        this.deliveryAsyncTaskManagerThreadPoolMinSize = settings.getIntProperty("asyncTaskManager.delivery.threadPool.minSize", 5);
        this.deliveryAsyncTaskManagerThreadPoolMaxIdle = settings.getIntProperty("asyncTaskManager.delivery.threadPool.maxIdle", 5);
        this.deliveryAsyncTaskManagerThreadPoolMaxSize = settings.getIntProperty("asyncTaskManager.delivery.threadPool.maxSize", 10);
        this.diskIOAsyncTaskManagerThreadPoolMinSize = settings.getIntProperty("asyncTaskManager.diskIO.threadPool.minSize", 2);
        this.diskIOAsyncTaskManagerThreadPoolMaxIdle = settings.getIntProperty("asyncTaskManager.diskIO.threadPool.maxIdle", 2);
        this.diskIOAsyncTaskManagerThreadPoolMaxSize = settings.getIntProperty("asyncTaskManager.diskIO.threadPool.maxSize", 4);
        this.consumerPrefetchSize = settings.getIntProperty("consumer.prefetch.size", 10);
        if (this.consumerPrefetchSize < 1) {
            this.consumerPrefetchSize = 1;
        }
        this.watchdogConsumerInactivityTimeout = settings.getIntProperty("watchdog.consumer.inactivityTimeout", 5);
        this.redeliveryDelay = settings.getLongProperty("delivery.redeliveryDelay", 0L);
        this.internalNotificationQueueMaxSize = settings.getIntProperty("notification.queue.maxSize", 200);
    }

    public int getInternalNotificationQueueMaxSize() {
        return this.internalNotificationQueueMaxSize;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public File getDestinationDefinitionsDir() {
        return this.destinationDefinitionsDir;
    }

    public File getBridgeDefinitionsDir() {
        return this.bridgeDefinitionsDir;
    }

    public File getTemplatesDir() {
        return this.templatesDir;
    }

    public File getTemplateMappingFile() {
        return this.templateMappingFile;
    }

    public File getDefaultDataDir() {
        return this.defaultDataDir;
    }

    public boolean doAutoCreateQueues() {
        return this.autoCreateQueues;
    }

    public boolean doAutoCreateTopics() {
        return this.autoCreateTopics;
    }

    public boolean doDeployQueuesOnStartup() {
        return this.deployQueuesOnStartup;
    }

    public boolean doDeployTopicsOnStartup() {
        return this.deployTopicsOnStartup;
    }

    public int getConsumerPrefetchSize() {
        return this.consumerPrefetchSize;
    }

    public int getNotificationAsyncTaskManagerThreadPoolMinSize() {
        return this.notificationAsyncTaskManagerThreadPoolMinSize;
    }

    public int getNotificationAsyncTaskManagerThreadPoolMaxIdle() {
        return this.notificationAsyncTaskManagerThreadPoolMaxIdle;
    }

    public int getNotificationAsyncTaskManagerThreadPoolMaxSize() {
        return this.notificationAsyncTaskManagerThreadPoolMaxSize;
    }

    public int getDeliveryAsyncTaskManagerThreadPoolMinSize() {
        return this.deliveryAsyncTaskManagerThreadPoolMinSize;
    }

    public int getDeliveryAsyncTaskManagerThreadPoolMaxIdle() {
        return this.deliveryAsyncTaskManagerThreadPoolMaxIdle;
    }

    public int getDeliveryAsyncTaskManagerThreadPoolMaxSize() {
        return this.deliveryAsyncTaskManagerThreadPoolMaxSize;
    }

    public int getDiskIOAsyncTaskManagerThreadPoolMinSize() {
        return this.diskIOAsyncTaskManagerThreadPoolMinSize;
    }

    public int getDiskIOAsyncTaskManagerThreadPoolMaxIdle() {
        return this.diskIOAsyncTaskManagerThreadPoolMaxIdle;
    }

    public int getDiskIOAsyncTaskManagerThreadPoolMaxSize() {
        return this.diskIOAsyncTaskManagerThreadPoolMaxSize;
    }

    public int getWatchdogConsumerInactivityTimeout() {
        return this.watchdogConsumerInactivityTimeout;
    }

    public String getSecurityConnectorType() {
        return this.securityConnectorType;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }
}

