/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.local.session;

import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.destination.TemporaryDestination;
import net.timewalker.ffmq4.common.message.MessageSelector;
import net.timewalker.ffmq4.common.session.AbstractQueueBrowser;
import net.timewalker.ffmq4.local.connection.LocalConnection;
import net.timewalker.ffmq4.local.destination.LocalQueue;
import net.timewalker.ffmq4.local.session.LocalQueueBrowserEnumeration;
import net.timewalker.ffmq4.local.session.LocalSession;
import net.timewalker.ffmq4.utils.StringTools;
import net.timewalker.ffmq4.utils.id.IntegerID;
import net.timewalker.ffmq4.utils.id.UUIDProvider;

public final class LocalQueueBrowser
extends AbstractQueueBrowser {
    private MessageSelector parsedSelector;

    public LocalQueueBrowser(LocalSession session, LocalQueue queue, String messageSelector, IntegerID browserId) throws JMSException {
        super(session, queue, messageSelector, browserId);
        this.parsedSelector = StringTools.isNotEmpty(messageSelector) ? new MessageSelector(messageSelector) : null;
    }

    public Enumeration getEnumeration() throws JMSException {
        this.checkNotClosed();
        this.checkDestinationPermission();
        LocalQueueBrowserEnumeration queueBrowserEnum = new LocalQueueBrowserEnumeration(this, (LocalQueue)this.queue, this.parsedSelector, UUIDProvider.getInstance().getShortUUID());
        this.registerEnumeration(queueBrowserEnum);
        return queueBrowserEnum;
    }

    private final void checkDestinationPermission() throws JMSException {
        if (!(this.queue instanceof TemporaryDestination)) {
            boolean adminRequest = false;
            String queueName = this.queue.getQueueName();
            if (queueName.equals("_FFMQ_ADM_REQUEST")) {
                LocalConnection conn = (LocalConnection)this.session.getConnection();
                if (conn.getSecurityContext() != null) {
                    throw new FFMQException("Access denied to administration queue " + queueName, "ACCESS_DENIED");
                }
                adminRequest = true;
            } else if (queueName.equals("_FFMQ_ADM_REPLY")) {
                LocalConnection conn = (LocalConnection)this.session.getConnection();
                conn.checkPermission("server", "remoteAdmin");
                adminRequest = true;
            }
            if (!adminRequest) {
                ((LocalConnection)this.session.getConnection()).checkPermission((Destination)this.queue, "browse");
            }
        }
    }
}

