/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.local.destination;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.Destination;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.local.MessageLockSet;
import net.timewalker.ffmq4.local.destination.LocalDestinationMBean;
import net.timewalker.ffmq4.local.session.LocalMessageConsumer;
import net.timewalker.ffmq4.local.session.LocalSession;
import net.timewalker.ffmq4.management.destination.definition.AbstractDestinationDefinition;
import net.timewalker.ffmq4.storage.data.DataStoreException;
import net.timewalker.ffmq4.utils.Committable;
import net.timewalker.ffmq4.utils.concurrent.SynchronizationBarrier;

public abstract class AbstractLocalDestination
implements Destination,
LocalDestinationMBean,
Committable {
    protected AbstractDestinationDefinition destinationDef;
    protected List<LocalMessageConsumer> localConsumers = new ArrayList<LocalMessageConsumer>();
    protected ReentrantReadWriteLock consumersLock = new ReentrantReadWriteLock();
    protected ReentrantLock transactionLock = new ReentrantLock();
    private long cumulativeCommitTime;
    private long commitCount;
    private long minCommitTime = Integer.MAX_VALUE;
    private long maxCommitTime = 0L;
    protected boolean closed;
    protected Object closeLock = new Object();

    public AbstractLocalDestination(AbstractDestinationDefinition destinationDef) {
        this.destinationDef = destinationDef;
    }

    @Override
    public final String getName() {
        return this.destinationDef.getName();
    }

    public void registerConsumer(LocalMessageConsumer consumer) {
        this.consumersLock.writeLock().lock();
        try {
            this.localConsumers.add(consumer);
        }
        finally {
            this.consumersLock.writeLock().unlock();
        }
    }

    public void unregisterConsumer(LocalMessageConsumer consumer) {
        this.consumersLock.writeLock().lock();
        try {
            this.localConsumers.remove(consumer);
        }
        finally {
            this.consumersLock.writeLock().unlock();
        }
    }

    public final boolean isClosed() {
        return this.closed;
    }

    protected final void checkNotClosed() throws JMSException {
        if (this.closed) {
            throw new FFMQException("Destination is closed", "DESTINATION_IS_CLOSED");
        }
    }

    protected final void checkTransactionLock() throws JMSException {
        if (this.requiresTransactionalUpdate() && !this.transactionLock.isHeldByCurrentThread()) {
            throw new FFMQException("Destination is not locked for update", "DESTINATION_NOT_LOCKED");
        }
    }

    @Override
    public final int getRegisteredConsumersCount() {
        return this.localConsumers.size();
    }

    @Override
    public final boolean isTemporary() {
        return this.destinationDef.isTemporary();
    }

    @Override
    public int getStorageSyncMethod() {
        return this.destinationDef.getStorageSyncMethod();
    }

    @Override
    public final int getInitialBlockCount() {
        return this.destinationDef.getInitialBlockCount();
    }

    @Override
    public int getMaxBlockCount() {
        return this.destinationDef.getMaxBlockCount();
    }

    @Override
    public boolean isUseJournal() {
        return this.destinationDef.isUseJournal();
    }

    @Override
    public final int getBlockSize() {
        return this.destinationDef.getBlockSize();
    }

    @Override
    public final int getMaxNonPersistentMessages() {
        return this.destinationDef.getMaxNonPersistentMessages();
    }

    @Override
    public int getAutoExtendAmount() {
        return this.destinationDef.getAutoExtendAmount();
    }

    @Override
    public int getJournalOutputBuffer() {
        return this.destinationDef.getJournalOutputBuffer();
    }

    @Override
    public long getMaxJournalSize() {
        return this.destinationDef.getMaxJournalSize();
    }

    @Override
    public int getMaxUnflushedJournalSize() {
        return this.destinationDef.getMaxUnflushedJournalSize();
    }

    @Override
    public int getMaxUncommittedStoreSize() {
        return this.destinationDef.getMaxUncommittedStoreSize();
    }

    @Override
    public int getMaxWriteBatchSize() {
        return this.destinationDef.getMaxWriteBatchSize();
    }

    @Override
    public boolean isPreAllocateFiles() {
        return this.destinationDef.isPreAllocateFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final LocalMessageConsumer lookupConsumer(String consumerID) {
        this.consumersLock.readLock().lock();
        try {
            for (int i = 0; i < this.localConsumers.size(); ++i) {
                LocalMessageConsumer consumer = this.localConsumers.get(i);
                if (!consumer.getSubscriberId().equals(consumerID)) continue;
                LocalMessageConsumer localMessageConsumer = consumer;
                return localMessageConsumer;
            }
            LocalMessageConsumer localMessageConsumer = null;
            return localMessageConsumer;
        }
        finally {
            this.consumersLock.readLock().unlock();
        }
    }

    protected final boolean isConsumerRegistered(String consumerID) {
        return this.lookupConsumer(consumerID) != null;
    }

    @Override
    public final long getMinCommitTime() {
        return this.commitCount == 0L ? 0L : this.minCommitTime;
    }

    @Override
    public final long getMaxCommitTime() {
        return this.maxCommitTime;
    }

    @Override
    public final double getAverageCommitTime() {
        long commits = this.commitCount;
        if (commits == 0L) {
            return 0.0;
        }
        return (double)this.cumulativeCommitTime / (double)commits;
    }

    protected final void notifyCommitTime(long duration) {
        if (duration > this.maxCommitTime) {
            this.maxCommitTime = duration;
        }
        if (duration < this.minCommitTime) {
            this.minCommitTime = duration;
        }
        this.cumulativeCommitTime += duration;
        ++this.commitCount;
    }

    @Override
    public void resetStats() {
        this.minCommitTime = Integer.MAX_VALUE;
        this.maxCommitTime = 0L;
        this.cumulativeCommitTime = 0L;
        this.commitCount = 0L;
    }

    public abstract void close() throws JMSException;

    protected abstract boolean requiresTransactionalUpdate();

    protected abstract boolean hasPendingChanges();

    @Override
    public final void openTransaction() {
        if (this.requiresTransactionalUpdate()) {
            this.transactionLock.lock();
        }
    }

    @Override
    public void closeTransaction() {
        boolean pendingChanges = this.hasPendingChanges();
        if (this.requiresTransactionalUpdate()) {
            this.transactionLock.unlock();
        }
        if (pendingChanges) {
            throw new IllegalStateException("Pending changes not commited.");
        }
    }

    @Override
    public void commitChanges() throws JMSException {
        try {
            SynchronizationBarrier barrier = new SynchronizationBarrier();
            this.commitChanges(barrier);
            barrier.waitFor();
        }
        catch (InterruptedException e) {
            throw new DataStoreException("Wait for commit barrier was interrupted");
        }
    }

    public abstract boolean putLocked(AbstractMessage var1, LocalSession var2, MessageLockSet var3) throws JMSException;
}

