/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.local.connection;

import java.util.HashSet;
import java.util.Set;
import javax.jms.InvalidClientIDException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClientIDRegistry {
    private static final Log log = LogFactory.getLog(ClientIDRegistry.class);
    private static ClientIDRegistry instance = null;
    private Set<String> clientIDs = new HashSet<String>();

    public static synchronized ClientIDRegistry getInstance() {
        if (instance == null) {
            instance = new ClientIDRegistry();
        }
        return instance;
    }

    private ClientIDRegistry() {
    }

    public synchronized void register(String clientID) throws InvalidClientIDException {
        if (!this.clientIDs.add(clientID)) {
            log.error((Object)("Client ID already exists : " + clientID));
            throw new InvalidClientIDException("Client ID already exists : " + clientID);
        }
        log.debug((Object)("Registered clientID : " + clientID));
    }

    public synchronized void unregister(String clientID) {
        if (this.clientIDs.remove(clientID)) {
            log.debug((Object)("Unregistered clientID : " + clientID));
        }
    }
}

