/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.message.MessageConvertTools;
import net.timewalker.ffmq4.utils.RawDataBuffer;

public final class StreamMessageImpl
extends AbstractMessage
implements StreamMessage {
    private Vector<Object> body = new Vector();
    private transient int readPos;
    private transient ByteArrayInputStream currentByteInputStream;
    private transient int readPosBackup;
    private transient ByteArrayInputStream currentByteInputStreamBackup;

    @Override
    protected byte getType() {
        return 5;
    }

    @Override
    protected void unserializeBodyFrom(RawDataBuffer in) {
        int size = in.readInt();
        this.body.ensureCapacity(size);
        for (int n = 0; n < size; ++n) {
            Object value = in.readGeneric();
            this.body.add(value);
        }
    }

    @Override
    protected final void serializeBodyTo(RawDataBuffer out) {
        out.writeInt(this.body.size());
        for (int n = 0; n < this.body.size(); ++n) {
            Object value = this.body.get(n);
            out.writeGeneric(value);
        }
    }

    private void backupState() {
        this.readPosBackup = this.readPos;
        this.currentByteInputStreamBackup = this.currentByteInputStream;
        if (this.currentByteInputStream != null) {
            this.currentByteInputStream.mark(-1);
        }
    }

    private void restoreState() {
        this.readPos = this.readPosBackup;
        this.currentByteInputStream = this.currentByteInputStreamBackup;
        if (this.currentByteInputStream != null) {
            this.currentByteInputStream.reset();
        }
    }

    public boolean readBoolean() throws JMSException {
        this.backupState();
        try {
            return MessageConvertTools.asBoolean(this.internalReadObject());
        }
        catch (JMSException e) {
            this.restoreState();
            throw e;
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public byte readByte() throws JMSException {
        this.backupState();
        try {
            return MessageConvertTools.asByte(this.internalReadObject());
        }
        catch (JMSException e) {
            this.restoreState();
            throw e;
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.backupState();
        try {
            if (this.currentByteInputStream == null) {
                byte[] base = MessageConvertTools.asBytes(this.internalReadObject());
                if (base == null) {
                    return -1;
                }
                this.currentByteInputStream = new ByteArrayInputStream(base);
            }
            try {
                int readAmount = this.currentByteInputStream.read(value);
                if (readAmount < value.length) {
                    this.currentByteInputStream = null;
                }
                return readAmount;
            }
            catch (IOException e) {
                throw new FFMQException("Cannot read stream message body", "IO_ERROR", e);
            }
        }
        catch (JMSException e) {
            this.restoreState();
            throw e;
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public char readChar() throws JMSException {
        this.backupState();
        try {
            return MessageConvertTools.asChar(this.internalReadObject());
        }
        catch (JMSException e) {
            this.restoreState();
            throw e;
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public double readDouble() throws JMSException {
        this.backupState();
        try {
            return MessageConvertTools.asDouble(this.internalReadObject());
        }
        catch (JMSException e) {
            this.restoreState();
            throw e;
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public float readFloat() throws JMSException {
        this.backupState();
        try {
            return MessageConvertTools.asFloat(this.internalReadObject());
        }
        catch (JMSException e) {
            this.restoreState();
            throw e;
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public int readInt() throws JMSException {
        this.backupState();
        try {
            return MessageConvertTools.asInt(this.internalReadObject());
        }
        catch (JMSException e) {
            this.restoreState();
            throw e;
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public long readLong() throws JMSException {
        this.backupState();
        try {
            return MessageConvertTools.asLong(this.internalReadObject());
        }
        catch (JMSException e) {
            this.restoreState();
            throw e;
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public Object readObject() throws JMSException {
        return this.internalReadObject();
    }

    public Object internalReadObject() throws JMSException {
        if (!this.bodyIsReadOnly) {
            throw new MessageNotReadableException("Message body is write only");
        }
        if (this.readPos >= this.body.size()) {
            throw new MessageEOFException("End of stream reached");
        }
        if (this.currentByteInputStream != null) {
            throw new MessageFormatException("Cannot read another object before the end of the byte array");
        }
        return this.body.get(this.readPos++);
    }

    public short readShort() throws JMSException {
        this.backupState();
        try {
            return MessageConvertTools.asShort(this.internalReadObject());
        }
        catch (JMSException e) {
            this.restoreState();
            throw e;
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public String readString() throws JMSException {
        this.backupState();
        try {
            return MessageConvertTools.asString(this.internalReadObject());
        }
        catch (JMSException e) {
            this.restoreState();
            throw e;
        }
        catch (RuntimeException e) {
            this.restoreState();
            throw e;
        }
    }

    public void reset() {
        this.bodyIsReadOnly = true;
        this.readPos = 0;
        this.currentByteInputStream = null;
    }

    private void write(Object value) throws JMSException {
        this.assertDeserializationLevel(3);
        if (this.bodyIsReadOnly) {
            throw new MessageNotWriteableException("Message body is read-only");
        }
        this.body.add(value);
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.write(value);
    }

    public void writeByte(byte value) throws JMSException {
        this.write(value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.write(value.clone());
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        byte[] reducedValue = new byte[length];
        System.arraycopy(value, offset, reducedValue, 0, length);
        this.write(reducedValue);
    }

    public void writeChar(char value) throws JMSException {
        this.write(new Character(value));
    }

    public void writeDouble(double value) throws JMSException {
        this.write(new Double(value));
    }

    public void writeFloat(float value) throws JMSException {
        this.write(new Float(value));
    }

    public void writeInt(int value) throws JMSException {
        this.write(value);
    }

    public void writeLong(long value) throws JMSException {
        this.write(value);
    }

    public void writeObject(Object value) throws JMSException {
        if (!(value == null || value instanceof Boolean || value instanceof Byte || value instanceof Character || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[])) {
            throw new MessageFormatException("Unsupported value type : " + value.getClass().getName());
        }
        this.write(value);
    }

    public void writeShort(short value) throws JMSException {
        this.write(value);
    }

    public void writeString(String value) throws JMSException {
        this.write(value);
    }

    public void clearBody() {
        this.assertDeserializationLevel(3);
        this.bodyIsReadOnly = false;
        this.body.clear();
        this.readPos = 0;
        this.currentByteInputStream = null;
    }

    @Override
    public AbstractMessage copy() {
        Vector bodyClone;
        StreamMessageImpl clone = new StreamMessageImpl();
        this.copyCommonFields(clone);
        clone.body = bodyClone = (Vector)this.body.clone();
        return clone;
    }
}

