/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.destination.DestinationSerializer;
import net.timewalker.ffmq4.common.destination.DestinationTools;
import net.timewalker.ffmq4.common.message.MessageConvertTools;
import net.timewalker.ffmq4.common.session.AbstractSession;
import net.timewalker.ffmq4.utils.EmptyEnumeration;
import net.timewalker.ffmq4.utils.IteratorEnumeration;
import net.timewalker.ffmq4.utils.RawDataBuffer;

public abstract class AbstractMessage
implements Message {
    private String id;
    private String correlId;
    private int priority;
    private int deliveryMode;
    private Destination destination;
    private long expiration;
    private boolean redelivered;
    private Destination replyTo;
    private long timestamp;
    private String type;
    private Map<String, Object> propertyMap;
    private int unserializationLevel;
    private RawDataBuffer rawMessage;
    private boolean propertiesAreReadOnly;
    protected boolean bodyIsReadOnly;
    private transient WeakReference<AbstractSession> sessionRef;
    private transient boolean internalCopy = false;

    public final RawDataBuffer getRawMessage() {
        return this.rawMessage;
    }

    public abstract AbstractMessage copy();

    protected final void copyCommonFields(AbstractMessage clone) {
        Map propertyMapClone;
        clone.id = this.id;
        clone.correlId = this.correlId;
        clone.priority = this.priority;
        clone.deliveryMode = this.deliveryMode;
        clone.destination = this.destination;
        clone.expiration = this.expiration;
        clone.redelivered = this.redelivered;
        clone.replyTo = this.replyTo;
        clone.timestamp = this.timestamp;
        clone.type = this.type;
        clone.propertyMap = propertyMapClone = this.propertyMap != null ? (Map)((HashMap)this.propertyMap).clone() : null;
        clone.unserializationLevel = this.unserializationLevel;
        if (this.rawMessage != null) {
            clone.rawMessage = this.rawMessage.copy();
        }
    }

    public final void setSession(AbstractSession session) throws JMSException {
        if (session == null) {
            this.sessionRef = null;
        } else {
            if (this.sessionRef != null && this.sessionRef.get() != session) {
                throw new FFMQException("Message session already set", "CONSISTENCY");
            }
            this.sessionRef = new WeakReference<AbstractSession>(session);
        }
    }

    protected final AbstractSession getSession() throws JMSException {
        if (this.sessionRef == null) {
            throw new FFMQException("Message has no associated session", "CONSISTENCY");
        }
        AbstractSession session = (AbstractSession)this.sessionRef.get();
        if (session == null) {
            throw new FFMQException("Message session is no longer valid", "CONSISTENCY");
        }
        return session;
    }

    public final void acknowledge() throws JMSException {
        AbstractSession session = this.getSession();
        int acknowledgeMode = session.getAcknowledgeMode();
        if (acknowledgeMode != 2) {
            return;
        }
        session.acknowledge();
    }

    public final void clearProperties() {
        if (this.propertyMap != null) {
            this.propertyMap.clear();
        }
        this.propertiesAreReadOnly = false;
    }

    public final boolean getBooleanProperty(String name) throws JMSException {
        return MessageConvertTools.asBoolean(this.getProperty(name));
    }

    public final byte getByteProperty(String name) throws JMSException {
        return MessageConvertTools.asByte(this.getProperty(name));
    }

    public final double getDoubleProperty(String name) throws JMSException {
        return MessageConvertTools.asDouble(this.getProperty(name));
    }

    public final float getFloatProperty(String name) throws JMSException {
        return MessageConvertTools.asFloat(this.getProperty(name));
    }

    public final int getIntProperty(String name) throws JMSException {
        return MessageConvertTools.asInt(this.getProperty(name));
    }

    public final String getJMSCorrelationID() {
        this.assertDeserializationLevel(2);
        return this.correlId;
    }

    public final byte[] getJMSCorrelationIDAsBytes() {
        throw new UnsupportedOperationException();
    }

    public final int getJMSDeliveryMode() {
        return this.deliveryMode;
    }

    public final Destination getJMSDestination() {
        return this.destination;
    }

    public final long getJMSExpiration() {
        return this.expiration;
    }

    public final String getJMSMessageID() {
        return this.id != null ? "ID:" + this.id : null;
    }

    public final int getJMSPriority() {
        return this.priority;
    }

    public final boolean getJMSRedelivered() {
        return this.redelivered;
    }

    public final Destination getJMSReplyTo() {
        this.assertDeserializationLevel(2);
        return this.replyTo;
    }

    public final long getJMSTimestamp() {
        this.assertDeserializationLevel(2);
        return this.timestamp;
    }

    public final String getJMSType() {
        this.assertDeserializationLevel(2);
        return this.type;
    }

    public final long getLongProperty(String name) throws JMSException {
        return MessageConvertTools.asLong(this.getProperty(name));
    }

    public final Object getObjectProperty(String name) {
        return this.getProperty(name);
    }

    public final short getShortProperty(String name) throws JMSException {
        return MessageConvertTools.asShort(this.getProperty(name));
    }

    public final String getStringProperty(String name) throws JMSException {
        return MessageConvertTools.asString(this.getProperty(name));
    }

    public final boolean propertyExists(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Empty property name");
        }
        this.assertDeserializationLevel(2);
        return this.propertyMap != null ? this.propertyMap.containsKey(name) : false;
    }

    public final void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setProperty(name, value);
    }

    public final void setByteProperty(String name, byte value) throws JMSException {
        this.setProperty(name, value);
    }

    public final void setDoubleProperty(String name, double value) throws JMSException {
        this.setProperty(name, new Double(value));
    }

    public final void setFloatProperty(String name, float value) throws JMSException {
        this.setProperty(name, new Float(value));
    }

    public final void setIntProperty(String name, int value) throws JMSException {
        this.setProperty(name, value);
    }

    public final void setJMSCorrelationID(String correlationID) {
        this.assertDeserializationLevel(3);
        this.correlId = correlationID;
    }

    public final void setJMSCorrelationIDAsBytes(byte[] correlationID) {
        throw new UnsupportedOperationException();
    }

    public final void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode != 2 && deliveryMode != 1) {
            throw new FFMQException("Invalid delivery mode : " + deliveryMode, "INVALID_DELIVERY_MODE");
        }
        this.assertDeserializationLevel(3);
        this.deliveryMode = deliveryMode;
    }

    public final void setJMSDestination(Destination destination) throws JMSException {
        this.assertDeserializationLevel(3);
        this.destination = DestinationTools.asRef(destination);
    }

    public final void setJMSExpiration(long expiration) {
        this.assertDeserializationLevel(3);
        this.expiration = expiration;
    }

    public final void setJMSMessageID(String id) throws JMSException {
        this.assertDeserializationLevel(3);
        this.id = id;
    }

    public final void setJMSPriority(int priority) throws JMSException {
        if (priority < 0 || priority > 9) {
            throw new FFMQException("Invalid priority value : " + priority, "INVALID_PRIORITY");
        }
        this.assertDeserializationLevel(3);
        this.priority = priority;
    }

    public final void setJMSRedelivered(boolean redelivered) {
        this.redelivered = redelivered;
        if (this.rawMessage != null) {
            byte flags = this.rawMessage.readByte(1);
            flags = redelivered ? (byte)(flags | 0x10) : (byte)(flags & 0xFFFFFFEF);
            this.rawMessage.writeByte(flags, 1);
        }
    }

    public final void setJMSReplyTo(Destination replyTo) {
        this.assertDeserializationLevel(3);
        this.replyTo = replyTo;
    }

    public final void setJMSTimestamp(long timestamp) {
        this.assertDeserializationLevel(3);
        this.timestamp = timestamp;
    }

    public final void setJMSType(String type) {
        this.assertDeserializationLevel(3);
        this.type = type;
    }

    public final void setLongProperty(String name, long value) throws JMSException {
        this.setProperty(name, value);
    }

    public final void setObjectProperty(String name, Object value) throws JMSException {
        if (value == null) {
            throw new MessageFormatException("A property value cannot be null");
        }
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String)) {
            throw new MessageFormatException("Unsupported property value type : " + value.getClass().getName());
        }
        this.setProperty(name, value);
    }

    private void setProperty(String name, Object value) throws JMSException {
        if (this.propertiesAreReadOnly) {
            throw new MessageNotWriteableException("Message properties are read-only");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Empty property name");
        }
        this.assertDeserializationLevel(3);
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap<String, Object>(17);
        }
        this.propertyMap.put(name, value);
    }

    private Object getProperty(String name) {
        this.assertDeserializationLevel(2);
        return this.propertyMap != null ? this.propertyMap.get(name) : null;
    }

    public final void setShortProperty(String name, short value) throws JMSException {
        this.setProperty(name, value);
    }

    public final void setStringProperty(String name, String value) throws JMSException {
        this.setProperty(name, value);
    }

    public final Enumeration<String> getPropertyNames() {
        this.assertDeserializationLevel(2);
        if (this.propertyMap == null) {
            return new EmptyEnumeration<String>();
        }
        return new IteratorEnumeration<String>(this.propertyMap.keySet().iterator());
    }

    public final boolean isInternalCopy() {
        return this.internalCopy;
    }

    public final void setInternalCopy(boolean copy) {
        this.internalCopy = copy;
    }

    protected abstract byte getType();

    protected final void serializeTo(RawDataBuffer out) {
        byte lvl1Flags = (byte)((this.priority & 0xF) + (this.redelivered ? 16 : 0) + (this.deliveryMode == 2 ? 32 : 0) + (this.expiration != 0L ? 64 : 0) + (this.id != null ? 128 : 0));
        out.writeByte(lvl1Flags);
        if (this.expiration != 0L) {
            out.writeLong(this.expiration);
        }
        if (this.id != null) {
            out.writeUTF(this.id);
        }
        DestinationSerializer.serializeTo(this.destination, out);
        byte lvl2Flags = (byte)((this.correlId != null ? 1 : 0) + (this.replyTo != null ? 2 : 0) + (this.timestamp != 0L ? 4 : 0) + (this.type != null ? 8 : 0) + (this.propertyMap != null && !this.propertyMap.isEmpty() ? 16 : 0));
        out.writeByte(lvl2Flags);
        if (this.correlId != null) {
            out.writeUTF(this.correlId);
        }
        if (this.replyTo != null) {
            DestinationSerializer.serializeTo(this.replyTo, out);
        }
        if (this.timestamp != 0L) {
            out.writeLong(this.timestamp);
        }
        if (this.type != null) {
            out.writeUTF(this.type);
        }
        if (this.propertyMap != null && !this.propertyMap.isEmpty()) {
            this.writeMapTo(this.propertyMap, out);
        }
        this.serializeBodyTo(out);
    }

    protected final void initializeFromRaw(RawDataBuffer rawMessage) {
        this.rawMessage = rawMessage;
        this.unserializationLevel = 1;
        byte lvl1Flags = rawMessage.readByte();
        this.priority = lvl1Flags & 0xF;
        this.redelivered = (lvl1Flags & 0x10) != 0;
        int n = this.deliveryMode = (lvl1Flags & 0x20) != 0 ? 2 : 1;
        if ((lvl1Flags & 0x40) != 0) {
            this.expiration = rawMessage.readLong();
        }
        if ((lvl1Flags & 0x80) != 0) {
            this.id = rawMessage.readUTF();
        }
        this.destination = DestinationSerializer.unserializeFrom(rawMessage);
    }

    public final synchronized void ensureDeserializationLevel(int targetLevel) {
        if (this.rawMessage == null) {
            return;
        }
        while (this.unserializationLevel < targetLevel) {
            if (this.unserializationLevel == 1) {
                byte lvl2Flags = this.rawMessage.readByte();
                if ((lvl2Flags & 1) != 0) {
                    this.correlId = this.rawMessage.readUTF();
                }
                if ((lvl2Flags & 2) != 0) {
                    this.replyTo = DestinationSerializer.unserializeFrom(this.rawMessage);
                }
                if ((lvl2Flags & 4) != 0) {
                    this.timestamp = this.rawMessage.readLong();
                }
                if ((lvl2Flags & 8) != 0) {
                    this.type = this.rawMessage.readUTF();
                }
                if ((lvl2Flags & 0x10) != 0) {
                    this.propertyMap = this.readMapFrom(this.rawMessage);
                }
                this.unserializationLevel = 2;
                continue;
            }
            if (this.unserializationLevel != 2) continue;
            this.unserializeBodyFrom(this.rawMessage);
            this.unserializationLevel = 3;
            this.rawMessage = null;
        }
    }

    protected final synchronized void assertDeserializationLevel(int targetLevel) {
        if (this.rawMessage == null) {
            return;
        }
        if (this.unserializationLevel < targetLevel) {
            throw new IllegalStateException("Message is not deserialized (level=" + this.unserializationLevel + ")");
        }
    }

    public final void markAsReadOnly() {
        this.propertiesAreReadOnly = true;
        this.bodyIsReadOnly = true;
    }

    protected abstract void serializeBodyTo(RawDataBuffer var1);

    protected abstract void unserializeBodyFrom(RawDataBuffer var1);

    protected final void writeMapTo(Map<String, Object> map, RawDataBuffer out) {
        if (map == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(map.size());
        if (!map.isEmpty()) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeGeneric(entry.getValue());
            }
        }
    }

    protected final Map<String, Object> readMapFrom(RawDataBuffer in) {
        int mapSize = in.readInt();
        if (mapSize == 0) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(Math.max(17, mapSize * 4 / 3));
        for (int n = 0; n < mapSize; ++n) {
            String propName = in.readUTF();
            Object propValue = in.readGeneric();
            map.put(propName, propValue);
        }
        return map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[messageId=");
        sb.append(this.id);
        sb.append(" priority=");
        sb.append(this.priority);
        sb.append(" correlId=");
        sb.append(this.correlId);
        sb.append(" deliveryMode=");
        sb.append(this.deliveryMode);
        sb.append(" destination=");
        sb.append(this.destination);
        sb.append(" expiration=");
        sb.append(this.expiration);
        sb.append(" redelivered=");
        sb.append(this.redelivered);
        sb.append(" replyTo=");
        sb.append(this.replyTo);
        sb.append(" timestamp=");
        sb.append(this.timestamp);
        sb.append(" type=");
        sb.append(this.type);
        if (this.propertyMap != null && this.propertyMap.size() > 0) {
            sb.append(" properties=");
            Iterator<String> allProps = this.propertyMap.keySet().iterator();
            int count = 0;
            while (allProps.hasNext()) {
                String propName = allProps.next();
                Object propValue = this.propertyMap.get(propName);
                if (count++ > 0) {
                    sb.append(",");
                }
                sb.append(propName);
                sb.append("=");
                sb.append(propValue);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

