/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.utils.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.jms.JMSException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.utils.descriptor.AbstractDescriptor;
import net.timewalker.ffmq4.utils.xml.AbstractXMLDescriptorHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDescriptorReader {
    private static final Log log = LogFactory.getLog(XMLDescriptorReader.class);

    public AbstractDescriptor read(File descriptorFile, Class<? extends AbstractXMLDescriptorHandler> handlerClass) throws JMSException {
        AbstractXMLDescriptorHandler handler;
        if (!descriptorFile.canRead()) {
            throw new FFMQException("Can't read descriptor file : " + descriptorFile.getAbsolutePath(), "FS_ERROR");
        }
        log.debug((Object)("Parsing descriptor : " + descriptorFile.getAbsolutePath()));
        try {
            handler = handlerClass.newInstance();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            FileInputStream in = new FileInputStream(descriptorFile);
            parser.parse((InputStream)in, (DefaultHandler)handler);
            in.close();
        }
        catch (Exception e) {
            throw new FFMQException("Cannot parse descriptor file : " + descriptorFile.getAbsolutePath(), "PARSE_ERROR", e);
        }
        AbstractDescriptor descriptor = handler.getDescriptor();
        descriptor.setDescriptorFile(descriptorFile);
        return descriptor;
    }
}

