/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport.tcp.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class TcpBufferedInputStream
extends FilterInputStream {
    private byte[] buffer;
    private int capacity;
    private int size;
    private int pos;

    public TcpBufferedInputStream(InputStream in, int capacity) {
        super(in);
        this.buffer = new byte[capacity];
        this.capacity = capacity;
    }

    private void readMore() throws IOException {
        this.size = 0;
        this.pos = 0;
        int amount = this.in.read(this.buffer, 0, this.capacity);
        if (amount > 0) {
            this.size += amount;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.size) {
            this.readMore();
            if (this.pos >= this.size) {
                return -1;
            }
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int amount;
        if (len == 0) {
            return 0;
        }
        int totalRead = 0;
        do {
            if ((amount = this.readBufferedOrAvailable(b, off + totalRead, len - totalRead)) > 0) continue;
            return totalRead == 0 ? amount : totalRead;
        } while ((totalRead += amount) < len && this.in.available() > 0);
        return totalRead;
    }

    private int readBufferedOrAvailable(byte[] b, int off, int len) throws IOException {
        int maxAmount = this.size - this.pos;
        if (maxAmount <= 0) {
            if (len >= this.capacity) {
                return this.in.read(b, off, len);
            }
            this.readMore();
            maxAmount = this.size - this.pos;
            if (maxAmount <= 0) {
                return -1;
            }
        }
        int amount = maxAmount > len ? len : maxAmount;
        System.arraycopy(this.buffer, this.pos, b, off, amount);
        this.pos += amount;
        return amount;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long skippable = this.size - this.pos;
        if (skippable <= 0L) {
            return super.skip(n);
        }
        long skipped = skippable >= n ? n : skippable;
        this.pos = (int)((long)this.pos + skipped);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return super.available() + (this.size - this.pos);
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

