/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport.packet.query;

import javax.jms.Destination;
import net.timewalker.ffmq4.common.destination.DestinationSerializer;
import net.timewalker.ffmq4.transport.packet.query.AbstractSessionQuery;
import net.timewalker.ffmq4.utils.RawDataBuffer;
import net.timewalker.ffmq4.utils.id.IntegerID;

public final class CreateConsumerQuery
extends AbstractSessionQuery {
    private IntegerID consumerId;
    private Destination destination;
    private String messageSelector;
    private boolean noLocal;

    @Override
    public byte getType() {
        return 9;
    }

    @Override
    protected void serializeTo(RawDataBuffer out) {
        super.serializeTo(out);
        out.writeInt(this.consumerId.asInt());
        DestinationSerializer.serializeTo(this.destination, out);
        out.writeNullableUTF(this.messageSelector);
        out.writeBoolean(this.noLocal);
    }

    @Override
    protected void unserializeFrom(RawDataBuffer in) {
        super.unserializeFrom(in);
        this.consumerId = new IntegerID(in.readInt());
        this.destination = DestinationSerializer.unserializeFrom(in);
        this.messageSelector = in.readNullableUTF();
        this.noLocal = in.readBoolean();
    }

    public IntegerID getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(IntegerID consumerId) {
        this.consumerId = consumerId;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" consumerId=");
        sb.append(this.consumerId);
        sb.append(" destination=");
        sb.append(this.destination);
        sb.append(" messageSelector=[");
        sb.append(this.messageSelector);
        sb.append("] noLocal=");
        sb.append(this.noLocal);
        return sb.toString();
    }
}

