/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.data.impl.journal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import net.timewalker.ffmq4.storage.data.DataStoreException;
import net.timewalker.ffmq4.storage.data.impl.journal.AbstractJournalOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.AbstractMetaDataWriteOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.CommitOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.DataBlockWriteOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.DirtyBlockTable;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalException;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalFile;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalQueue;
import net.timewalker.ffmq4.storage.data.impl.journal.MetaDataBlockWriteOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.MetaDataWriteOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.StoreExtendOperation;
import net.timewalker.ffmq4.utils.async.AsyncTask;
import net.timewalker.ffmq4.utils.async.AsyncTaskManager;
import net.timewalker.ffmq4.utils.concurrent.SynchronizationBarrier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BlockBasedDataStoreJournal {
    private static final Log log = LogFactory.getLog(BlockBasedDataStoreJournal.class);
    private static final int METADATA_FORWARD_SCAN_HORIZON = 10;
    private String baseName;
    private File dataFolder;
    private AsyncTaskManager asyncTaskManager;
    private RandomAccessFile allocationTableRandomAccessFile;
    private RandomAccessFile dataRandomAccessFile;
    private DirtyBlockTable dirtyBlockTable;
    private long maxJournalSize;
    private int maxWriteBatchSize;
    private int maxUnflushedJournalSize;
    private int maxUncommittedStoreSize;
    private int journalOutputBuffer;
    private int storageSyncMethod;
    private boolean preAllocateFiles;
    private LinkedList<JournalFile> journalFiles = new LinkedList();
    private JournalFile currentJournalFile;
    private int nextJournalFileIndex = 1;
    private long currentTransactionId = 1L;
    private LinkedList<File> recycledJournalFiles = new LinkedList();
    private JournalQueue journalWriteQueue = new JournalQueue();
    private JournalQueue journalProcessingQueue = new JournalQueue();
    private JournalQueue uncommittedJournalQueue = new JournalQueue();
    private List<SynchronizationBarrier> pendingBarriers = new ArrayList<SynchronizationBarrier>();
    private int unflushedJournalSize;
    private int writtenJournalOperations;
    private boolean flushingJournal;
    private JournalQueue storeWriteQueue = new JournalQueue();
    private JournalQueue storeProcessingQueue = new JournalQueue();
    private long lastStoreTransactionId;
    private int uncommittedStoreSize;
    private boolean flushingStore;
    private FlushJournalAsyncTask flushJournalAsyncTask = new FlushJournalAsyncTask();
    private FlushStoreAsyncTask flushStoreAsyncTask = new FlushStoreAsyncTask();
    private boolean traceEnabled;
    private boolean failing;
    private boolean closing;
    private volatile int totalPendingOperations;
    private boolean keepJournalFiles = System.getProperty("ffmq.dataStore.keepJournalFiles", "false").equals("true");

    public BlockBasedDataStoreJournal(String baseName, File dataFolder, long maxJournalSize, int maxWriteBatchSize, int maxUnflushedJournalSize, int maxUncommittedStoreSize, int journalOutputBuffer, int storageSyncMethod, boolean preAllocateFiles, RandomAccessFile allocationTableRandomAccessFile, RandomAccessFile dataRandomAccessFile, DirtyBlockTable dirtyBlockTable, AsyncTaskManager asyncTaskManager) {
        this.baseName = baseName;
        this.dataFolder = dataFolder;
        this.maxJournalSize = maxJournalSize;
        this.maxWriteBatchSize = maxWriteBatchSize;
        this.maxUnflushedJournalSize = maxUnflushedJournalSize;
        this.maxUncommittedStoreSize = maxUncommittedStoreSize;
        this.journalOutputBuffer = journalOutputBuffer;
        this.storageSyncMethod = storageSyncMethod;
        this.preAllocateFiles = preAllocateFiles;
        this.allocationTableRandomAccessFile = allocationTableRandomAccessFile;
        this.dataRandomAccessFile = dataRandomAccessFile;
        this.asyncTaskManager = asyncTaskManager;
        this.dirtyBlockTable = dirtyBlockTable;
        this.traceEnabled = log.isTraceEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JournalFile createNewJournalFile() throws JournalException {
        JournalFile journalFile;
        File recycledFile = null;
        LinkedList<File> linkedList = this.recycledJournalFiles;
        synchronized (linkedList) {
            if (this.recycledJournalFiles.size() > 0) {
                recycledFile = this.recycledJournalFiles.removeFirst();
            }
        }
        if (recycledFile == null) {
            journalFile = new JournalFile(this.nextJournalFileIndex++, this.baseName, this.dataFolder, this.maxJournalSize, this.journalOutputBuffer, this.storageSyncMethod, this.preAllocateFiles);
            log.debug((Object)("[" + this.baseName + "] Created a new journal file : " + journalFile));
        } else {
            journalFile = new JournalFile(this.nextJournalFileIndex++, this.baseName, this.dataFolder, recycledFile, this.journalOutputBuffer, this.storageSyncMethod);
            log.debug((Object)("[" + this.baseName + "] Created a recycled journal file : " + journalFile));
        }
        LinkedList<JournalFile> linkedList2 = this.journalFiles;
        synchronized (linkedList2) {
            this.journalFiles.addLast(journalFile);
        }
        return journalFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDataBlock(int blockIndex, long blockOffset, byte[] blockData) throws JournalException {
        if (this.failing) {
            throw new JournalException("Store journal is failing");
        }
        JournalQueue journalQueue = this.journalWriteQueue;
        synchronized (journalQueue) {
            if (this.traceEnabled) {
                log.trace((Object)("[" + this.baseName + "] #" + this.currentTransactionId + " Queueing data block write : [" + blockIndex + "] offset=" + blockOffset + " size=" + blockData.length + " / queueSize=" + (this.journalWriteQueue.size() + 1)));
            }
            DataBlockWriteOperation op = new DataBlockWriteOperation(this.currentTransactionId, blockIndex, blockOffset, blockData);
            this.journalWriteQueue.addLast(op);
            this.unflushedJournalSize += op.size();
            ++this.totalPendingOperations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMetaDataBlock(long metaDataOffset, byte[] metaData) throws JournalException {
        if (this.failing) {
            throw new JournalException("Store journal is failing");
        }
        JournalQueue journalQueue = this.journalWriteQueue;
        synchronized (journalQueue) {
            if (this.traceEnabled) {
                log.trace((Object)("[" + this.baseName + "] #" + this.currentTransactionId + " Queueing metadata block write : offset=" + metaDataOffset + " size=" + metaData.length + " / queueSize=" + (this.journalWriteQueue.size() + 1)));
            }
            MetaDataBlockWriteOperation op = new MetaDataBlockWriteOperation(this.currentTransactionId, metaDataOffset, metaData);
            this.journalWriteQueue.addLast(op);
            this.unflushedJournalSize += op.size();
            ++this.totalPendingOperations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMetaData(long metaDataOffset, int metaData) throws JournalException {
        if (this.failing) {
            throw new JournalException("Store journal is failing");
        }
        JournalQueue journalQueue = this.journalWriteQueue;
        synchronized (journalQueue) {
            if (this.traceEnabled) {
                log.trace((Object)("[" + this.baseName + "] #" + this.currentTransactionId + " Queueing metadata write : offset=" + metaDataOffset + " metaData=" + metaData + " / queueSize=" + (this.journalWriteQueue.size() + 1)));
            }
            MetaDataWriteOperation op = new MetaDataWriteOperation(this.currentTransactionId, metaDataOffset, metaData);
            this.unflushedJournalSize += op.size();
            this.journalWriteQueue.addLast(op);
            ++this.totalPendingOperations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extendStore(int blockSize, int oldBlockCount, int newBlockCount) throws JournalException {
        if (this.failing) {
            throw new JournalException("Store journal is failing");
        }
        JournalQueue journalQueue = this.journalWriteQueue;
        synchronized (journalQueue) {
            if (this.traceEnabled) {
                log.trace((Object)("[" + this.baseName + "] #" + this.currentTransactionId + " Queueing store extend : blockSize=" + blockSize + " blockCount=" + oldBlockCount + " -> " + newBlockCount + " / queueSize=" + (this.journalWriteQueue.size() + 1)));
            }
            StoreExtendOperation op = new StoreExtendOperation(this.currentTransactionId, blockSize, oldBlockCount, newBlockCount);
            this.unflushedJournalSize += op.size();
            this.journalWriteQueue.addLast(op);
            ++this.totalPendingOperations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws JournalException {
        if (this.failing) {
            throw new JournalException("Store journal is failing");
        }
        boolean newFlushRequired = false;
        JournalQueue journalQueue = this.journalWriteQueue;
        synchronized (journalQueue) {
            if (this.unflushedJournalSize > this.maxUnflushedJournalSize) {
                boolean bl = newFlushRequired = !this.flushingJournal;
                if (newFlushRequired) {
                    this.flushingJournal = true;
                }
                this.unflushedJournalSize = 0;
            }
        }
        if (newFlushRequired) {
            try {
                this.asyncTaskManager.execute(this.flushJournalAsyncTask);
            }
            catch (JMSException e) {
                throw new JournalException("Cannot flush journal asynchronously : " + (Object)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(SynchronizationBarrier barrier) throws JournalException {
        boolean newFlushRequired;
        if (this.failing) {
            throw new JournalException("Store journal is failing");
        }
        if (barrier != null) {
            barrier.addParty();
        }
        JournalQueue journalQueue = this.journalWriteQueue;
        synchronized (journalQueue) {
            this.writeCommit(barrier);
            boolean bl = newFlushRequired = !this.flushingJournal;
            if (newFlushRequired) {
                this.flushingJournal = true;
            }
            this.unflushedJournalSize = 0;
        }
        if (newFlushRequired) {
            try {
                this.asyncTaskManager.execute(this.flushJournalAsyncTask);
            }
            catch (JMSException e) {
                throw new JournalException("Cannot flush journal asynchronously : " + (Object)((Object)e));
            }
        }
    }

    private void writeCommit(SynchronizationBarrier barrier) {
        if (this.traceEnabled) {
            log.trace((Object)("[" + this.baseName + "] #" + this.currentTransactionId + " Queueing transaction commit -------------------"));
        }
        this.journalWriteQueue.addLast(new CommitOperation(this.currentTransactionId, barrier));
        ++this.totalPendingOperations;
        ++this.currentTransactionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void flushJournal() {
        try {
            while (!this.failing) {
                JournalQueue journalQueue = this.journalWriteQueue;
                // MONITORENTER : journalQueue
                if (this.journalWriteQueue.size() == 0) {
                    this.flushingJournal = false;
                    // MONITOREXIT : journalQueue
                    return;
                }
                for (int count = 0; this.journalWriteQueue.size() > 0 && count < this.maxWriteBatchSize; ++count) {
                    this.journalProcessingQueue.addLast(this.journalWriteQueue.removeFirst());
                }
                // MONITOREXIT : journalQueue
                if (this.traceEnabled) {
                    log.trace((Object)("[" + this.baseName + "] [Journal] Flushing " + this.journalProcessingQueue.size() + " operations"));
                }
                if (this.currentJournalFile == null) {
                    this.currentJournalFile = this.createNewJournalFile();
                }
                boolean commitRequired = false;
                int commitCount = 0;
                int prunedOperations = 0;
                while (this.journalProcessingQueue.size() > 0) {
                    AbstractJournalOperation op = this.journalProcessingQueue.getFirst();
                    if (op instanceof AbstractMetaDataWriteOperation && this.isMetaDataSuperseeded((AbstractMetaDataWriteOperation)op)) {
                        this.journalProcessingQueue.removeFirst();
                        ++prunedOperations;
                        continue;
                    }
                    this.journalProcessingQueue.removeFirst();
                    if (op instanceof CommitOperation) {
                        CommitOperation commitOp = (CommitOperation)op;
                        commitOp.setOperationsCount(this.writtenJournalOperations);
                        this.writtenJournalOperations = 0;
                        op.writeTo(this.currentJournalFile);
                        ++commitCount;
                        if (commitOp.getBarrier() != null) {
                            this.pendingBarriers.add(commitOp.getBarrier());
                        }
                        if (this.rotateJournal()) {
                            this.onJournalCommit();
                            commitRequired = false;
                            continue;
                        }
                        if (commitOp.getOperationsCount() <= 0) continue;
                        commitRequired = true;
                        continue;
                    }
                    op.writeTo(this.currentJournalFile);
                    ++this.writtenJournalOperations;
                    this.uncommittedJournalQueue.addLast(op);
                }
                if (commitRequired) {
                    if (this.traceEnabled) {
                        log.trace((Object)("[" + this.baseName + "] [Journal] Syncing (" + this.pendingBarriers.size() + " barrier(s))"));
                    }
                    this.syncJournal();
                    this.onJournalCommit();
                }
                if (this.pendingBarriers.size() > 0) {
                    for (int i = 0; i < this.pendingBarriers.size(); ++i) {
                        SynchronizationBarrier barrier = this.pendingBarriers.get(i);
                        barrier.reach();
                    }
                    this.pendingBarriers.clear();
                }
                if (commitCount + prunedOperations <= 0) continue;
                JournalQueue journalQueue2 = this.journalWriteQueue;
                // MONITORENTER : journalQueue2
                this.totalPendingOperations -= commitCount + prunedOperations;
                if (this.closing && this.totalPendingOperations == 0) {
                    this.journalWriteQueue.notifyAll();
                }
                // MONITOREXIT : journalQueue2
            }
            return;
        }
        catch (DataStoreException e) {
            this.notifyFailure((Exception)((Object)e));
        }
    }

    private boolean isMetaDataSuperseeded(AbstractMetaDataWriteOperation baseOp) {
        int count = 0;
        for (AbstractJournalOperation current = baseOp.next(); current != null && count < 10; current = current.next()) {
            if (current instanceof CommitOperation) {
                return false;
            }
            if (!(current instanceof AbstractMetaDataWriteOperation)) continue;
            AbstractMetaDataWriteOperation writeOp = (AbstractMetaDataWriteOperation)current;
            if (writeOp.getOffset() == baseOp.getOffset()) {
                return true;
            }
            ++count;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onJournalCommit() throws JournalException {
        boolean newFlushRequired;
        JournalQueue journalQueue = this.storeWriteQueue;
        synchronized (journalQueue) {
            this.uncommittedJournalQueue.migrateTo(this.storeWriteQueue);
            boolean bl = newFlushRequired = this.storeWriteQueue.size() > 0 && !this.flushingStore;
            if (newFlushRequired) {
                this.flushingStore = true;
            }
        }
        if (newFlushRequired) {
            try {
                this.asyncTaskManager.execute(this.flushStoreAsyncTask);
            }
            catch (JMSException e) {
                throw new JournalException("Cannot flush store asynchronously : " + (Object)((Object)e));
            }
        }
    }

    private void notifyFailure(Exception e) {
        this.failing = true;
        log.fatal((Object)("[" + this.baseName + "] Data store failure"), (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void flushStore() {
        try {
            while (!this.failing) {
                JournalQueue journalQueue = this.storeWriteQueue;
                synchronized (journalQueue) {
                    if (this.storeWriteQueue.size() == 0) {
                        this.flushingStore = false;
                        return;
                    }
                    for (int count = 0; this.storeWriteQueue.size() > 0 && count < this.maxWriteBatchSize; ++count) {
                        this.storeProcessingQueue.addLast(this.storeWriteQueue.removeFirst());
                    }
                }
                int flushCount = this.storeProcessingQueue.size();
                if (this.traceEnabled) {
                    log.trace((Object)("[" + this.baseName + "] [Store] Flushing " + flushCount + " operations"));
                }
                while (this.storeProcessingQueue.size() > 0) {
                    AbstractJournalOperation op = this.storeProcessingQueue.removeFirst();
                    if (op instanceof DataBlockWriteOperation) {
                        DataBlockWriteOperation blockOp = (DataBlockWriteOperation)op;
                        this.uncommittedStoreSize += blockOp.writeTo(this.dataRandomAccessFile);
                        this.dirtyBlockTable.blockFlushed(blockOp.getBlockIndex());
                    } else if (op instanceof MetaDataWriteOperation) {
                        this.uncommittedStoreSize += ((MetaDataWriteOperation)op).writeTo(this.allocationTableRandomAccessFile);
                    } else if (op instanceof MetaDataBlockWriteOperation) {
                        this.uncommittedStoreSize += ((MetaDataBlockWriteOperation)op).writeTo(this.allocationTableRandomAccessFile);
                    } else {
                        if (!(op instanceof StoreExtendOperation)) throw new IllegalArgumentException("Unexpected journal operation : " + op);
                        StoreExtendOperation extendOp = (StoreExtendOperation)op;
                        extendOp.extend(this.allocationTableRandomAccessFile, this.dataRandomAccessFile);
                        this.uncommittedStoreSize = (int)((long)this.uncommittedStoreSize + (long)(extendOp.getNewBlockCount() - extendOp.getOldBlockCount()) * 13L);
                    }
                    this.lastStoreTransactionId = op.getTransactionId();
                }
                if (this.uncommittedStoreSize > this.maxUncommittedStoreSize) {
                    this.uncommittedStoreSize = 0;
                    if (this.traceEnabled) {
                        log.trace((Object)("[" + this.baseName + "] [Store] Committing store (lastTrsId=" + this.lastStoreTransactionId + ")"));
                    }
                    this.syncStore();
                    this.recycleUnusedJournalFiles();
                }
                JournalQueue journalQueue2 = this.journalWriteQueue;
                synchronized (journalQueue2) {
                    this.totalPendingOperations -= flushCount;
                    if (this.closing && this.totalPendingOperations == 0) {
                        this.journalWriteQueue.notifyAll();
                    }
                }
            }
            return;
        }
        catch (DataStoreException e) {
            this.notifyFailure((Exception)((Object)e));
        }
    }

    private void syncJournal() throws JournalException {
        if (this.currentJournalFile != null) {
            this.currentJournalFile.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rotateJournal() throws JournalException {
        LinkedList<JournalFile> linkedList = this.journalFiles;
        synchronized (linkedList) {
            if (this.currentJournalFile.size() > this.maxJournalSize) {
                log.debug((Object)("[" + this.baseName + "] Rotating journal : " + this.currentJournalFile));
                this.currentJournalFile.complete();
                this.currentJournalFile = this.createNewJournalFile();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncStore() throws JournalException {
        this.syncStoreFile(this.allocationTableRandomAccessFile);
        RandomAccessFile randomAccessFile = this.dataRandomAccessFile;
        synchronized (randomAccessFile) {
            this.syncStoreFile(this.dataRandomAccessFile);
        }
    }

    private void syncStoreFile(RandomAccessFile storeFile) throws JournalException {
        try {
            switch (this.storageSyncMethod) {
                case 1: {
                    storeFile.getFD().sync();
                    break;
                }
                case 2: {
                    storeFile.getChannel().force(false);
                    break;
                }
                default: {
                    throw new JournalException("Unsupported sync method : " + this.storageSyncMethod);
                }
            }
        }
        catch (IOException e) {
            log.error((Object)("[" + this.baseName + "] Could not sync store file"), (Throwable)e);
            throw new JournalException("Could not sync store file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleUnusedJournalFiles() throws JournalException {
        LinkedList<JournalFile> unusedJournalFiles = null;
        LinkedList<JournalFile> linkedList = this.journalFiles;
        synchronized (linkedList) {
            JournalFile journalFile;
            while (this.journalFiles.size() > 0 && (journalFile = this.journalFiles.getFirst()).isComplete() && journalFile.getLastTransactionId() < this.lastStoreTransactionId) {
                if (unusedJournalFiles == null) {
                    unusedJournalFiles = new LinkedList<JournalFile>();
                }
                unusedJournalFiles.addLast(journalFile);
                this.journalFiles.removeFirst();
            }
        }
        if (unusedJournalFiles != null) {
            while (!unusedJournalFiles.isEmpty()) {
                JournalFile journalFile = (JournalFile)unusedJournalFiles.removeFirst();
                if (this.keepJournalFiles) {
                    journalFile.close();
                    continue;
                }
                log.debug((Object)("[" + this.baseName + "] Recycling unused journal file : " + journalFile));
                File recycledFile = journalFile.closeAndRecycle();
                LinkedList<File> linkedList2 = this.recycledJournalFiles;
                synchronized (linkedList2) {
                    this.recycledJournalFiles.addLast(recycledFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JournalException {
        if (this.failing) {
            return;
        }
        log.debug((Object)("[" + this.baseName + "] Waiting for async operations to complete ..."));
        this.closing = true;
        boolean complete = false;
        while (true) {
            JournalQueue journalQueue = this.journalWriteQueue;
            synchronized (journalQueue) {
                if (this.totalPendingOperations == 0) {
                    complete = true;
                    break;
                }
                try {
                    this.journalWriteQueue.wait();
                }
                catch (InterruptedException e) {
                    log.error((Object)("[" + this.baseName + "] Wait for async operations completion was interrupted"), (Throwable)e);
                    break;
                }
            }
        }
        if (!complete) {
            throw new JournalException("Timeout or interrupt waiting for async tasks completion.");
        }
        this.syncJournal();
        this.syncStore();
        this.destroyJournalFiles();
    }

    private void destroyJournalFiles() throws JournalException {
        log.debug((Object)("[" + this.baseName + "] Destroying recycled journal files ..."));
        while (this.recycledJournalFiles.size() > 0) {
            File recycledFile = this.recycledJournalFiles.removeFirst();
            recycledFile.delete();
        }
        log.debug((Object)("[" + this.baseName + "] Destroying remaining journal files ..."));
        while (this.journalFiles.size() > 0) {
            JournalFile journalFile = this.journalFiles.removeFirst();
            if (this.keepJournalFiles) {
                journalFile.close();
                continue;
            }
            journalFile.closeAndDelete();
        }
    }

    private class FlushStoreAsyncTask
    implements AsyncTask {
        @Override
        public void execute() {
            BlockBasedDataStoreJournal.this.flushStore();
        }

        @Override
        public boolean isMergeable() {
            return false;
        }
    }

    private class FlushJournalAsyncTask
    implements AsyncTask {
        @Override
        public void execute() {
            BlockBasedDataStoreJournal.this.flushJournal();
        }

        @Override
        public boolean isMergeable() {
            return false;
        }
    }
}

