/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.local.destination;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.JMSException;
import javax.jms.Topic;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.message.MessageSelector;
import net.timewalker.ffmq4.common.message.selector.SelectorIndexKey;
import net.timewalker.ffmq4.local.MessageLockSet;
import net.timewalker.ffmq4.local.destination.AbstractLocalDestination;
import net.timewalker.ffmq4.local.destination.LocalQueue;
import net.timewalker.ffmq4.local.destination.LocalTopicMBean;
import net.timewalker.ffmq4.local.destination.subscription.LocalTopicSubscription;
import net.timewalker.ffmq4.local.session.LocalMessageConsumer;
import net.timewalker.ffmq4.local.session.LocalSession;
import net.timewalker.ffmq4.management.destination.definition.TopicDefinition;
import net.timewalker.ffmq4.storage.data.DataStoreFullException;
import net.timewalker.ffmq4.utils.Committable;
import net.timewalker.ffmq4.utils.ErrorTools;
import net.timewalker.ffmq4.utils.concurrent.SynchronizationBarrier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LocalTopic
extends AbstractLocalDestination
implements Topic,
LocalTopicMBean {
    private static final Log log = LogFactory.getLog(LocalTopic.class);
    private TopicDefinition topicDef;
    private Map<String, LocalTopicSubscription> subscriptionMap = new HashMap<String, LocalTopicSubscription>();
    private List<LocalTopicSubscription> flatSubscriptions = new ArrayList<LocalTopicSubscription>();
    private Map<String, Map<Object, List<LocalTopicSubscription>>> indexedSubscriptionMap = new HashMap<String, Map<Object, List<LocalTopicSubscription>>>();
    private ReentrantReadWriteLock subscriptionsLock = new ReentrantReadWriteLock();
    private AtomicLong sentToTopicCount = new AtomicLong();
    private AtomicLong dispatchedFromTopicCount = new AtomicLong();
    private Set<Committable> committables = new HashSet<Committable>();
    private boolean pendingChanges;

    public LocalTopic(TopicDefinition topicDef) {
        super(topicDef);
        this.topicDef = topicDef;
    }

    public TopicDefinition getDefinition() {
        return this.topicDef;
    }

    public String getTopicName() {
        return this.getName();
    }

    @Override
    public void registerConsumer(LocalMessageConsumer consumer) {
        super.registerConsumer(consumer);
        this.subscriptionsLock.writeLock().lock();
        try {
            LocalTopicSubscription subscription = this.subscriptionMap.remove(consumer.getSubscriberId());
            if (subscription == null) {
                this.storeNewSubscription(consumer);
            } else {
                this.removeSubscription(subscription);
                this.storeNewSubscription(consumer);
            }
        }
        finally {
            this.subscriptionsLock.writeLock().unlock();
        }
    }

    private void storeNewSubscription(LocalMessageConsumer consumer) {
        List<SelectorIndexKey> indexableKeys;
        SelectorIndexKey key;
        LocalTopicSubscription subscription = new LocalTopicSubscription(consumer);
        String[] partitionKeys = this.topicDef.getPartitionsKeysToIndex();
        if (partitionKeys != null && subscription.getMessageSelector() != null && (key = this.findBestMatch(partitionKeys, indexableKeys = subscription.getMessageSelector().getIndexableKeys())) != null) {
            subscription.setIndexKey(key);
            this.addToIndexMap(subscription);
        }
        if (!subscription.isIndexed()) {
            this.flatSubscriptions.add(subscription);
        }
        this.subscriptionMap.put(consumer.getSubscriberId(), subscription);
    }

    private void addToIndexMap(LocalTopicSubscription subscription) {
        Object[] values;
        SelectorIndexKey key = subscription.getIndexKey();
        Map<Object, List<LocalTopicSubscription>> subscriptionsByValueMap = this.indexedSubscriptionMap.get(key.getHeaderName());
        if (subscriptionsByValueMap == null) {
            subscriptionsByValueMap = new HashMap<Object, List<LocalTopicSubscription>>();
            this.indexedSubscriptionMap.put(key.getHeaderName(), subscriptionsByValueMap);
        }
        for (Object value : values = key.getValues()) {
            List<LocalTopicSubscription> subscriptions = subscriptionsByValueMap.get(value);
            if (subscriptions == null) {
                subscriptions = new ArrayList<LocalTopicSubscription>(4);
                subscriptionsByValueMap.put(value, subscriptions);
            }
            subscriptions.add(subscription);
        }
    }

    private boolean removeFromIndexMap(LocalTopicSubscription subscription) {
        SelectorIndexKey key = subscription.getIndexKey();
        if (key == null) {
            return true;
        }
        Map<Object, List<LocalTopicSubscription>> subscriptionsByValueMap = this.indexedSubscriptionMap.get(key.getHeaderName());
        if (subscriptionsByValueMap == null) {
            return false;
        }
        Object[] values = key.getValues();
        int found = 0;
        for (Object value : values) {
            List<LocalTopicSubscription> subscriptions = subscriptionsByValueMap.get(value);
            if (subscriptions == null || !subscriptions.remove(subscription)) continue;
            ++found;
            if (!subscriptions.isEmpty()) continue;
            subscriptionsByValueMap.remove(value);
            if (!subscriptionsByValueMap.isEmpty()) continue;
            this.indexedSubscriptionMap.remove(key.getHeaderName());
        }
        return found == values.length;
    }

    private SelectorIndexKey findBestMatch(String[] partitionKeys, List<SelectorIndexKey> indexableKeys) {
        for (String partitionKey : partitionKeys) {
            for (SelectorIndexKey indexableKey : indexableKeys) {
                if (!indexableKey.getHeaderName().equals(partitionKey)) continue;
                return indexableKey;
            }
        }
        return null;
    }

    @Override
    public void unregisterConsumer(LocalMessageConsumer consumer) {
        super.unregisterConsumer(consumer);
        if (!consumer.isDurable()) {
            log.debug((Object)("Removing non-durable subscription " + consumer.getSubscriberId()));
            this.subscriptionsLock.writeLock().lock();
            try {
                LocalTopicSubscription subscription = this.subscriptionMap.remove(consumer.getSubscriberId());
                if (subscription != null) {
                    this.removeSubscription(subscription);
                }
            }
            finally {
                this.subscriptionsLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String clientID, String subscriptionName) throws JMSException {
        String subscriberID = clientID + "-" + subscriptionName;
        this.subscriptionsLock.writeLock().lock();
        try {
            LocalTopicSubscription subscription = this.subscriptionMap.get(subscriberID);
            if (subscription == null) {
                return;
            }
            if (this.isConsumerRegistered(subscriberID)) {
                throw new FFMQException("Subscription " + subscriptionName + " is still in use", "SUBSCRIPTION_STILL_IN_USE");
            }
            this.subscriptionMap.remove(subscriberID);
            this.removeSubscription(subscription);
        }
        finally {
            this.subscriptionsLock.writeLock().unlock();
        }
    }

    private void removeSubscription(LocalTopicSubscription subscription) {
        if (subscription.isIndexed()) {
            if (!this.removeFromIndexMap(subscription)) {
                throw new IllegalStateException("Cannot find subscription in index map : " + subscription);
            }
        } else if (!this.flatSubscriptions.remove(subscription)) {
            throw new IllegalStateException("Cannot find subscription in non-indexed list : " + subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putLocked(AbstractMessage srcMessage, LocalSession session, MessageLockSet locks) throws JMSException {
        this.checkNotClosed();
        this.checkTransactionLock();
        if (!this.topicDef.supportDeliveryMode(srcMessage.getJMSDeliveryMode())) {
            throw new FFMQException("Topic does not support this delivery mode : " + (srcMessage.getJMSDeliveryMode() == 1 ? "DeliveryMode.NON_PERSISTENT" : "DeliveryMode.PERSISTENT"), "INVALID_DELIVERY_MODE");
        }
        this.sentToTopicCount.incrementAndGet();
        boolean commitRequired = false;
        this.subscriptionsLock.readLock().lock();
        try {
            if (!this.indexedSubscriptionMap.isEmpty()) {
                srcMessage.ensureDeserializationLevel(2);
                for (Map.Entry<String, Map<Object, List<LocalTopicSubscription>>> entry : this.indexedSubscriptionMap.entrySet()) {
                    String headerName = entry.getKey();
                    Object value = headerName.equals("JMSCorrelationID") ? srcMessage.getJMSCorrelationID() : srcMessage.getObjectProperty(headerName);
                    if (value == null) continue;
                    value = this.normalizeLiteralValue(value);
                    List<LocalTopicSubscription> subscriptions = entry.getValue().get(value);
                    if (subscriptions == null || !this.pushToSubscriptions(srcMessage, session, locks, subscriptions)) continue;
                    commitRequired = true;
                }
            }
            if (!this.flatSubscriptions.isEmpty() && this.pushToSubscriptions(srcMessage, session, locks, this.flatSubscriptions)) {
                commitRequired = true;
            }
        }
        finally {
            this.subscriptionsLock.readLock().unlock();
        }
        return commitRequired;
    }

    private Object normalizeLiteralValue(Object value) {
        if (value instanceof Number) {
            if (value instanceof Long) {
                return value;
            }
            if (value instanceof Double) {
                return value;
            }
            if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
                return ((Number)value).longValue();
            }
            if (value instanceof Float) {
                return ((Number)value).doubleValue();
            }
        }
        return value;
    }

    private boolean pushToSubscriptions(AbstractMessage srcMessage, LocalSession session, MessageLockSet locks, List<LocalTopicSubscription> subscriptions) throws JMSException {
        String connectionID = session.getConnection().getId();
        boolean commitRequired = false;
        for (int i = 0; i < subscriptions.size(); ++i) {
            LocalTopicSubscription subscription = subscriptions.get(i);
            if (subscription.getNoLocal() && subscription.getConnectionID().equals(connectionID)) continue;
            try {
                LocalQueue subscriberQueue;
                MessageSelector selector = subscription.getMessageSelector();
                if (selector != null) {
                    srcMessage.ensureDeserializationLevel(2);
                    if (!selector.matches(srcMessage)) continue;
                }
                if ((subscriberQueue = subscription.getLocalQueue()).requiresTransactionalUpdate() && subscription.isDurable()) {
                    if (this.committables.add(subscriberQueue)) {
                        subscriberQueue.openTransaction();
                    }
                    if (!subscriberQueue.putLocked(srcMessage, session, locks) && srcMessage.getJMSDeliveryMode() == 2) {
                        throw new IllegalStateException("Should require a commit");
                    }
                    this.pendingChanges = true;
                    commitRequired = true;
                } else if (subscriberQueue.putLocked(srcMessage, session, locks)) {
                    throw new IllegalStateException("Should not require a commit");
                }
                this.dispatchedFromTopicCount.incrementAndGet();
                continue;
            }
            catch (DataStoreFullException e) {
                this.processPutError(subscription.getSubscriberId(), e, this.getDefinition().getSubscriberOverflowPolicy());
                continue;
            }
            catch (JMSException e) {
                this.processPutError(subscription.getSubscriberId(), e, this.getDefinition().getSubscriberFailurePolicy());
            }
        }
        return commitRequired;
    }

    private void processPutError(String subscriberId, JMSException e, int policy) throws JMSException {
        if ((policy & 1) > 0) {
            ErrorTools.log("subscriber=" + subscriberId, e, log);
        }
        if ((policy & 2) > 0) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        int size = 0;
        this.subscriptionsLock.readLock().lock();
        try {
            for (LocalTopicSubscription subscription : this.subscriptionMap.values()) {
                size += subscription.getLocalQueue().getSize();
            }
        }
        finally {
            this.subscriptionsLock.readLock().unlock();
        }
        return size;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.sentToTopicCount.set(0L);
        this.dispatchedFromTopicCount.set(0L);
    }

    @Override
    public long getSentToTopicCount() {
        return this.sentToTopicCount.get();
    }

    @Override
    public long getDispatchedFromTopicCount() {
        return this.dispatchedFromTopicCount.get();
    }

    @Override
    public int getSubscriptionsCount() {
        return this.subscriptionMap.size();
    }

    @Override
    public int getIndexedSubscriptionsCount() {
        return this.indexedSubscriptionMap.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Topic{");
        sb.append(this.getName());
        sb.append("}[size=");
        sb.append(this.getSize());
        sb.append(",consumers=");
        sb.append(this.localConsumers.size());
        sb.append(",in=");
        sb.append(this.sentToTopicCount);
        sb.append(",out=");
        sb.append(this.dispatchedFromTopicCount);
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConsumersSummary() {
        StringBuilder sb = new StringBuilder();
        this.subscriptionsLock.readLock().lock();
        try {
            int pos = 0;
            for (LocalTopicSubscription subscription : this.subscriptionMap.values()) {
                if (pos++ > 0) {
                    sb.append("\n");
                }
                sb.append(subscription);
            }
        }
        finally {
            this.subscriptionsLock.readLock().unlock();
        }
        return sb.toString();
    }

    @Override
    protected boolean requiresTransactionalUpdate() {
        return this.topicDef.hasPersistentStore();
    }

    @Override
    protected boolean hasPendingChanges() {
        return this.pendingChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws JMSException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
    }

    @Override
    public void commitChanges(SynchronizationBarrier barrier) throws JMSException {
        this.checkNotClosed();
        this.checkTransactionLock();
        if (!this.committables.isEmpty()) {
            long start = System.currentTimeMillis();
            for (Committable committable : this.committables) {
                committable.commitChanges(barrier);
            }
            long end = System.currentTimeMillis();
            this.notifyCommitTime(end - start);
            this.pendingChanges = false;
        }
    }

    @Override
    public void closeTransaction() {
        if (!this.committables.isEmpty()) {
            for (Committable committable : this.committables) {
                committable.closeTransaction();
            }
            this.committables.clear();
        }
        super.closeTransaction();
    }
}

