/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import net.timewalker.ffmq4.common.destination.QueueRef;
import net.timewalker.ffmq4.common.destination.TopicRef;
import net.timewalker.ffmq4.jndi.FFMQConnectionFactory;
import net.timewalker.ffmq4.jndi.FFMQQueueConnectionFactory;
import net.timewalker.ffmq4.jndi.FFMQTopicConnectionFactory;

public final class JNDIObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context context, Hashtable<?, ?> environment) throws Exception {
        if (!(obj instanceof Reference)) {
            throw new IllegalStateException("Object is not a reference : " + obj);
        }
        Reference reference = (Reference)obj;
        String objClassName = reference.getClassName();
        if (objClassName.equals(QueueRef.class.getName())) {
            String queueName = this.getRequiredAttribute(reference, "queueName");
            return new QueueRef(queueName);
        }
        if (objClassName.equals(TopicRef.class.getName())) {
            String topicName = this.getRequiredAttribute(reference, "topicName");
            return new TopicRef(topicName);
        }
        if (objClassName.equals(FFMQConnectionFactory.class.getName())) {
            return new FFMQConnectionFactory(this.recreateConnectionFactoryEnv(reference));
        }
        if (objClassName.equals(FFMQQueueConnectionFactory.class.getName())) {
            return new FFMQQueueConnectionFactory(this.recreateConnectionFactoryEnv(reference));
        }
        if (objClassName.equals(FFMQTopicConnectionFactory.class.getName())) {
            return new FFMQTopicConnectionFactory(this.recreateConnectionFactoryEnv(reference));
        }
        return null;
    }

    private Hashtable<String, Object> recreateConnectionFactoryEnv(Reference reference) {
        String userName;
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        String providerURL = this.getRequiredAttribute(reference, "providerURL");
        env.put("java.naming.provider.url", providerURL);
        String clientID = this.getAttribute(reference, "clientID");
        if (clientID != null) {
            env.put("ffmq.naming.clientID", clientID);
        }
        if ((userName = this.getAttribute(reference, "userName")) != null) {
            env.put("java.naming.security.principal", userName);
            String password = this.getAttribute(reference, "password");
            if (password != null) {
                env.put("java.naming.security.credentials", password);
            }
        }
        return env;
    }

    private String getRequiredAttribute(Reference ref, String attributeName) {
        StringRefAddr attrRef = (StringRefAddr)ref.get(attributeName);
        if (attrRef == null) {
            throw new IllegalArgumentException("Missing resource attribute : " + attributeName);
        }
        return (String)attrRef.getContent();
    }

    private String getAttribute(Reference ref, String attributeName) {
        StringRefAddr attrRef = (StringRefAddr)ref.get(attributeName);
        if (attrRef == null) {
            return null;
        }
        return (String)attrRef.getContent();
    }
}

