/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.jndi;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import net.timewalker.ffmq4.common.destination.QueueRef;
import net.timewalker.ffmq4.common.destination.TopicRef;

public final class FFMQJNDIContext
implements Context {
    private Hashtable<String, Object> env;
    protected Hashtable<String, Object> bindings = new Hashtable();
    private static final NameParser flatParser = new FlatNameParser();

    public FFMQJNDIContext(Hashtable<?, ?> environment) {
        this.env = environment != null ? (Hashtable)environment.clone() : new Hashtable();
    }

    protected FFMQJNDIContext(Hashtable<String, Object> environment, Hashtable<String, Object> bindings) {
        this.env = (Hashtable)environment.clone();
        this.bindings = bindings;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new FFMQJNDIContext(this.env, this.bindings);
        }
        String nm = name.toString();
        Object answer = this.bindings.get(nm);
        if (answer == null) {
            if (nm.startsWith("queue/") && nm.length() > 6) {
                return new QueueRef(nm.substring(nm.indexOf(47) + 1));
            }
            if (nm.startsWith("topic/") && nm.length() > 6) {
                return new TopicRef(nm.substring(nm.indexOf(47) + 1));
            }
            throw new NameNotFoundException(name + " not found");
        }
        return answer;
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        String nm = name.toString();
        if (this.bindings.get(nm) != null) {
            throw new NameAlreadyBoundException("Use rebind to override");
        }
        this.bindings.put(nm, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        String nm = name.toString();
        this.bindings.put(nm, obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        String nm = name.toString();
        this.bindings.remove(nm);
    }

    @Override
    public void rename(String oldname, String newname) throws NamingException {
        this.rename(new CompositeName(oldname), new CompositeName(newname));
    }

    @Override
    public void rename(Name oldname, Name newname) throws NamingException {
        if (oldname.isEmpty() || newname.isEmpty()) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        String oldnm = oldname.toString();
        String newnm = newname.toString();
        if (this.bindings.get(newnm) != null) {
            throw new NameAlreadyBoundException(newname.toString() + " is already bound");
        }
        Object oldBinding = this.bindings.remove(oldnm);
        if (oldBinding == null) {
            throw new NameNotFoundException(oldname.toString() + " not bound");
        }
        this.bindings.put(newnm, oldBinding);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new ListOfNames(this.bindings.keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            try {
                NamingEnumeration<NameClassPair> namingEnumeration = ((Context)target).list("");
                return namingEnumeration;
            }
            finally {
                ((Context)target).close();
            }
        }
        throw new NotContextException(name + " cannot be listed");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new ListOfBindings(this.bindings.keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            try {
                NamingEnumeration<Binding> namingEnumeration = ((Context)target).listBindings("");
                return namingEnumeration;
            }
            finally {
                ((Context)target).close();
            }
        }
        throw new NotContextException(name + " cannot be listed");
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("This context does not support subcontexts");
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("This context does not support subcontexts");
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(new CompositeName(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(new CompositeName(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            ((Context)obj).close();
        }
        return flatParser;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) {
        return this.env.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) {
        return this.env.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() {
        return (Hashtable)this.env.clone();
    }

    @Override
    public String getNameInNamespace() {
        return "";
    }

    @Override
    public void close() {
    }

    private static class FlatNameParser
    implements NameParser {
        private static final Properties syntax = new Properties();

        @Override
        public Name parse(String name) throws NamingException {
            return new CompoundName(name, syntax);
        }

        static {
            syntax.put("jndi.syntax.direction", "flat");
            syntax.put("jndi.syntax.ignorecase", "false");
        }
    }

    private class ListOfBindings
    implements NamingEnumeration<Binding> {
        protected Enumeration<String> names;

        public ListOfBindings(Enumeration<String> names) {
            this.names = names;
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasMore();
        }

        @Override
        public boolean hasMore() {
            return this.names.hasMoreElements();
        }

        @Override
        public Binding next() {
            String name = this.names.nextElement();
            return new Binding(name, FFMQJNDIContext.this.bindings.get(name));
        }

        @Override
        public Binding nextElement() {
            return this.next();
        }

        @Override
        public void close() {
        }
    }

    private class ListOfNames
    implements NamingEnumeration<NameClassPair> {
        protected Enumeration<String> names;

        public ListOfNames(Enumeration<String> names) {
            this.names = names;
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasMore();
        }

        @Override
        public boolean hasMore() {
            return this.names.hasMoreElements();
        }

        @Override
        public NameClassPair next() {
            String name = this.names.nextElement();
            String className = FFMQJNDIContext.this.bindings.get(name).getClass().getName();
            return new NameClassPair(name, className);
        }

        @Override
        public NameClassPair nextElement() {
            return this.next();
        }

        @Override
        public void close() {
        }
    }
}

