/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message.selector.expression.operator;

import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import net.timewalker.ffmq4.common.message.selector.expression.SelectorNode;
import net.timewalker.ffmq4.common.message.selector.expression.operator.AbstractNumericComparisonOperator;
import net.timewalker.ffmq4.common.message.selector.expression.utils.ArithmeticUtils;

public final class GreaterThanOrEqualsOperator
extends AbstractNumericComparisonOperator {
    public GreaterThanOrEqualsOperator(SelectorNode leftOperand, SelectorNode rightOperand) throws InvalidSelectorException {
        super(leftOperand, rightOperand);
    }

    @Override
    public Object evaluate(Message message) throws JMSException {
        Object leftValue = this.leftOperand.evaluate(message);
        Object rightValue = this.rightOperand.evaluate(message);
        if (leftValue == null || rightValue == null) {
            return null;
        }
        int leftType = this.getNodeType(leftValue);
        int rightType = this.getNodeType(rightValue);
        if (leftType != 2 || rightType != 2) {
            return Boolean.FALSE;
        }
        return ArithmeticUtils.greaterThanOrEquals((Number)leftValue, (Number)rightValue);
    }

    public String toString() {
        return this.parenthesize(this.leftOperand) + " >= " + this.parenthesize(this.rightOperand);
    }
}

