/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message;

import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.utils.RawDataBuffer;

public final class TextMessageImpl
extends AbstractMessage
implements TextMessage {
    private String body;

    public TextMessageImpl() {
    }

    public TextMessageImpl(String text) throws JMSException {
        this.setText(text);
    }

    @Override
    protected byte getType() {
        return 6;
    }

    @Override
    protected void unserializeBodyFrom(RawDataBuffer in) {
        this.body = in.readNullableUTF();
    }

    @Override
    protected final void serializeBodyTo(RawDataBuffer out) {
        out.writeNullableUTF(this.body);
    }

    public void clearBody() {
        this.assertDeserializationLevel(3);
        this.body = null;
        this.bodyIsReadOnly = false;
    }

    public String getText() throws JMSException {
        return this.body;
    }

    public void setText(String body) throws JMSException {
        if (this.bodyIsReadOnly) {
            throw new MessageNotWriteableException("Message body is read-only");
        }
        this.assertDeserializationLevel(3);
        this.body = body;
    }

    @Override
    public AbstractMessage copy() {
        TextMessageImpl clone = new TextMessageImpl();
        this.copyCommonFields(clone);
        clone.body = this.body;
        return clone;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" body=");
        sb.append(this.body);
        return sb.toString();
    }
}

