/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.message.MessageConvertTools;
import net.timewalker.ffmq4.utils.ArrayTools;
import net.timewalker.ffmq4.utils.EmptyEnumeration;
import net.timewalker.ffmq4.utils.IteratorEnumeration;
import net.timewalker.ffmq4.utils.RawDataBuffer;

public final class MapMessageImpl
extends AbstractMessage
implements MapMessage {
    private Map<String, Object> body;

    @Override
    protected byte getType() {
        return 3;
    }

    @Override
    protected void unserializeBodyFrom(RawDataBuffer in) {
        this.body = this.readMapFrom(in);
    }

    @Override
    protected void serializeBodyTo(RawDataBuffer out) {
        this.writeMapTo(this.body, out);
    }

    public boolean getBoolean(String name) throws JMSException {
        return MessageConvertTools.asBoolean(this.getObject(name));
    }

    public byte getByte(String name) throws JMSException {
        return MessageConvertTools.asByte(this.getObject(name));
    }

    public byte[] getBytes(String name) throws JMSException {
        return MessageConvertTools.asBytes(this.getObject(name));
    }

    public char getChar(String name) throws JMSException {
        return MessageConvertTools.asChar(this.getObject(name));
    }

    public double getDouble(String name) throws JMSException {
        return MessageConvertTools.asDouble(this.getObject(name));
    }

    public float getFloat(String name) throws JMSException {
        return MessageConvertTools.asFloat(this.getObject(name));
    }

    public int getInt(String name) throws JMSException {
        return MessageConvertTools.asInt(this.getObject(name));
    }

    public long getLong(String name) throws JMSException {
        return MessageConvertTools.asLong(this.getObject(name));
    }

    public Enumeration<String> getMapNames() {
        if (this.body == null) {
            return new EmptyEnumeration<String>();
        }
        return new IteratorEnumeration<String>(this.body.keySet().iterator());
    }

    public Object getObject(String name) throws JMSException {
        if (name == null || name.length() == 0) {
            throw new FFMQException("Object name cannot be null or empty", "INVALID_OBJECT_NAME");
        }
        return this.body != null ? this.body.get(name) : null;
    }

    public short getShort(String name) throws JMSException {
        return MessageConvertTools.asShort(this.getObject(name));
    }

    public String getString(String name) throws JMSException {
        return MessageConvertTools.asString(this.getObject(name));
    }

    public boolean itemExists(String name) throws JMSException {
        if (name == null || name.length() == 0) {
            throw new FFMQException("Object name cannot be null or empty", "INVALID_OBJECT_NAME");
        }
        return this.body != null ? this.body.containsKey(name) : false;
    }

    private Object put(String name, Object value) throws JMSException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Item name cannot be null");
        }
        if (this.bodyIsReadOnly) {
            throw new MessageNotWriteableException("Message body is read-only");
        }
        this.assertDeserializationLevel(3);
        if (this.body == null) {
            this.body = new HashMap<String, Object>();
        }
        return this.body.put(name, value);
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.put(name, value);
    }

    public void setByte(String name, byte value) throws JMSException {
        this.put(name, value);
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        this.put(name, value != null ? (byte[])value.clone() : null);
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        if (value != null) {
            byte[] reducedValue = new byte[length];
            System.arraycopy(value, offset, reducedValue, 0, length);
            this.put(name, reducedValue);
        } else {
            this.put(name, null);
        }
    }

    public void setChar(String name, char value) throws JMSException {
        this.put(name, new Character(value));
    }

    public void setDouble(String name, double value) throws JMSException {
        this.put(name, new Double(value));
    }

    public void setFloat(String name, float value) throws JMSException {
        this.put(name, new Float(value));
    }

    public void setInt(String name, int value) throws JMSException {
        this.put(name, value);
    }

    public void setLong(String name, long value) throws JMSException {
        this.put(name, value);
    }

    public void setObject(String name, Object value) throws JMSException {
        if (value != null) {
            if (!(value instanceof Boolean || value instanceof Byte || value instanceof Character || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof byte[])) {
                throw new MessageFormatException("Unsupported value type : " + value.getClass().getName());
            }
            if (value instanceof byte[]) {
                value = ArrayTools.copy((byte[])value);
            }
            this.put(name, value);
        } else {
            this.put(name, null);
        }
    }

    public void setShort(String name, short value) throws JMSException {
        this.put(name, value);
    }

    public void setString(String name, String value) throws JMSException {
        this.put(name, value);
    }

    public void clearBody() {
        this.assertDeserializationLevel(3);
        if (this.body != null) {
            this.body.clear();
        }
        this.bodyIsReadOnly = false;
    }

    @Override
    public AbstractMessage copy() {
        MapMessageImpl clone = new MapMessageImpl();
        this.copyCommonFields(clone);
        if (this.body != null) {
            clone.body = new HashMap<String, Object>();
            clone.body.putAll(this.body);
        }
        return clone;
    }
}

