/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.connection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.connection.ConnectionMetaDataImpl;
import net.timewalker.ffmq4.common.session.AbstractSession;
import net.timewalker.ffmq4.utils.ErrorTools;
import net.timewalker.ffmq4.utils.StringTools;
import net.timewalker.ffmq4.utils.id.IntegerID;
import net.timewalker.ffmq4.utils.id.IntegerIDProvider;
import net.timewalker.ffmq4.utils.id.UUIDProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractConnection
implements Connection {
    private static final Log log = LogFactory.getLog(AbstractConnection.class);
    protected String id = UUIDProvider.getInstance().getShortUUID();
    protected String clientID;
    private static ConnectionMetaData metaData = new ConnectionMetaDataImpl();
    protected boolean started;
    protected boolean closed;
    private ExceptionListener exceptionListener;
    private Set<String> temporaryQueues = new HashSet<String>();
    private Set<String> temporaryTopics = new HashSet<String>();
    protected IntegerIDProvider idProvider = new IntegerIDProvider();
    protected ReadWriteLock externalAccessLock = new ReentrantReadWriteLock();
    private Object exceptionListenerLock = new Object();
    private Map<IntegerID, AbstractSession> sessions = new Hashtable<IntegerID, AbstractSession>();

    public AbstractConnection(String clientID) {
        this.clientID = clientID;
    }

    public String getId() {
        return this.id;
    }

    public String getClientID() throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            if (this.clientID == null) {
                throw new InvalidClientIDException("Client ID not set");
            }
            String string = this.clientID;
            return string;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public ConnectionMetaData getMetaData() {
        return metaData;
    }

    public void setClientID(String clientID) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            if (StringTools.isEmpty(clientID)) {
                throw new InvalidClientIDException("Empty client ID");
            }
            if (this.clientID != null) {
                throw new IllegalStateException("Client ID is already set");
            }
            this.clientID = clientID;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExceptionListener getExceptionListener() {
        Object object = this.exceptionListenerLock;
        synchronized (object) {
            return this.exceptionListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        Object object = this.exceptionListenerLock;
        synchronized (object) {
            this.checkNotClosed();
            this.exceptionListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exceptionOccured(JMSException exception) {
        try {
            Object object = this.exceptionListenerLock;
            synchronized (object) {
                if (this.exceptionListener != null) {
                    this.exceptionListener.onException(exception);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception listener failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerTemporaryQueue(String queueName) {
        Set<String> set = this.temporaryQueues;
        synchronized (set) {
            this.temporaryQueues.add(queueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterTemporaryQueue(String queueName) {
        Set<String> set = this.temporaryQueues;
        synchronized (set) {
            this.temporaryQueues.remove(queueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRegisteredTemporaryQueue(String queueName) {
        Set<String> set = this.temporaryQueues;
        synchronized (set) {
            return this.temporaryQueues.contains(queueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerTemporaryTopic(String topicName) {
        Set<String> set = this.temporaryTopics;
        synchronized (set) {
            this.temporaryTopics.add(topicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterTemporaryTopic(String topicName) {
        Set<String> set = this.temporaryTopics;
        synchronized (set) {
            this.temporaryTopics.remove(topicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRegisteredTemporaryTopic(String topicName) {
        Set<String> set = this.temporaryTopics;
        synchronized (set) {
            return this.temporaryTopics.contains(topicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTemporaryQueues() {
        Set<String> set = this.temporaryQueues;
        synchronized (set) {
            for (String queueName : this.temporaryQueues) {
                try {
                    this.deleteTemporaryQueue(queueName);
                }
                catch (JMSException e) {
                    ErrorTools.log(e, log);
                }
            }
        }
    }

    public abstract void deleteTemporaryQueue(String var1) throws JMSException;

    public abstract void deleteTemporaryTopic(String var1) throws JMSException;

    public final void close() {
        this.externalAccessLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.onConnectionClose();
        }
        finally {
            this.externalAccessLock.writeLock().unlock();
        }
        this.onConnectionClosed();
    }

    protected void onConnectionClose() {
        this.closeRemainingSessions();
        this.dropTemporaryQueues();
    }

    protected void onConnectionClosed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRemainingSessions() {
        if (this.sessions == null) {
            return;
        }
        ArrayList<AbstractSession> sessionsToClose = new ArrayList<AbstractSession>(this.sessions.size());
        Map<IntegerID, AbstractSession> map = this.sessions;
        synchronized (map) {
            sessionsToClose.addAll(this.sessions.values());
        }
        for (int n = 0; n < sessionsToClose.size(); ++n) {
            Session session = (Session)sessionsToClose.get(n);
            log.debug((Object)("Auto-closing unclosed session : " + session));
            try {
                session.close();
                continue;
            }
            catch (JMSException e) {
                ErrorTools.log(e, log);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void wakeUpLocalConsumers() {
        try {
            ArrayList<AbstractSession> sessionsSnapshot = new ArrayList<AbstractSession>(this.sessions.size());
            Map<IntegerID, AbstractSession> map = this.sessions;
            synchronized (map) {
                sessionsSnapshot.addAll(this.sessions.values());
            }
            for (int n = 0; n < sessionsSnapshot.size(); ++n) {
                AbstractSession session = (AbstractSession)sessionsSnapshot.get(n);
                session.wakeUpConsumers();
            }
        }
        catch (JMSException e) {
            ErrorTools.log(e, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void waitForDeliverySync() {
        ArrayList<AbstractSession> sessionsSnapshot = new ArrayList<AbstractSession>(this.sessions.size());
        Map<IntegerID, AbstractSession> map = this.sessions;
        synchronized (map) {
            sessionsSnapshot.addAll(this.sessions.values());
        }
        for (int n = 0; n < sessionsSnapshot.size(); ++n) {
            AbstractSession session = (AbstractSession)sessionsSnapshot.get(n);
            session.waitForDeliverySync();
        }
    }

    public final AbstractSession lookupRegisteredSession(IntegerID sessionId) {
        return this.sessions.get(sessionId);
    }

    protected final void registerSession(AbstractSession sessionToAdd) {
        if (this.sessions.put(sessionToAdd.getId(), sessionToAdd) != null) {
            throw new IllegalArgumentException("Session " + sessionToAdd.getId() + " already exists");
        }
    }

    public final void unregisterSession(AbstractSession sessionToRemove) {
        if (this.sessions.remove(sessionToRemove.getId()) == null) {
            log.warn((Object)("Unknown session : " + sessionToRemove));
        }
    }

    protected final void checkNotClosed() throws JMSException {
        if (this.closed) {
            throw new FFMQException("Connection is closed", "CONNECTION_CLOSED");
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new FFMQException("Unsupported feature", "UNSUPPORTED_FEATURE");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new FFMQException("Unsupported feature", "UNSUPPORTED_FEATURE");
    }

    protected void finalize() throws Throwable {
        if (this.externalAccessLock != null && !this.closed) {
            log.warn((Object)"Connection was not properly closed, closing it now.");
            try {
                this.close();
            }
            catch (Throwable e) {
                log.error((Object)"Could not auto-close connection", e);
            }
        }
    }

    public boolean isStarted() {
        return this.started && !this.closed;
    }

    public int getSessionsCount() {
        return this.sessions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConsumersCount() {
        Map<IntegerID, AbstractSession> map = this.sessions;
        synchronized (map) {
            if (this.sessions.isEmpty()) {
                return 0;
            }
            int total = 0;
            for (AbstractSession session : this.sessions.values()) {
                total += session.getConsumersCount();
            }
            return total;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProducersCount() {
        Map<IntegerID, AbstractSession> map = this.sessions;
        synchronized (map) {
            if (this.sessions.isEmpty()) {
                return 0;
            }
            int total = 0;
            for (AbstractSession session : this.sessions.values()) {
                total += session.getProducersCount();
            }
            return total;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Connection[#");
        sb.append(this.id);
        sb.append("](started=");
        sb.append(this.started);
        sb.append(")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getEntitiesDescription(StringBuilder sb) {
        sb.append(this.toString());
        sb.append("{");
        Map<IntegerID, AbstractSession> map = this.sessions;
        synchronized (map) {
            if (!this.sessions.isEmpty()) {
                int pos = 0;
                for (AbstractSession session : this.sessions.values()) {
                    if (pos++ > 0) {
                        sb.append(",");
                    }
                    session.getEntitiesDescription(sb);
                }
            }
        }
        sb.append("}");
    }
}

