/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport.tcp.nio;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import net.timewalker.ffmq4.transport.PacketTransportException;
import net.timewalker.ffmq4.transport.packet.AbstractPacket;
import net.timewalker.ffmq4.transport.packet.PacketSerializer;
import net.timewalker.ffmq4.transport.packet.query.PingQuery;
import net.timewalker.ffmq4.transport.tcp.AbstractTcpPacketTransport;
import net.timewalker.ffmq4.transport.tcp.SocketUtils;
import net.timewalker.ffmq4.transport.tcp.nio.NIOClientSocketHandler;
import net.timewalker.ffmq4.transport.tcp.nio.NIOTcpMultiplexer;
import net.timewalker.ffmq4.utils.RawDataBuffer;
import net.timewalker.ffmq4.utils.Settings;
import net.timewalker.ffmq4.utils.watchdog.ActiveObject;
import net.timewalker.ffmq4.utils.watchdog.ActivityWatchdog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NIOTcpPacketTransport
extends AbstractTcpPacketTransport
implements NIOClientSocketHandler {
    protected static final Log log = LogFactory.getLog(NIOTcpPacketTransport.class);
    private ByteBuffer inputBuffer;
    private ByteBuffer outputBuffer;
    private NIOTcpMultiplexer multiplexer;
    private SocketChannel socketChannel;
    private int maxPacketSize;
    private LinkedList<AbstractPacket> sendQueue = new LinkedList();
    private RawDataBuffer packetOutputBuffer;
    private RawDataBuffer packetInputBuffer;
    private int currentInputOffset;
    private int currentOutputOffset;
    protected long lastSendActivity;
    protected long lastRecvActivity;
    private ActiveObject sendActivityMonitor;
    private ActiveObject recvActivityMonitor;
    private boolean trustedConnection = false;
    private boolean traceEnabled;

    public NIOTcpPacketTransport(String id, NIOTcpMultiplexer multiplexer, URI transportURI, Settings settings) throws PacketTransportException {
        super(id, true, settings);
        this.multiplexer = multiplexer;
        this.init(settings);
        this.socketChannel = this.connect(transportURI);
    }

    public NIOTcpPacketTransport(String id, NIOTcpMultiplexer multiplexer, SocketChannel socketChannel, Settings settings) {
        super(id, false, settings);
        this.multiplexer = multiplexer;
        this.socketChannel = socketChannel;
        this.init(settings);
    }

    @Override
    public SocketAddress getRemotePeer() {
        return this.socketChannel.socket().getRemoteSocketAddress();
    }

    private void init(Settings settings) {
        this.traceEnabled = log.isTraceEnabled();
        this.sendQueueMaxSize = settings.getIntProperty("transport.tcp.sendQueueMaxSize", 1000);
        this.maxPacketSize = this.client ? -1 : settings.getIntProperty("transport.tcp.packet.maxSize", 0x100400);
        this.inputBuffer = ByteBuffer.allocate(this.streamRecvBufferSize).order(ByteOrder.BIG_ENDIAN);
        this.outputBuffer = ByteBuffer.allocate(this.streamSendBufferSize).order(ByteOrder.BIG_ENDIAN);
        this.packetInputBuffer = new RawDataBuffer(this.initialPacketBufferSize);
        this.packetOutputBuffer = new RawDataBuffer(this.initialPacketBufferSize);
        this.lastSendActivity = this.lastRecvActivity = System.currentTimeMillis();
        if (this.client) {
            this.sendActivityMonitor = new ActiveObject(){

                @Override
                public long getLastActivity() {
                    return NIOTcpPacketTransport.this.lastSendActivity;
                }

                @Override
                public long getTimeoutDelay() {
                    return (long)NIOTcpPacketTransport.this.pingInterval * 1000L;
                }

                @Override
                public boolean onActivityTimeout() throws Exception {
                    NIOTcpPacketTransport.this.send(new PingQuery());
                    return false;
                }
            };
            ActivityWatchdog.getInstance().register(this.sendActivityMonitor);
        }
        this.recvActivityMonitor = new ActiveObject(){

            @Override
            public long getLastActivity() {
                return NIOTcpPacketTransport.this.lastRecvActivity;
            }

            @Override
            public long getTimeoutDelay() {
                return (long)NIOTcpPacketTransport.this.pingInterval * 1000L * 2L;
            }

            @Override
            public boolean onActivityTimeout() throws Exception {
                log.warn((Object)(NIOTcpPacketTransport.this.getId() + " : ping timeout on client socket, closing connection."));
                NIOTcpPacketTransport.this.closeTransport(true);
                return true;
            }
        };
        ActivityWatchdog.getInstance().register(this.recvActivityMonitor);
    }

    private SocketChannel connect(URI transportURI) throws PacketTransportException {
        String host = transportURI.getHost();
        int port = transportURI.getPort();
        try {
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(false);
            SocketUtils.setupSocket(socketChannel.socket(), this.socketSendBufferSize, this.socketRecvBufferSize);
            log.debug((Object)("#" + this.id + " opening a TCP connection to " + host + ":" + port));
            socketChannel.connect(new InetSocketAddress(host, port));
            return socketChannel;
        }
        catch (Exception e) {
            log.error((Object)("#" + this.id + " could not connect to " + host + ":" + port), (Throwable)e);
            throw new PacketTransportException("Could not connect to " + host + ":" + port + " : " + e.toString());
        }
    }

    @Override
    public ByteBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    public ByteBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public boolean handleIncomingData() {
        this.lastRecvActivity = System.currentTimeMillis();
        while (this.inputBuffer.remaining() > 0) {
            if (this.packetInputBuffer.size() == 0) {
                if (this.inputBuffer.remaining() >= 4) {
                    int packetSize = this.inputBuffer.getInt();
                    int actualMaxPacketSize = Integer.MAX_VALUE;
                    if (this.maxPacketSize != -1) {
                        int n = actualMaxPacketSize = this.trustedConnection ? this.maxPacketSize : 1024;
                    }
                    if (packetSize > actualMaxPacketSize) {
                        log.error((Object)("#" + this.id + " packet is too large : " + packetSize + " (maxPacketSize=" + actualMaxPacketSize + "), dropping client."));
                        return false;
                    }
                    this.packetInputBuffer.setSize(packetSize);
                    continue;
                }
                return true;
            }
            int readAmount = Math.min(this.inputBuffer.remaining(), this.packetInputBuffer.size() - this.currentInputOffset);
            this.packetInputBuffer.getFrom(this.inputBuffer, this.currentInputOffset, readAmount);
            this.currentInputOffset += readAmount;
            if (this.currentInputOffset != this.packetInputBuffer.size()) continue;
            AbstractPacket packet = this.unserializePacket(this.packetInputBuffer);
            if (packet == null) {
                return false;
            }
            this.packetInputBuffer.clear();
            this.currentInputOffset = 0;
            if (this.traceEnabled) {
                log.trace((Object)("#" + this.id + " Received " + packet));
            }
            if (this.listener == null) continue;
            this.trustedConnection = this.listener.packetReceived(packet);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean appendOutgoingData() {
        while (this.outputBuffer.remaining() > 0) {
            AbstractPacket sentPacket;
            if (this.packetOutputBuffer.size() == 0) {
                if (this.sendQueue.size() == 0) {
                    return true;
                }
                if (this.outputBuffer.remaining() < 4) {
                    return true;
                }
                if (!this.serializePacket(this.sendQueue.getFirst(), this.packetOutputBuffer)) {
                    return false;
                }
                this.outputBuffer.putInt(this.packetOutputBuffer.size());
                this.currentOutputOffset = 0;
                continue;
            }
            int writeAmount = Math.min(this.outputBuffer.remaining(), this.packetOutputBuffer.size() - this.currentOutputOffset);
            this.packetOutputBuffer.putTo(this.outputBuffer, this.currentOutputOffset, writeAmount);
            this.currentOutputOffset += writeAmount;
            if (this.currentOutputOffset != this.packetOutputBuffer.size()) continue;
            LinkedList<AbstractPacket> linkedList = this.sendQueue;
            synchronized (linkedList) {
                sentPacket = this.sendQueue.removeFirst();
            }
            this.packetOutputBuffer.clear();
            if (this.listener == null) continue;
            this.listener.packetSent(sentPacket);
        }
        return true;
    }

    private boolean serializePacket(AbstractPacket packet, RawDataBuffer buffer) {
        try {
            buffer.clear();
            PacketSerializer.serializeTo(packet, buffer);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("#" + this.id + " cannot unserialize packet"), (Throwable)e);
            return false;
        }
    }

    private AbstractPacket unserializePacket(RawDataBuffer buffer) {
        try {
            buffer.reset();
            return PacketSerializer.unserializeFrom(buffer);
        }
        catch (Exception e) {
            log.error((Object)("#" + this.id + " cannot unserialize packet"), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasWriteInterest() {
        LinkedList<AbstractPacket> linkedList = this.sendQueue;
        synchronized (linkedList) {
            return this.sendQueue.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(AbstractPacket packet) throws PacketTransportException {
        boolean wakeUpRequired;
        if (this.closed) {
            throw new PacketTransportException("Transport is closed");
        }
        if (packet.isResponseExpected()) {
            this.lastSendActivity = System.currentTimeMillis();
        }
        LinkedList<AbstractPacket> linkedList = this.sendQueue;
        synchronized (linkedList) {
            wakeUpRequired = this.sendQueue.isEmpty();
            this.sendQueue.add(packet);
        }
        if (wakeUpRequired) {
            this.multiplexer.wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needsThrottling() {
        LinkedList<AbstractPacket> linkedList = this.sendQueue;
        synchronized (linkedList) {
            return this.sendQueueMaxSize > 0 && this.sendQueue.size() >= this.sendQueueMaxSize;
        }
    }

    @Override
    public void start() throws PacketTransportException {
        if (this.client) {
            this.multiplexer.registerClientSocketHandler(this);
        } else {
            this.multiplexer.wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeTransport(boolean linkFailed) {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.sendActivityMonitor != null) {
            ActivityWatchdog.getInstance().unregister(this.sendActivityMonitor);
        }
        if (this.recvActivityMonitor != null) {
            ActivityWatchdog.getInstance().unregister(this.recvActivityMonitor);
        }
        if (!linkFailed) {
            this.multiplexer.unregisterClientSocketHandler(this);
        }
        if (this.listener != null) {
            this.listener.transportClosed(linkFailed, false);
        }
    }

    @Override
    public void onSocketChannelClosed() {
        this.closeTransport(true);
    }

    @Override
    public void close() {
        this.closeTransport(false);
    }
}

