/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport.packet.query;

import java.util.ArrayList;
import java.util.List;
import net.timewalker.ffmq4.transport.packet.query.AbstractConsumerQuery;
import net.timewalker.ffmq4.utils.RawDataBuffer;

public final class CloseConsumerQuery
extends AbstractConsumerQuery {
    private List<String> undeliveredMessageIDs;

    public List<String> getUndeliveredMessageIDs() {
        return this.undeliveredMessageIDs;
    }

    public void addUndeliveredMessageID(String msgID) {
        if (this.undeliveredMessageIDs == null) {
            this.undeliveredMessageIDs = new ArrayList<String>();
        }
        this.undeliveredMessageIDs.add(msgID);
    }

    @Override
    public byte getType() {
        return 51;
    }

    @Override
    protected void serializeTo(RawDataBuffer out) {
        super.serializeTo(out);
        if (this.undeliveredMessageIDs != null) {
            int len = this.undeliveredMessageIDs.size();
            out.writeInt(len);
            for (int i = 0; i < len; ++i) {
                out.writeUTF(this.undeliveredMessageIDs.get(i));
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    protected void unserializeFrom(RawDataBuffer in) {
        super.unserializeFrom(in);
        int idCount = in.readInt();
        for (int i = 0; i < idCount; ++i) {
            String msgID = in.readUTF();
            this.addUndeliveredMessageID(msgID);
        }
    }
}

