/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.jndi;

import java.net.URI;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.jndi.FFMQConnectionFactory;
import net.timewalker.ffmq4.local.FFMQEngine;
import net.timewalker.ffmq4.remote.connection.RemoteQueueConnection;

public final class FFMQQueueConnectionFactory
extends FFMQConnectionFactory
implements QueueConnectionFactory {
    private static final long serialVersionUID = 1L;

    public FFMQQueueConnectionFactory() {
    }

    public FFMQQueueConnectionFactory(Hashtable<String, Object> environment) {
        super(environment);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        String username = this.getStringProperty("java.naming.security.principal", null);
        String password = this.getStringProperty("java.naming.security.credentials", null);
        return this.createQueueConnection(username, password);
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        URI providerURL = this.getProviderURI();
        String scheme = providerURL.getScheme();
        if (scheme.equals("vm")) {
            String engineName = providerURL.getHost();
            return FFMQEngine.getDeployedInstance(engineName).openQueueConnection(userName, password, this.clientID);
        }
        if (scheme.equals("tcp") || scheme.equals("tcps") || scheme.equals("tcpnio")) {
            return new RemoteQueueConnection(providerURL, userName, password, this.clientID);
        }
        throw new FFMQException("Unknown transport protocol : " + scheme, "INVALID_TRANSPORT_PROTOCOL");
    }
}

