/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.jndi;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.jndi.JNDIObjectFactory;
import net.timewalker.ffmq4.local.FFMQEngine;
import net.timewalker.ffmq4.remote.connection.RemoteConnection;

public class FFMQConnectionFactory
implements ConnectionFactory,
Serializable,
Referenceable {
    private static final long serialVersionUID = 1L;
    protected Hashtable<String, Object> environment;
    protected String clientID;

    public FFMQConnectionFactory() {
        this(new Hashtable<String, Object>());
    }

    public FFMQConnectionFactory(Hashtable<String, Object> environment) {
        this.environment = environment;
        this.clientID = this.getStringProperty("ffmq.naming.clientID", null);
    }

    protected final String getStringProperty(String propertyName, String defaultValue) {
        String propertyValue = (String)this.environment.get(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        return propertyValue;
    }

    protected final int getIntProperty(String propertyName, int defaultValue) {
        String propertyValue = (String)this.environment.get(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getSecurityPrincipal() {
        return this.getStringProperty("java.naming.security.principal", null);
    }

    public void setSecurityPrincipal(String securityPrincipal) {
        if (securityPrincipal != null) {
            this.environment.put("java.naming.security.principal", securityPrincipal);
        } else {
            this.environment.remove("java.naming.security.principal");
        }
    }

    public String getSecurityCredentials() {
        return this.getStringProperty("java.naming.security.credentials", null);
    }

    public void setSecurityCredentials(String securityCredentials) {
        if (securityCredentials != null) {
            this.environment.put("java.naming.security.credentials", securityCredentials);
        } else {
            this.environment.remove("java.naming.security.credentials");
        }
    }

    public String getProviderURL() {
        return this.getStringProperty("java.naming.provider.url", "tcp://localhost:10002");
    }

    public void setProviderURL(String providerURL) {
        if (providerURL != null) {
            this.environment.put("java.naming.provider.url", providerURL);
        } else {
            this.environment.remove("java.naming.provider.url");
        }
    }

    public final Connection createConnection() throws JMSException {
        String username = this.getStringProperty("java.naming.security.principal", null);
        String password = this.getStringProperty("java.naming.security.credentials", null);
        return this.createConnection(username, password);
    }

    public final Connection createConnection(String userName, String password) throws JMSException {
        URI providerURL = this.getProviderURI();
        String scheme = providerURL.getScheme();
        if (scheme.equals("vm")) {
            String engineName = providerURL.getHost();
            return FFMQEngine.getDeployedInstance(engineName).openConnection(userName, password, this.clientID);
        }
        if (scheme.equals("tcp") || scheme.equals("tcps") || scheme.equals("tcpnio")) {
            return new RemoteConnection(providerURL, userName, password, this.clientID);
        }
        throw new FFMQException("Unknown transport protocol : " + scheme, "INVALID_TRANSPORT_PROTOCOL");
    }

    protected final URI getProviderURI() throws JMSException {
        URI parsedURL;
        String providerURL = this.getProviderURL();
        try {
            parsedURL = new URI(providerURL);
        }
        catch (URISyntaxException e) {
            throw new FFMQException("Malformed provider URL : " + providerURL, "INVALID_PROVIDER_URL");
        }
        if (!parsedURL.isAbsolute()) {
            throw new FFMQException("Invalid provider URL : " + providerURL, "INVALID_PROVIDER_URL");
        }
        return parsedURL;
    }

    @Override
    public final Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), JNDIObjectFactory.class.getName(), null);
        ref.add(new StringRefAddr("providerURL", this.getProviderURL()));
        if (this.clientID != null) {
            ref.add(new StringRefAddr("clientID", this.clientID));
        }
        return ref;
    }
}

