/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message.selector.expression.utils;

import java.lang.reflect.Array;
import java.util.StringTokenizer;
import javax.jms.InvalidSelectorException;

public final class StringUtils {
    public static String replaceDoubleSingleQuotes(String value) {
        int idx = value.indexOf("''");
        if (idx == -1) {
            return value;
        }
        int len = value.length();
        int pos = 0;
        StringBuilder sb = new StringBuilder(len);
        while (idx != -1) {
            if (idx > pos) {
                sb.append(value.substring(pos, idx));
                pos += idx - pos;
            }
            sb.append("'");
            idx = value.indexOf("''", pos += 2);
        }
        if (pos < len) {
            sb.append(value.substring(pos, len));
        }
        return sb.toString();
    }

    public static String replaceSingleQuotes(String value) {
        int idx = value.indexOf("'");
        if (idx == -1) {
            return value;
        }
        int len = value.length();
        int pos = 0;
        StringBuilder sb = new StringBuilder(len);
        while (idx != -1) {
            if (idx > pos) {
                sb.append(value.substring(pos, idx));
                pos += idx - pos;
            }
            sb.append("''");
            idx = value.indexOf("'", ++pos);
        }
        if (pos < len) {
            sb.append(value.substring(pos, len));
        }
        return sb.toString();
    }

    public static Number parseNumber(String numberAsString) throws InvalidSelectorException {
        if (numberAsString == null) {
            return null;
        }
        try {
            if (numberAsString.indexOf(46) != -1 || numberAsString.indexOf(101) != -1 || numberAsString.indexOf(69) != -1) {
                return new Double(numberAsString);
            }
            return Long.valueOf(numberAsString);
        }
        catch (NumberFormatException e) {
            throw new InvalidSelectorException("Invalid numeric value : " + numberAsString);
        }
    }

    public static Boolean matches(String text, String pattern, String escapeChar) {
        if (pattern.length() == 0) {
            return text.length() == 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        int textPos = 0;
        boolean startWithAny = false;
        String separators = "%_";
        if (escapeChar != null) {
            separators = separators + escapeChar;
        }
        StringTokenizer st = new StringTokenizer(pattern, separators, true);
        boolean escapeNext = false;
        while (st.hasMoreTokens()) {
            String subPattern = st.nextToken();
            if (escapeChar != null && !escapeNext && subPattern.equals(escapeChar)) {
                escapeNext = true;
                continue;
            }
            if (!escapeNext && subPattern.equals("%")) {
                startWithAny = true;
                continue;
            }
            if (!escapeNext && subPattern.equals("_")) {
                if (textPos < text.length()) {
                    ++textPos;
                    continue;
                }
                return Boolean.FALSE;
            }
            if (startWithAny) {
                int matchPos = text.lastIndexOf(subPattern);
                if (matchPos == -1 || matchPos < textPos) {
                    return Boolean.FALSE;
                }
                textPos = matchPos + subPattern.length();
                startWithAny = false;
            } else {
                if (!text.startsWith(subPattern, textPos)) {
                    return Boolean.FALSE;
                }
                textPos += subPattern.length();
            }
            escapeNext = false;
        }
        return Boolean.TRUE;
    }

    public static String implode(Object array, String delimiter) {
        StringBuilder sb = new StringBuilder();
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            Object value = Array.get(array, i);
            sb.append(String.valueOf(value));
        }
        return sb.toString();
    }

    public static String rightPad(String text, int len, char paddingChar) {
        if (text.length() >= len) {
            return text;
        }
        StringBuilder sb = new StringBuilder(len);
        sb.append(text);
        for (int n = 0; n < len - text.length(); ++n) {
            sb.append(paddingChar);
        }
        return sb.toString();
    }
}

