/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message;

import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import net.timewalker.ffmq4.common.destination.DestinationRef;
import net.timewalker.ffmq4.common.destination.QueueRef;
import net.timewalker.ffmq4.common.destination.TopicRef;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.message.BytesMessageImpl;
import net.timewalker.ffmq4.common.message.EmptyMessageImpl;
import net.timewalker.ffmq4.common.message.MapMessageImpl;
import net.timewalker.ffmq4.common.message.ObjectMessageImpl;
import net.timewalker.ffmq4.common.message.StreamMessageImpl;
import net.timewalker.ffmq4.common.message.TextMessageImpl;

public final class MessageTools {
    public static AbstractMessage makeInternalCopy(Message srcMessage) throws JMSException {
        if (srcMessage instanceof AbstractMessage) {
            AbstractMessage msg = (AbstractMessage)srcMessage;
            if (msg.isInternalCopy()) {
                return msg;
            }
            AbstractMessage dup = MessageTools.duplicate(srcMessage);
            dup.setInternalCopy(true);
            return dup;
        }
        AbstractMessage dup = MessageTools.duplicate(srcMessage);
        dup.setInternalCopy(true);
        return dup;
    }

    public static AbstractMessage normalize(Message srcMessage) throws JMSException {
        if (srcMessage instanceof AbstractMessage) {
            return (AbstractMessage)srcMessage;
        }
        return MessageTools.duplicate(srcMessage);
    }

    public static AbstractMessage duplicate(Message srcMessage) throws JMSException {
        AbstractMessage msgCopy = srcMessage instanceof AbstractMessage ? ((AbstractMessage)srcMessage).copy() : (srcMessage instanceof TextMessage ? MessageTools.duplicateTextMessage((TextMessage)srcMessage) : (srcMessage instanceof ObjectMessage ? MessageTools.duplicateObjectMessage((ObjectMessage)srcMessage) : (srcMessage instanceof BytesMessage ? MessageTools.duplicateBytesMessage((BytesMessage)srcMessage) : (srcMessage instanceof MapMessage ? MessageTools.duplicateMapMessage((MapMessage)srcMessage) : (srcMessage instanceof StreamMessage ? MessageTools.duplicateStreamMessage((StreamMessage)srcMessage) : MessageTools.duplicateMessage(srcMessage))))));
        return msgCopy;
    }

    private static AbstractMessage duplicateBytesMessage(BytesMessage srcMessage) throws JMSException {
        int readAmount;
        BytesMessageImpl copy = new BytesMessageImpl();
        MessageTools.copyHeaders((Message)srcMessage, copy);
        srcMessage.reset();
        byte[] buffer = new byte[1024];
        while ((readAmount = srcMessage.readBytes(buffer)) > 0) {
            copy.writeBytes(buffer, 0, readAmount);
        }
        return copy;
    }

    private static AbstractMessage duplicateObjectMessage(ObjectMessage srcMessage) throws JMSException {
        ObjectMessageImpl copy = new ObjectMessageImpl();
        MessageTools.copyHeaders((Message)srcMessage, copy);
        copy.setObject(srcMessage.getObject());
        return copy;
    }

    private static AbstractMessage duplicateMapMessage(MapMessage srcMessage) throws JMSException {
        MapMessageImpl copy = new MapMessageImpl();
        MessageTools.copyHeaders((Message)srcMessage, copy);
        Enumeration allNames = srcMessage.getMapNames();
        while (allNames.hasMoreElements()) {
            String name = (String)allNames.nextElement();
            Object value = srcMessage.getObject(name);
            copy.setObject(name, value);
        }
        return copy;
    }

    private static AbstractMessage duplicateStreamMessage(StreamMessage srcMessage) throws JMSException {
        StreamMessageImpl copy = new StreamMessageImpl();
        MessageTools.copyHeaders((Message)srcMessage, copy);
        srcMessage.reset();
        try {
            while (true) {
                copy.writeObject(srcMessage.readObject());
            }
        }
        catch (MessageEOFException messageEOFException) {
            return copy;
        }
    }

    private static AbstractMessage duplicateTextMessage(TextMessage srcMessage) throws JMSException {
        TextMessageImpl copy = new TextMessageImpl();
        MessageTools.copyHeaders((Message)srcMessage, copy);
        copy.setText(srcMessage.getText());
        return copy;
    }

    private static AbstractMessage duplicateMessage(Message srcMessage) throws JMSException {
        EmptyMessageImpl copy = new EmptyMessageImpl();
        MessageTools.copyHeaders(srcMessage, copy);
        return copy;
    }

    private static void copyHeaders(Message srcMessage, Message dstMessage) throws JMSException {
        dstMessage.setJMSCorrelationID(srcMessage.getJMSCorrelationID());
        dstMessage.setJMSDeliveryMode(srcMessage.getJMSDeliveryMode());
        Destination destination = srcMessage.getJMSDestination();
        if (destination != null) {
            if (destination instanceof DestinationRef) {
                dstMessage.setJMSDestination(destination);
            } else if (destination instanceof Queue) {
                dstMessage.setJMSDestination((Destination)new QueueRef(((Queue)destination).getQueueName()));
            } else if (destination instanceof Topic) {
                dstMessage.setJMSDestination((Destination)new TopicRef(((Topic)destination).getTopicName()));
            }
        }
        dstMessage.setJMSExpiration(srcMessage.getJMSExpiration());
        dstMessage.setJMSMessageID(srcMessage.getJMSMessageID());
        dstMessage.setJMSPriority(srcMessage.getJMSPriority());
        dstMessage.setJMSRedelivered(srcMessage.getJMSRedelivered());
        Destination replyTo = srcMessage.getJMSReplyTo();
        if (replyTo != null) {
            if (replyTo instanceof DestinationRef) {
                dstMessage.setJMSReplyTo(replyTo);
            } else if (replyTo instanceof Queue) {
                dstMessage.setJMSReplyTo((Destination)new QueueRef(((Queue)replyTo).getQueueName()));
            } else if (replyTo instanceof Topic) {
                dstMessage.setJMSReplyTo((Destination)new TopicRef(((Topic)replyTo).getTopicName()));
            }
        }
        dstMessage.setJMSTimestamp(srcMessage.getJMSTimestamp());
        dstMessage.setJMSType(srcMessage.getJMSType());
        Enumeration allProps = dstMessage.getPropertyNames();
        while (allProps.hasMoreElements()) {
            String propName = (String)allProps.nextElement();
            Object propValue = srcMessage.getObjectProperty(propName);
            if (propValue == null) continue;
            dstMessage.setObjectProperty(propName, propValue);
        }
    }
}

