/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.destination;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import net.timewalker.ffmq4.common.destination.DestinationRef;
import net.timewalker.ffmq4.common.destination.QueueRef;
import net.timewalker.ffmq4.common.destination.TopicRef;
import net.timewalker.ffmq4.utils.RawDataBuffer;

public final class DestinationSerializer {
    private static final byte NO_DESTINATION = 0;
    private static final byte TYPE_QUEUE = 1;
    private static final byte TYPE_TOPIC = 2;

    public static void serializeTo(Destination destination, RawDataBuffer out) {
        block5: {
            try {
                if (destination == null) {
                    out.writeByte(0);
                    break block5;
                }
                if (destination instanceof Queue) {
                    out.writeByte(1);
                    out.writeUTF(((Queue)destination).getQueueName());
                    break block5;
                }
                if (destination instanceof Topic) {
                    out.writeByte(2);
                    out.writeUTF(((Topic)destination).getTopicName());
                    break block5;
                }
                throw new IllegalArgumentException("Unsupported destination : " + destination);
            }
            catch (JMSException e) {
                throw new IllegalArgumentException("Cannot serialize destination : " + e.getMessage());
            }
        }
    }

    public static DestinationRef unserializeFrom(RawDataBuffer in) {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        String destinationName = in.readUTF();
        switch (type) {
            case 1: {
                return new QueueRef(destinationName);
            }
            case 2: {
                return new TopicRef(destinationName);
            }
        }
        throw new IllegalArgumentException("Unsupported destination type : " + type);
    }
}

