package com.formos.tapestry.testify.internal;

import com.formos.tapestry.testify.core.ForComponents;

/**
 * Stores objects that are will be
 * preferentially injected into pages/components during a test.
 * Actually, keeps track of {@link ObjectAccessor}s so the real objects
 * are accessed at the point they are needed and they can be different
 * objects at different times. 
 * 
 * @see ForComponents
 */
public interface ObjectsForComponentsStore {
    String NO_ID = "";

    /**
     * Gets an object for the given type and id.
     *  
     * @param type  the type of object to look for (will match any object that is an 'instanceof' this type) (not null)
     * @param id    the specific of the object to find (not null; use {@link #NO_ID} to match by type only) (not null)
     * @return the object found, or null if no object matched.
     * @throws RuntimeException if multiple objects match.
     */
    <T> T get(Class<T> type, String id);
    
    
    /**
     * Add an object to the store.
     * 
     * @param objectAccessor the way to access the object (not null)
     * @param id             the id for the object or {@link #NO_ID}  (not null)
     */
    void put(ObjectAccessor objectAccessor, String id);
}
