package com.formos.tapestry.testify.core;

import com.formos.tapestry.testify.internal.PerTestDataStore;
import com.formos.tapestry.testify.internal.PerTestServiceLifecycle;

/**
 * Utility class containing constants for the Tapestry Testify extension.
 */
public final class TestifyConstants {

    /**
     * An alternate scope; a per-test instance is created on demand, behind a shared proxy.
     * Method invocations on the shared proxy are forwarded to the per-test instance.
     * Each per-test instance lasts until the {@link PerTestDataStore#cleanup()} is called
     * (which is called by {@link TapestryTester#endTest()}).
     *
     * @see PerTestServiceLifecycle
     */
    public static final String PERTEST = "pertest";


    private TestifyConstants() {
        // Utility class: cannot instantiate...
    }
}
