/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.htmlunit;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.DefaultCredentialsProvider;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.JavaScriptPage;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.RefreshHandler;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.UnexpectedPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowEvent;
import com.gargoylesoftware.htmlunit.WebWindowListener;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitXPath;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jwebunit.api.IJWebUnitDialog;
import net.sourceforge.jwebunit.exception.ExpectedJavascriptAlertException;
import net.sourceforge.jwebunit.exception.ExpectedJavascriptConfirmException;
import net.sourceforge.jwebunit.exception.ExpectedJavascriptPromptException;
import net.sourceforge.jwebunit.exception.TestingEngineResponseException;
import net.sourceforge.jwebunit.exception.UnableToSetFormException;
import net.sourceforge.jwebunit.exception.UnexpectedJavascriptAlertException;
import net.sourceforge.jwebunit.exception.UnexpectedJavascriptConfirmException;
import net.sourceforge.jwebunit.exception.UnexpectedJavascriptPromptException;
import net.sourceforge.jwebunit.html.Cell;
import net.sourceforge.jwebunit.html.Row;
import net.sourceforge.jwebunit.html.Table;
import net.sourceforge.jwebunit.htmlunit.ImmediateRefreshHandler;
import net.sourceforge.jwebunit.javascript.JavascriptAlert;
import net.sourceforge.jwebunit.javascript.JavascriptConfirm;
import net.sourceforge.jwebunit.javascript.JavascriptPrompt;
import net.sourceforge.jwebunit.util.TestContext;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.jaxen.JaxenException;

public class HtmlUnitDialog
implements IJWebUnitDialog {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$net$sourceforge$jwebunit$htmlunit$HtmlUnitDialog == null ? (class$net$sourceforge$jwebunit$htmlunit$HtmlUnitDialog = HtmlUnitDialog.class$("net.sourceforge.jwebunit.htmlunit.HtmlUnitDialog")) : class$net$sourceforge$jwebunit$htmlunit$HtmlUnitDialog));
    private WebClient wc;
    private WebWindow win;
    private TestContext testContext;
    private HtmlForm form;
    private boolean jsEnabled = true;
    private LinkedList expectedJavascriptAlerts = new LinkedList();
    private LinkedList expectedJavascriptConfirms = new LinkedList();
    private LinkedList expectedJavascriptPrompts = new LinkedList();
    static /* synthetic */ Class class$net$sourceforge$jwebunit$htmlunit$HtmlUnitDialog;

    public void beginAt(URL initialURL, TestContext context) throws TestingEngineResponseException {
        this.setTestContext(context);
        this.initWebClient();
        try {
            this.wc.getPage(initialURL);
            this.win = this.wc.getCurrentWindow();
            this.form = null;
        }
        catch (FailingHttpStatusCodeException aException) {
            throw new TestingEngineResponseException(aException.getStatusCode(), (Exception)((Object)aException));
        }
        catch (IOException aException) {
            throw new RuntimeException(aException);
        }
    }

    public void closeBrowser() throws ExpectedJavascriptAlertException, ExpectedJavascriptConfirmException, ExpectedJavascriptPromptException {
        this.wc = null;
        if (this.expectedJavascriptAlerts.size() > 0) {
            throw new ExpectedJavascriptAlertException(((JavascriptAlert)this.expectedJavascriptAlerts.get(0)).getMessage());
        }
        if (this.expectedJavascriptConfirms.size() > 0) {
            throw new ExpectedJavascriptConfirmException(((JavascriptConfirm)this.expectedJavascriptConfirms.get(0)).getMessage());
        }
        if (this.expectedJavascriptPrompts.size() > 0) {
            throw new ExpectedJavascriptPromptException(((JavascriptPrompt)this.expectedJavascriptPrompts.get(0)).getMessage());
        }
    }

    public void gotoPage(URL initialURL) throws TestingEngineResponseException {
        try {
            this.wc.getPage(initialURL);
            this.win = this.wc.getCurrentWindow();
            this.form = null;
        }
        catch (FailingHttpStatusCodeException aException) {
            throw new TestingEngineResponseException(aException.getStatusCode());
        }
        catch (IOException aException) {
            throw new RuntimeException(aException);
        }
    }

    public void setScriptingEnabled(boolean value) {
        this.jsEnabled = value;
        if (this.wc != null) {
            this.wc.setJavaScriptEnabled(value);
        }
    }

    public List getCookies() {
        LinkedList<javax.servlet.http.Cookie> result = new LinkedList<javax.servlet.http.Cookie>();
        HttpState stateForUrl = this.wc.getWebConnection().getState();
        Cookie[] cookies = stateForUrl.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            javax.servlet.http.Cookie c = new javax.servlet.http.Cookie(cookies[i].getName(), cookies[i].getValue());
            c.setComment(cookies[i].getComment());
            c.setDomain(cookies[i].getDomain());
            Date expire = cookies[i].getExpiryDate();
            if (expire == null) {
                c.setMaxAge(-1);
            } else {
                Date now = Calendar.getInstance().getTime();
                Long second = new Long((expire.getTime() - now.getTime()) / 1000L);
                c.setMaxAge(second.intValue());
            }
            c.setPath(cookies[i].getPath());
            c.setSecure(cookies[i].getSecure());
            c.setVersion(cookies[i].getVersion());
            result.add(c);
        }
        return result;
    }

    public boolean hasWindow(String windowName) {
        try {
            this.getWindow(windowName);
        }
        catch (WebWindowNotFoundException e) {
            return false;
        }
        return true;
    }

    public boolean hasWindowByTitle(String title) {
        return this.getWindowByTitle(title) != null;
    }

    public void gotoWindow(String windowName) {
        this.setMainWindow(this.getWindow(windowName));
    }

    public void gotoWindow(int windowID) {
        this.setMainWindow((WebWindow)this.wc.getWebWindows().get(windowID));
    }

    public int getWindowCount() {
        return this.wc.getWebWindows().size();
    }

    public void gotoWindowByTitle(String title) {
        WebWindow window = this.getWindowByTitle(title);
        if (window != null) {
            this.setMainWindow(window);
        }
    }

    public void closeWindow() {
        if (this.win != null) {
            this.wc.deregisterWebWindow(this.win);
            this.win = this.wc.getCurrentWindow();
            this.form = null;
        }
    }

    public boolean hasFrame(String frameNameOrId) {
        return this.getFrame(frameNameOrId) != null;
    }

    public void gotoFrame(String frameNameOrId) {
        WebWindow frame = this.getFrame(frameNameOrId);
        if (frame == null) {
            throw new RuntimeException("No frame found in current page with name or id [" + frameNameOrId + "]");
        }
        this.win = frame;
    }

    public void setWorkingForm(int index) {
        this.setWorkingForm(this.getForm(index));
    }

    public void setWorkingForm(String nameOrId, int index) {
        this.setWorkingForm(this.getForm(nameOrId, index));
    }

    public boolean hasForm() {
        return ((HtmlPage)this.win.getEnclosedPage()).getForms().size() > 0;
    }

    public boolean hasForm(String nameOrID) {
        return this.getForm(nameOrID) != null;
    }

    public boolean hasFormParameterNamed(String paramName) {
        if (this.hasFormSelectNamed(paramName)) {
            return true;
        }
        return this.hasFormInputNamed(paramName);
    }

    public String getTextFieldValue(String paramName) {
        LinkedList textFieldElements = new LinkedList();
        if (this.form != null) {
            textFieldElements.addAll(this.getForm().getHtmlElementsByAttribute("input", "type", "text"));
            textFieldElements.addAll(this.getForm().getHtmlElementsByAttribute("input", "type", "password"));
        } else {
            Iterator i = this.getCurrentPage().getForms().iterator();
            while (i.hasNext()) {
                HtmlForm f = (HtmlForm)i.next();
                textFieldElements.addAll(f.getHtmlElementsByAttribute("input", "type", "text"));
                textFieldElements.addAll(f.getHtmlElementsByAttribute("input", "type", "password"));
            }
        }
        Iterator it = textFieldElements.iterator();
        while (it.hasNext()) {
            HtmlInput input = (HtmlInput)it.next();
            if (!paramName.equals(input.getNameAttribute())) continue;
            if (this.form == null) {
                this.form = input.getEnclosingFormOrDie();
            }
            return input.getValueAttribute();
        }
        textFieldElements.clear();
        if (this.form != null) {
            textFieldElements.addAll(this.getForm().getTextAreasByName(paramName));
        } else {
            Iterator i = this.getCurrentPage().getForms().iterator();
            while (i.hasNext()) {
                HtmlForm f = (HtmlForm)i.next();
                textFieldElements.addAll(f.getTextAreasByName(paramName));
            }
        }
        it = textFieldElements.iterator();
        while (it.hasNext()) {
            HtmlTextArea textInput = (HtmlTextArea)it.next();
            if (!paramName.equals(textInput.getNameAttribute())) continue;
            if (this.form == null) {
                this.form = textInput.getEnclosingFormOrDie();
            }
            return textInput.getText();
        }
        throw new RuntimeException("getTextFieldParameterValue failed, text field with name [" + paramName + "] does not exist.");
    }

    public String getHiddenFieldValue(String paramName) {
        LinkedList hiddenFieldElements = new LinkedList();
        if (this.form != null) {
            hiddenFieldElements.addAll(this.getForm().getHtmlElementsByAttribute("input", "type", "hidden"));
        } else {
            Iterator i = this.getCurrentPage().getForms().iterator();
            while (i.hasNext()) {
                HtmlForm f = (HtmlForm)i.next();
                hiddenFieldElements.addAll(f.getHtmlElementsByAttribute("input", "type", "hidden"));
            }
        }
        Iterator it = hiddenFieldElements.iterator();
        while (it.hasNext()) {
            HtmlHiddenInput hiddenInput = (HtmlHiddenInput)it.next();
            if (!paramName.equals(hiddenInput.getNameAttribute())) continue;
            if (this.form == null) {
                this.form = hiddenInput.getEnclosingFormOrDie();
            }
            return hiddenInput.getValueAttribute();
        }
        throw new RuntimeException("getHiddenFieldParameterValue failed, hidden field with name [" + paramName + "] does not exist.");
    }

    public void setTextField(String fieldName, String text) {
        Iterator i;
        LinkedList textFieldElements = new LinkedList();
        if (this.form != null) {
            textFieldElements.addAll(this.getForm().getHtmlElementsByAttribute("input", "name", fieldName));
            textFieldElements.addAll(this.getForm().getTextAreasByName(fieldName));
        } else {
            i = this.getCurrentPage().getForms().iterator();
            while (i.hasNext()) {
                HtmlForm f = (HtmlForm)i.next();
                textFieldElements.addAll(f.getHtmlElementsByAttribute("input", "name", fieldName));
                textFieldElements.addAll(f.getTextAreasByName(fieldName));
            }
        }
        i = textFieldElements.iterator();
        while (i.hasNext()) {
            HtmlElement e = (HtmlElement)i.next();
            if (e instanceof HtmlTextInput) {
                ((HtmlTextInput)e).setValueAttribute(text);
                if (this.form == null) {
                    this.form = e.getEnclosingFormOrDie();
                }
                return;
            }
            if (e instanceof HtmlPasswordInput) {
                ((HtmlPasswordInput)e).setValueAttribute(text);
                if (this.form == null) {
                    this.form = e.getEnclosingFormOrDie();
                }
                return;
            }
            if (e instanceof HtmlFileInput) {
                ((HtmlFileInput)e).setValueAttribute(text);
                if (this.form == null) {
                    this.form = e.getEnclosingFormOrDie();
                }
                return;
            }
            if (!(e instanceof HtmlTextArea)) continue;
            ((HtmlTextArea)e).setText(text);
            if (this.form == null) {
                this.form = e.getEnclosingFormOrDie();
            }
            return;
        }
        throw new RuntimeException("No text field with name [" + fieldName + "] was found.");
    }

    public String[] getSelectOptionValues(String selectName) {
        HtmlSelect sel = this.getForm().getSelectByName(selectName);
        ArrayList<String> result = new ArrayList<String>();
        List opts = sel.getOptions();
        for (int i = 0; i < opts.size(); ++i) {
            HtmlOption opt = (HtmlOption)opts.get(i);
            result.add(opt.getValueAttribute());
        }
        return result.toArray(new String[0]);
    }

    public String[] getSelectedOptions(String selectName) {
        HtmlSelect sel = this.getForm().getSelectByName(selectName);
        List opts = sel.getSelectedOptions();
        String[] result = new String[opts.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((HtmlOption)opts.get(i)).getValueAttribute();
        }
        return result;
    }

    public String getSelectOptionValueForLabel(String selectName, String label) {
        HtmlSelect sel = this.getForm().getSelectByName(selectName);
        List opts = sel.getOptions();
        for (int i = 0; i < opts.size(); ++i) {
            HtmlOption opt = (HtmlOption)opts.get(i);
            if (!opt.asText().equals(label)) continue;
            return opt.getValueAttribute();
        }
        throw new RuntimeException("Unable to find option " + label + " for " + selectName);
    }

    public String getSelectOptionLabelForValue(String selectName, String value) {
        HtmlSelect sel = this.getForm().getSelectByName(selectName);
        List opts = sel.getOptions();
        for (int i = 0; i < opts.size(); ++i) {
            HtmlOption opt = (HtmlOption)opts.get(i);
            if (!opt.getValueAttribute().equals(value)) continue;
            return opt.asText();
        }
        throw new RuntimeException("Unable to find option " + value + " for " + selectName);
    }

    public URL getPageURL() {
        return this.win.getEnclosedPage().getWebResponse().getUrl();
    }

    public String getPageSource() {
        return this.win.getEnclosedPage().getWebResponse().getContentAsString();
    }

    public String getPageTitle() {
        return this.getCurrentPageTitle();
    }

    public String getPageText() {
        Page page = this.win.getEnclosedPage();
        if (page instanceof HtmlPage) {
            return ((HtmlPage)page).asText();
        }
        if (page instanceof TextPage) {
            return ((TextPage)page).getContent();
        }
        if (page instanceof JavaScriptPage) {
            return ((JavaScriptPage)page).getContent();
        }
        if (page instanceof XmlPage) {
            return ((XmlPage)page).getContent();
        }
        if (page instanceof UnexpectedPage) {
            return ((UnexpectedPage)page).getWebResponse().getContentAsString();
        }
        throw new RuntimeException("Unexpected error in getPageText(). This method need to be updated.");
    }

    public String getServerResponse() {
        StringBuffer result = new StringBuffer();
        WebResponse wr = this.wc.getCurrentWindow().getEnclosedPage().getWebResponse();
        result.append(wr.getStatusCode()).append(" ").append(wr.getStatusMessage()).append("\n");
        result.append("Location: ").append(wr.getUrl()).append("\n");
        List headers = wr.getResponseHeaders();
        Iterator i = headers.iterator();
        while (i.hasNext()) {
            NameValuePair h = (NameValuePair)i.next();
            result.append(h.getName()).append(": ").append(h.getValue()).append("\n");
        }
        result.append("\n");
        result.append(wr.getContentAsString());
        return result.toString();
    }

    public InputStream getInputStream() {
        try {
            return this.wc.getCurrentWindow().getEnclosedPage().getWebResponse().getContentAsStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream(URL resourceUrl) throws TestingEngineResponseException {
        WebWindow imageWindow = null;
        try {
            imageWindow = this.wc.openWindow(resourceUrl, "for_stream");
            Page page = imageWindow.getEnclosedPage();
            InputStream inputStream = page.getWebResponse().getContentAsStream();
            return inputStream;
        }
        catch (FailingHttpStatusCodeException aException) {
            throw new TestingEngineResponseException(aException.getStatusCode(), (Exception)((Object)aException));
        }
        catch (IOException aException) {
            throw new RuntimeException(aException);
        }
        finally {
            if (imageWindow != null) {
                this.wc.deregisterWebWindow(imageWindow);
            }
        }
    }

    private void initWebClient() {
        BrowserVersion bv = new BrowserVersion("Microsoft Internet Explorer", "4.0", this.testContext.getUserAgent(), "1.2", 6.0f);
        this.wc = this.getTestContext().getProxyHost() != null && this.getTestContext().getProxyPort() > 0 ? new WebClient(bv, this.getTestContext().getProxyHost(), this.getTestContext().getProxyPort()) : new WebClient(bv);
        this.wc.setJavaScriptEnabled(this.jsEnabled);
        this.wc.setThrowExceptionOnScriptError(true);
        this.wc.setRedirectEnabled(true);
        this.wc.setRefreshHandler((RefreshHandler)new ImmediateRefreshHandler());
        DefaultCredentialsProvider creds = new DefaultCredentialsProvider();
        if (this.getTestContext().hasAuthorization()) {
            creds.addCredentials(this.getTestContext().getUser(), this.getTestContext().getPassword());
        }
        if (this.getTestContext().hasNTLMAuthorization()) {
            String address;
            try {
                InetAddress netAddress = InetAddress.getLocalHost();
                address = netAddress.getHostName();
            }
            catch (UnknownHostException e) {
                address = "";
            }
            creds.addNTLMCredentials(this.getTestContext().getUser(), this.getTestContext().getPassword(), "", -1, address, this.getTestContext().getDomain());
        }
        if (this.getTestContext().hasProxyAuthorization()) {
            creds.addProxyCredentials(this.getTestContext().getProxyUser(), this.getTestContext().getPassword(), this.getTestContext().getProxyHost(), this.getTestContext().getProxyPort());
        }
        this.wc.setCredentialsProvider((CredentialsProvider)creds);
        this.wc.addWebWindowListener(new WebWindowListener(){

            public void webWindowClosed(WebWindowEvent event) {
                if (event.getOldPage().equals(HtmlUnitDialog.this.win.getEnclosedPage())) {
                    HtmlUnitDialog.this.win = HtmlUnitDialog.this.wc.getCurrentWindow();
                    HtmlUnitDialog.this.form = null;
                }
                String win = event.getWebWindow().getName();
                Page oldPage = event.getOldPage();
                String oldPageTitle = "no_html";
                if (oldPage instanceof HtmlPage) {
                    oldPageTitle = ((HtmlPage)oldPage).getTitleText();
                }
                LOGGER.info((Object)("Window " + win + " closed : " + oldPageTitle));
            }

            public void webWindowContentChanged(WebWindowEvent event) {
                HtmlUnitDialog.this.form = null;
                String winName = event.getWebWindow().getName();
                Page oldPage = event.getOldPage();
                Page newPage = event.getNewPage();
                String oldPageTitle = "no_html";
                if (oldPage instanceof HtmlPage) {
                    oldPageTitle = ((HtmlPage)oldPage).getTitleText();
                }
                String newPageTitle = "no_html";
                if (newPage instanceof HtmlPage) {
                    newPageTitle = ((HtmlPage)newPage).getTitleText();
                }
                LOGGER.info((Object)("Window \"" + winName + "\" changed : \"" + oldPageTitle + "\" became \"" + newPageTitle + "\""));
            }

            public void webWindowOpened(WebWindowEvent event) {
                String win = event.getWebWindow().getName();
                Page newPage = event.getNewPage();
                if (newPage != null && newPage instanceof HtmlPage) {
                    LOGGER.info((Object)("Window " + win + " openend : " + ((HtmlPage)newPage).getTitleText()));
                } else {
                    LOGGER.info((Object)("Window " + win + " openend"));
                }
            }
        });
        this.wc.setAlertHandler(new AlertHandler(){

            public void handleAlert(Page page, String msg) {
                if (HtmlUnitDialog.this.expectedJavascriptAlerts.size() < 1) {
                    throw new UnexpectedJavascriptAlertException(msg);
                }
                JavascriptAlert expected = (JavascriptAlert)HtmlUnitDialog.this.expectedJavascriptAlerts.removeFirst();
                if (!msg.equals(expected.getMessage())) {
                    throw new UnexpectedJavascriptAlertException(msg);
                }
            }
        });
        this.wc.setConfirmHandler(new ConfirmHandler(){

            public boolean handleConfirm(Page page, String msg) {
                if (HtmlUnitDialog.this.expectedJavascriptConfirms.size() < 1) {
                    throw new UnexpectedJavascriptConfirmException(msg);
                }
                JavascriptConfirm expected = (JavascriptConfirm)HtmlUnitDialog.this.expectedJavascriptConfirms.removeFirst();
                if (!msg.equals(expected.getMessage())) {
                    throw new UnexpectedJavascriptConfirmException(msg);
                }
                return expected.getAction();
            }
        });
        this.wc.setPromptHandler(new PromptHandler(){

            public String handlePrompt(Page page, String msg) {
                if (HtmlUnitDialog.this.expectedJavascriptPrompts.size() < 1) {
                    throw new UnexpectedJavascriptPromptException(msg);
                }
                JavascriptPrompt expected = (JavascriptPrompt)HtmlUnitDialog.this.expectedJavascriptPrompts.removeFirst();
                if (!msg.equals(expected.getMessage())) {
                    throw new UnexpectedJavascriptPromptException(msg);
                }
                return expected.getInput();
            }
        });
        Iterator i = this.getTestContext().getCookies().iterator();
        while (i.hasNext()) {
            javax.servlet.http.Cookie c = (javax.servlet.http.Cookie)i.next();
            this.wc.getWebConnection().getState().addCookie(new Cookie(c.getDomain() != null ? c.getDomain() : "", c.getName(), c.getValue(), c.getPath() != null ? c.getPath() : "", c.getMaxAge(), c.getSecure()));
        }
        Map requestHeaders = this.getTestContext().getRequestHeaders();
        Set keys = requestHeaders.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String nextRequestHeaderName = (String)it.next();
            String nextRequestHeaderValue = (String)requestHeaders.get(nextRequestHeaderName);
            this.wc.addRequestHeader(nextRequestHeaderName, nextRequestHeaderValue);
        }
    }

    private WebWindow getWindow(String windowName) {
        return this.wc.getWebWindowByName(windowName);
    }

    private HtmlElement getElement(String anID) {
        try {
            return ((HtmlPage)this.win.getEnclosedPage()).getHtmlElementById(anID);
        }
        catch (ElementNotFoundException e) {
            return null;
        }
    }

    private HtmlElement getElementByXPath(String xpath) {
        return this.getElementByXPath(this.getCurrentPage(), xpath);
    }

    private HtmlElement getElementByXPath(Object parent, String xpath) {
        List l = null;
        try {
            HtmlUnitXPath xp = new HtmlUnitXPath(xpath);
            l = xp.selectNodes(parent);
        }
        catch (JaxenException e) {
            return null;
        }
        return l.size() > 0 ? l.get(0) : null;
    }

    private WebWindow getWindowByTitle(String title) {
        List webWindows = this.wc.getWebWindows();
        for (int i = 0; i < webWindows.size(); ++i) {
            WebWindow window = (WebWindow)webWindows.get(i);
            if (!(window.getEnclosedPage() instanceof HtmlPage) || !((HtmlPage)window.getEnclosedPage()).getTitleText().equals(title)) continue;
            return window;
        }
        return null;
    }

    public String getCurrentPageTitle() {
        if (this.win.getEnclosedPage() instanceof HtmlPage) {
            return ((HtmlPage)this.win.getEnclosedPage()).getTitleText();
        }
        return "";
    }

    private HtmlForm getForm() {
        if (this.form == null) {
            if (this.hasForm()) {
                this.setWorkingForm(this.getForm(0));
                return this.getForm(0);
            }
            throw new RuntimeException("No form in current page");
        }
        return this.form;
    }

    private HtmlForm getForm(int formIndex) {
        return (HtmlForm)((HtmlPage)this.win.getEnclosedPage()).getForms().get(formIndex);
    }

    private HtmlForm getForm(String nameOrID) {
        try {
            return (HtmlForm)((HtmlPage)this.win.getEnclosedPage()).getHtmlElementById(nameOrID);
        }
        catch (ElementNotFoundException e) {
            try {
                return ((HtmlPage)this.win.getEnclosedPage()).getFormByName(nameOrID);
            }
            catch (ElementNotFoundException elementNotFoundException) {
                return null;
            }
        }
    }

    private HtmlForm getForm(String nameOrID, int index) {
        HtmlForm form = null;
        Iterator iter = this.getCurrentPage().getForms().iterator();
        int pos = 0;
        while (pos <= index && iter.hasNext()) {
            HtmlForm curr = (HtmlForm)iter.next();
            if (!nameOrID.equals(curr.getIdAttribute()) && !nameOrID.equals(curr.getNameAttribute())) continue;
            ++pos;
            form = curr;
        }
        return form;
    }

    private HtmlForm getFormWithInput(String inputName) {
        if (this.form != null) {
            if (!this.form.getHtmlElementsByAttribute("input", "name", inputName).isEmpty()) {
                return this.form;
            }
            if (!this.form.getTextAreasByName(inputName).isEmpty()) {
                return this.form;
            }
        } else if (this.hasForm()) {
            for (int i = 0; i < this.getForms().size(); ++i) {
                HtmlForm form = (HtmlForm)this.getForms().get(i);
                List inputElements = form.getHtmlElementsByAttribute("input", "name", inputName);
                if (inputElements.isEmpty()) {
                    inputElements = form.getTextAreasByName(inputName);
                }
                if (inputElements.isEmpty()) continue;
                this.setWorkingForm(form);
                return form;
            }
        }
        return null;
    }

    private HtmlForm getFormWithSelect(String selectName) {
        if (this.form != null) {
            try {
                if (this.form.getSelectByName(selectName) != null) {
                    return this.form;
                }
            }
            catch (ElementNotFoundException e) {}
        } else if (this.hasForm()) {
            for (int i = 0; i < this.getForms().size(); ++i) {
                HtmlForm form = (HtmlForm)this.getForms().get(i);
                try {
                    if (form.getSelectByName(selectName) != null) {
                        this.setWorkingForm(form);
                        return form;
                    }
                    continue;
                }
                catch (ElementNotFoundException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private List getForms() {
        HtmlPage page = (HtmlPage)this.win.getEnclosedPage();
        return page.getForms();
    }

    private HtmlPage getCurrentPage() {
        Page page = this.win.getEnclosedPage();
        if (page instanceof HtmlPage) {
            return (HtmlPage)page;
        }
        throw new RuntimeException("Non HTML content");
    }

    private void setWorkingForm(HtmlForm newForm) {
        if (newForm == null) {
            throw new UnableToSetFormException("Attempted to set form to null.");
        }
        this.form = newForm;
    }

    public boolean hasFormInputNamed(String inputName) {
        return this.getFormWithInput(inputName) != null;
    }

    public boolean hasFormSelectNamed(String selectName) {
        return this.getFormWithSelect(selectName) != null;
    }

    public ClickableElement getSubmitButton(String buttonName) {
        Iterator i;
        LinkedList btns = new LinkedList();
        if (this.form != null) {
            btns.addAll(this.getForm().getInputsByName(buttonName));
        } else {
            i = this.getCurrentPage().getForms().iterator();
            while (i.hasNext()) {
                HtmlForm f = (HtmlForm)i.next();
                btns.addAll(f.getInputsByName(buttonName));
            }
        }
        i = btns.iterator();
        while (i.hasNext()) {
            HtmlSubmitInput btn;
            Object o = i.next();
            if (o instanceof HtmlSubmitInput) {
                btn = (HtmlSubmitInput)o;
                if (this.form == null) {
                    this.form = btn.getEnclosingFormOrDie();
                }
                return btn;
            }
            if (o instanceof HtmlImageInput) {
                btn = (HtmlImageInput)o;
                if (this.form == null) {
                    this.form = btn.getEnclosingFormOrDie();
                }
                return btn;
            }
            if (!(o instanceof HtmlButton) || !(btn = (HtmlButton)o).getTypeAttribute().equals("submit")) continue;
            if (this.form == null) {
                this.form = btn.getEnclosingFormOrDie();
            }
            return btn;
        }
        return null;
    }

    public HtmlResetInput getResetButton(String buttonName) {
        Iterator i;
        LinkedList btns = new LinkedList();
        if (this.form != null) {
            btns.addAll(this.getForm().getInputsByName(buttonName));
        } else {
            i = this.getCurrentPage().getForms().iterator();
            while (i.hasNext()) {
                HtmlForm f = (HtmlForm)i.next();
                btns.addAll(f.getInputsByName(buttonName));
            }
        }
        i = btns.iterator();
        while (i.hasNext()) {
            HtmlResetInput btn;
            Object o = i.next();
            if (o instanceof HtmlResetInput) {
                btn = (HtmlResetInput)o;
                if (this.form == null) {
                    this.form = btn.getEnclosingFormOrDie();
                }
                return btn;
            }
            if (!(o instanceof HtmlButton) || !(btn = (HtmlResetInput)o).getTypeAttribute().equals("reset")) continue;
            if (this.form == null) {
                this.form = btn.getEnclosingFormOrDie();
            }
            return btn;
        }
        return null;
    }

    public ClickableElement getSubmitButton(String buttonName, String buttonValue) {
        Iterator i;
        LinkedList btns = new LinkedList();
        if (this.form != null) {
            btns.addAll(this.getForm().getInputsByName(buttonName));
        } else {
            i = this.getCurrentPage().getForms().iterator();
            while (i.hasNext()) {
                HtmlForm f = (HtmlForm)i.next();
                btns.addAll(f.getInputsByName(buttonName));
            }
        }
        i = btns.iterator();
        while (i.hasNext()) {
            HtmlSubmitInput btn;
            Object o = i.next();
            if (o instanceof HtmlSubmitInput && (btn = (HtmlSubmitInput)o).getValueAttribute().equals(buttonValue)) {
                if (this.form == null) {
                    this.form = btn.getEnclosingFormOrDie();
                }
                return btn;
            }
            if (o instanceof HtmlImageInput && (btn = (HtmlImageInput)o).getValueAttribute().equals(buttonValue)) {
                if (this.form == null) {
                    this.form = btn.getEnclosingFormOrDie();
                }
                return btn;
            }
            if (!(o instanceof HtmlButton) || !(btn = (HtmlButton)o).getValueAttribute().equals(buttonValue) || !btn.getTypeAttribute().equals("submit")) continue;
            if (this.form == null) {
                this.form = btn.getEnclosingFormOrDie();
            }
            return btn;
        }
        return null;
    }

    public boolean hasSubmitButton() {
        List l = null;
        try {
            HtmlUnitXPath xp = new HtmlUnitXPath("//input[@type='submit' or @type='image']");
            l = xp.selectNodes((Object)this.getForm());
        }
        catch (JaxenException e) {
            throw new RuntimeException(e);
        }
        List l2 = null;
        try {
            HtmlUnitXPath xp = new HtmlUnitXPath("//button[@type='submit']");
            l2 = xp.selectNodes((Object)this.getForm());
        }
        catch (JaxenException e) {
            throw new RuntimeException(e);
        }
        return l.size() > 0 || l2.size() > 0;
    }

    public boolean hasSubmitButton(String buttonName) {
        return this.getSubmitButton(buttonName) != null;
    }

    public boolean hasSubmitButton(String buttonName, String buttonValue) {
        try {
            return this.getSubmitButton(buttonName, buttonValue) != null;
        }
        catch (UnableToSetFormException e) {
            return false;
        }
    }

    public boolean hasResetButton() {
        List l = null;
        try {
            HtmlUnitXPath xp = new HtmlUnitXPath("//input[@type='reset']");
            l = xp.selectNodes((Object)this.getForm());
        }
        catch (JaxenException e) {
            throw new RuntimeException(e);
        }
        List l2 = null;
        try {
            HtmlUnitXPath xp = new HtmlUnitXPath("//button[@type='reset']");
            l2 = xp.selectNodes((Object)this.getForm());
        }
        catch (JaxenException e) {
            throw new RuntimeException(e);
        }
        return l.size() > 0 || l2.size() > 0;
    }

    public boolean hasResetButton(String buttonName) {
        return this.getResetButton(buttonName) != null;
    }

    private ClickableElement getButton(String buttonId) {
        HtmlElement btn = null;
        try {
            btn = this.getCurrentPage().getHtmlElementById(buttonId);
            if (btn instanceof HtmlButton || btn instanceof HtmlButtonInput || btn instanceof HtmlSubmitInput || btn instanceof HtmlResetInput) {
                return (ClickableElement)btn;
            }
        }
        catch (ElementNotFoundException e) {
            return null;
        }
        return null;
    }

    public boolean hasButtonWithText(String text) {
        boolean bReturn = this.getButtonWithText(text) != null;
        return bReturn;
    }

    public HtmlButton getButtonWithText(String buttonValueText) {
        List l = ((HtmlPage)this.win.getEnclosedPage()).getDocumentElement().getHtmlElementsByTagNames(Arrays.asList("button"));
        for (int i = 0; i < l.size(); ++i) {
            HtmlElement e = (HtmlElement)l.get(i);
            if (!((HtmlButton)e).asText().equals(buttonValueText)) continue;
            return (HtmlButton)e;
        }
        return null;
    }

    public boolean hasButton(String buttonId) {
        try {
            return this.getButton(buttonId) != null;
        }
        catch (UnableToSetFormException e) {
            return false;
        }
    }

    public boolean isCheckboxSelected(String checkBoxName) {
        HtmlCheckBoxInput cb = this.getCheckbox(checkBoxName);
        return cb.isChecked();
    }

    public boolean isCheckboxSelected(String checkBoxName, String checkBoxValue) {
        HtmlCheckBoxInput cb = this.getCheckbox(checkBoxName, checkBoxValue);
        return cb.isChecked();
    }

    public boolean isTextInTable(String tableSummaryOrId, String text) {
        HtmlTable table = this.getHtmlTable(tableSummaryOrId);
        if (table == null) {
            throw new RuntimeException("No table with summary or id [" + tableSummaryOrId + "] found in response.");
        }
        for (int row = 0; row < table.getRowCount(); ++row) {
            int col = 0;
            while (table.getCellAt(row, col) != null) {
                String cellHtml;
                HtmlTableCell cell = table.getCellAt(row, col);
                if (cell != null && (cellHtml = cell.asText()).indexOf(text) != -1) {
                    return true;
                }
                ++col;
            }
        }
        return false;
    }

    public Table getTable(String tableSummaryOrId) {
        HtmlTable table = this.getHtmlTable(tableSummaryOrId);
        Table result = new Table();
        for (int i = 0; i < table.getRowCount(); ++i) {
            Row newRow = new Row();
            HtmlTableRow htmlRow = table.getRow(i);
            HtmlTableRow.CellIterator cellIt = htmlRow.getCellIterator();
            while (cellIt.hasNext()) {
                HtmlTableCell htmlCell = cellIt.nextCell();
                newRow.appendCell(new Cell(htmlCell.asText(), htmlCell.getColumnSpan(), htmlCell.getRowSpan()));
            }
            result.appendRow(newRow);
        }
        return result;
    }

    public HtmlTable getHtmlTable(String tableSummaryOrId) {
        try {
            return (HtmlTable)((HtmlPage)this.win.getEnclosedPage()).getHtmlElementById(tableSummaryOrId);
        }
        catch (ElementNotFoundException e) {
            try {
                return (HtmlTable)((HtmlPage)this.win.getEnclosedPage()).getDocumentElement().getOneHtmlElementByAttribute("table", "summary", tableSummaryOrId);
            }
            catch (ElementNotFoundException elementNotFoundException) {
                return null;
            }
        }
    }

    public boolean hasTable(String tableSummaryOrId) {
        HtmlTable table = this.getHtmlTable(tableSummaryOrId);
        return table != null;
    }

    public void submit() {
        try {
            Object[] inpt = this.getForm().getHtmlElementsByTagName("input").toArray();
            for (int i = 0; i < inpt.length; ++i) {
                if (inpt[i] instanceof HtmlSubmitInput) {
                    ((HtmlSubmitInput)inpt[i]).click();
                    return;
                }
                if (inpt[i] instanceof HtmlImageInput) {
                    ((HtmlImageInput)inpt[i]).click();
                    return;
                }
                if (!(inpt[i] instanceof HtmlButton) || !((HtmlButton)inpt[i]).getTypeAttribute().equals("submit")) continue;
                ((HtmlButton)inpt[i]).click();
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("HtmlUnit Error submitting form using default submit button, check that form has single submit button, otherwise use submit(name): \n", e);
        }
        throw new RuntimeException("No submit button found in current form.");
    }

    public void submit(String buttonName) {
        List l = this.getForm().getInputsByName(buttonName);
        try {
            for (int i = 0; i < l.size(); ++i) {
                HtmlSubmitInput inpt;
                Object o = l.get(i);
                if (o instanceof HtmlSubmitInput) {
                    inpt = (HtmlSubmitInput)o;
                    inpt.click();
                    return;
                }
                if (o instanceof HtmlImageInput) {
                    inpt = (HtmlImageInput)o;
                    inpt.click();
                    return;
                }
                if (!(o instanceof HtmlButton) || !(inpt = (HtmlButton)o).getTypeAttribute().equals("submit")) continue;
                inpt.click();
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("HtmlUnit Error submitting form using default submit button", e);
        }
        throw new RuntimeException("No submit button found in current form.");
    }

    public void submit(String buttonName, String buttonValue) {
        List l = this.getForm().getInputsByName(buttonName);
        try {
            for (int i = 0; i < l.size(); ++i) {
                HtmlSubmitInput inpt;
                Object o = l.get(i);
                if (o instanceof HtmlSubmitInput && (inpt = (HtmlSubmitInput)o).getValueAttribute().equals(buttonValue)) {
                    inpt.click();
                    return;
                }
                if (o instanceof HtmlImageInput && (inpt = (HtmlImageInput)o).getValueAttribute().equals(buttonValue)) {
                    inpt.click();
                    return;
                }
                if (!(o instanceof HtmlButton) || !(inpt = (HtmlButton)o).getTypeAttribute().equals("submit") || !inpt.getValueAttribute().equals(buttonValue)) continue;
                inpt.click();
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("HtmlUnit Error submitting form using submit button with name [" + buttonName + "] and value [" + buttonValue + "]", e);
        }
        throw new RuntimeException("No submit button found in current form with name [" + buttonName + "] and value [" + buttonValue + "].");
    }

    public void reset() {
        this.getForm().reset();
    }

    public boolean hasLinkWithText(String linkText, int index) {
        return this.getLinkWithText(linkText, index) != null;
    }

    public boolean hasLinkWithExactText(String linkText, int index) {
        return this.getLinkWithExactText(linkText, index) != null;
    }

    public boolean hasLinkWithImage(String imageFileName, int index) {
        return this.getLinkWithImage(imageFileName, index) != null;
    }

    public boolean hasLink(String anId) {
        try {
            ((HtmlPage)this.win.getEnclosedPage()).getHtmlElementById(anId);
        }
        catch (ElementNotFoundException e) {
            return false;
        }
        return true;
    }

    public void clickLinkWithText(String linkText, int index) {
        HtmlAnchor link = this.getLinkWithText(linkText, index);
        if (link == null) {
            throw new RuntimeException("No Link found for \"" + linkText + "\" with index " + index);
        }
        try {
            link.click();
        }
        catch (IOException e) {
            throw new RuntimeException("Click failed", e);
        }
    }

    public void clickLinkWithExactText(String linkText, int index) {
        HtmlAnchor link = this.getLinkWithExactText(linkText, index);
        if (link == null) {
            throw new RuntimeException("No Link found for \"" + linkText + "\" with index " + index);
        }
        try {
            link.click();
        }
        catch (IOException e) {
            throw new RuntimeException("Click failed", e);
        }
    }

    private HtmlCheckBoxInput getCheckbox(String checkBoxName) {
        Object[] l = this.getForm().getInputsByName(checkBoxName).toArray();
        for (int i = 0; i < l.length; ++i) {
            if (!(l[i] instanceof HtmlCheckBoxInput)) continue;
            return (HtmlCheckBoxInput)l[i];
        }
        throw new RuntimeException("No checkbox with name [" + checkBoxName + "] was found in current form.");
    }

    private HtmlCheckBoxInput getCheckbox(String checkBoxName, String value) {
        Object[] l = this.getForm().getInputsByName(checkBoxName).toArray();
        for (int i = 0; i < l.length; ++i) {
            if (!(l[i] instanceof HtmlCheckBoxInput) || !((HtmlCheckBoxInput)l[i]).getValueAttribute().equals(value)) continue;
            return (HtmlCheckBoxInput)l[i];
        }
        throw new RuntimeException("No checkbox with name [" + checkBoxName + "] and value [" + value + "] was found in current form.");
    }

    public void checkCheckbox(String checkBoxName) {
        HtmlCheckBoxInput cb = this.getCheckbox(checkBoxName);
        if (!cb.isChecked()) {
            try {
                cb.click();
            }
            catch (IOException e) {
                throw new RuntimeException("checkCheckbox failed", e);
            }
        }
    }

    public void checkCheckbox(String checkBoxName, String value) {
        HtmlCheckBoxInput cb = this.getCheckbox(checkBoxName, value);
        if (!cb.isChecked()) {
            try {
                cb.click();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("checkCheckbox failed", e);
            }
        }
    }

    public void uncheckCheckbox(String checkBoxName) {
        HtmlCheckBoxInput cb = this.getCheckbox(checkBoxName);
        if (cb.isChecked()) {
            try {
                cb.click();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("checkCheckbox failed", e);
            }
        }
    }

    public void uncheckCheckbox(String checkBoxName, String value) {
        HtmlCheckBoxInput cb = this.getCheckbox(checkBoxName, value);
        if (cb.isChecked()) {
            try {
                cb.click();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("uncheckCheckbox failed", e);
            }
        }
    }

    public void clickRadioOption(String radioGroup, String radioOption) {
        HtmlRadioButtonInput rb = this.getForm().getRadioButtonInput(radioGroup, radioOption);
        if (!rb.isChecked()) {
            try {
                rb.click();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("checkCheckbox failed", e);
            }
        }
    }

    public void clickLink(String anID) {
        this.clickElementByXPath("//a[@id=\"" + anID + "\"]");
    }

    private HtmlAnchor getLinkWithImage(String filename, int index) {
        return (HtmlAnchor)this.getElementByXPath("(//a[img[contains(@src,\"" + filename + "\")]])[" + index + 1 + "]");
    }

    private HtmlAnchor getLinkWithText(String linkText, int index) {
        List lnks = ((HtmlPage)this.win.getEnclosedPage()).getAnchors();
        int count = 0;
        for (int i = 0; i < lnks.size(); ++i) {
            HtmlAnchor lnk = (HtmlAnchor)lnks.get(i);
            if (lnk.asText().indexOf(linkText) < 0 || count++ != index) continue;
            return lnk;
        }
        return null;
    }

    private HtmlAnchor getLinkWithExactText(String linkText, int index) {
        List lnks = ((HtmlPage)this.win.getEnclosedPage()).getAnchors();
        int count = 0;
        for (int i = 0; i < lnks.size(); ++i) {
            HtmlAnchor lnk = (HtmlAnchor)lnks.get(i);
            if (!lnk.asText().equals(linkText) || count++ != index) continue;
            return lnk;
        }
        return null;
    }

    public void clickLinkWithImage(String imageFileName, int index) {
        HtmlAnchor link = this.getLinkWithImage(imageFileName, index);
        if (link == null) {
            throw new RuntimeException("No Link found with filename \"" + imageFileName + "\" and index " + index);
        }
        try {
            link.click();
        }
        catch (IOException e) {
            throw new RuntimeException("Click failed", e);
        }
    }

    public boolean hasElement(String anID) {
        return this.getElement(anID) != null;
    }

    public boolean hasElementByXPath(String xpath) {
        return this.getElementByXPath(xpath) != null;
    }

    public void clickElementByXPath(String xpath) {
        HtmlElement e = this.getElementByXPath(xpath);
        if (e == null) {
            throw new RuntimeException("No element found with xpath \"" + xpath + "\"");
        }
        try {
            ClickableElement c = (ClickableElement)e;
            c.click();
        }
        catch (ClassCastException exp) {
            throw new RuntimeException("Element with xpath \"" + xpath + "\" is not clickable", exp);
        }
        catch (IOException exp) {
            throw new RuntimeException("Click failed", exp);
        }
    }

    public String getElementAttributByXPath(String xpath, String attribut) {
        HtmlElement e = this.getElementByXPath(xpath);
        if (e == null) {
            return null;
        }
        return e.getAttributeValue(attribut);
    }

    public String getElementTextByXPath(String xpath) {
        HtmlElement e = this.getElementByXPath(xpath);
        if (e == null) {
            return null;
        }
        return e.asText();
    }

    public void clickButton(String buttonId) {
        ClickableElement btn = this.getButton(buttonId);
        try {
            btn.click();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void clickButtonWithText(String buttonValueText) {
        try {
            if (this.hasButtonWithText(buttonValueText)) {
                this.getButtonWithText(buttonValueText).click();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasRadioOption(String radioGroup, String radioOption) {
        List forms = this.getForms();
        for (int i = 0; i < forms.size(); ++i) {
            HtmlForm form = (HtmlForm)forms.get(i);
            try {
                form.getRadioButtonInput(radioGroup, radioOption);
                return true;
            }
            catch (ElementNotFoundException e) {
                continue;
            }
        }
        return false;
    }

    public String getSelectedRadio(String radioGroup) {
        List radios = this.getForm().getRadioButtonsByName(radioGroup);
        Iterator i = radios.iterator();
        while (i.hasNext()) {
            HtmlRadioButtonInput radio = (HtmlRadioButtonInput)i.next();
            if (!radio.isChecked()) continue;
            return radio.getValueAttribute();
        }
        throw new RuntimeException("Unexpected state: no radio button was selected in radio group [" + radioGroup + "]. Is it possible in a real browser?");
    }

    public boolean hasSelectOption(String selectName, String optionLabel) {
        String[] opts = this.getSelectOptionValues(selectName);
        for (int i = 0; i < opts.length; ++i) {
            String label = this.getSelectOptionLabelForValue(selectName, opts[i]);
            if (!label.equals(optionLabel)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelectOptionValue(String selectName, String optionValue) {
        String[] opts = this.getSelectOptionValues(selectName);
        for (int i = 0; i < opts.length; ++i) {
            if (!opts[i].equals(optionValue)) continue;
            return true;
        }
        return false;
    }

    public void selectOptions(String selectName, String[] options) {
        HtmlSelect sel = this.getForm().getSelectByName(selectName);
        if (!sel.isMultipleSelectEnabled() && options.length > 1) {
            throw new RuntimeException("Multiselect not enabled");
        }
        List l = sel.getOptions();
        for (int j = 0; j < options.length; ++j) {
            boolean found = false;
            for (int i = 0; i < l.size(); ++i) {
                HtmlOption opt = (HtmlOption)l.get(i);
                if (!opt.getValueAttribute().equals(options[j])) continue;
                sel.setSelectedAttribute(opt, true);
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("Option " + options[j] + " not found");
        }
    }

    public void unselectOptions(String selectName, String[] options) {
        HtmlSelect sel = this.getForm().getSelectByName(selectName);
        if (!sel.isMultipleSelectEnabled() && options.length > 1) {
            throw new RuntimeException("Multiselect not enabled");
        }
        List l = sel.getOptions();
        for (int j = 0; j < options.length; ++j) {
            boolean found = false;
            for (int i = 0; i < l.size(); ++i) {
                HtmlOption opt = (HtmlOption)l.get(i);
                if (!opt.asText().equals(options[j])) continue;
                sel.setSelectedAttribute(opt, false);
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("Option " + options[j] + " not found");
        }
    }

    public boolean isTextInElement(String elementID, String text) {
        return this.isTextInElement(this.getElement(elementID), text);
    }

    private boolean isTextInElement(HtmlElement element, String text) {
        return element.asText().indexOf(text) >= 0;
    }

    public boolean isMatchInElement(String elementID, String regexp) {
        return this.isMatchInElement(this.getElement(elementID), regexp);
    }

    private boolean isMatchInElement(HtmlElement element, String regexp) {
        RE re = this.getRE(regexp);
        return re.match(element.asText());
    }

    private RE getRE(String regexp) {
        try {
            return new RE(regexp, 4);
        }
        catch (RESyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void gotoRootWindow() {
        this.setMainWindow((WebWindow)this.wc.getWebWindows().get(0));
    }

    private void setMainWindow(WebWindow win) {
        this.wc.setCurrentWindow(win);
        this.win = win;
    }

    private WebWindow getFrame(String frameNameOrId) {
        FrameWindow frame;
        List frames = this.getCurrentPage().getFrames();
        Iterator iter = frames.iterator();
        while (iter.hasNext()) {
            frame = (FrameWindow)iter.next();
            if (!frameNameOrId.equals(frame.getFrameElement().getId())) continue;
            return frame;
        }
        iter = frames.iterator();
        while (iter.hasNext()) {
            frame = (FrameWindow)iter.next();
            if (!frameNameOrId.equals(frame.getName())) continue;
            return frame;
        }
        return null;
    }

    private void setTestContext(TestContext testContext) {
        this.testContext = testContext;
    }

    private TestContext getTestContext() {
        return this.testContext;
    }

    public void setExpectedJavaScriptAlert(JavascriptAlert[] alerts) throws ExpectedJavascriptAlertException {
        if (this.expectedJavascriptAlerts.size() > 0) {
            throw new ExpectedJavascriptAlertException(((JavascriptAlert)this.expectedJavascriptAlerts.get(0)).getMessage());
        }
        for (int i = 0; i < alerts.length; ++i) {
            this.expectedJavascriptAlerts.add(alerts[i]);
        }
    }

    public void setExpectedJavaScriptConfirm(JavascriptConfirm[] confirms) throws ExpectedJavascriptConfirmException {
        if (this.expectedJavascriptConfirms.size() > 0) {
            throw new ExpectedJavascriptConfirmException(((JavascriptConfirm)this.expectedJavascriptConfirms.get(0)).getMessage());
        }
        for (int i = confirms.length - 1; i >= 0; --i) {
            this.expectedJavascriptConfirms.add(confirms[i]);
        }
    }

    public void setExpectedJavaScriptPrompt(JavascriptPrompt[] prompts) throws ExpectedJavascriptPromptException {
        if (this.expectedJavascriptPrompts.size() > 0) {
            throw new ExpectedJavascriptPromptException(((JavascriptPrompt)this.expectedJavascriptPrompts.get(0)).getMessage());
        }
        for (int i = prompts.length - 1; i >= 0; --i) {
            this.expectedJavascriptPrompts.add(prompts[i]);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

