/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import net.sf.webdav.exceptions.LockFailedException;
import net.sf.webdav.locking.IResourceLocks;
import net.sf.webdav.locking.LockedObject;
import net.sf.webdav.methods.DeterminableMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoUnlock
extends DeterminableMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoUnlock.class);
    private IWebdavStore _store;
    private IResourceLocks _resourceLocks;
    private boolean _readOnly;

    public DoUnlock(IWebdavStore store, IResourceLocks resourceLocks, boolean readOnly) {
        this._store = store;
        this._resourceLocks = resourceLocks;
        this._readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        LOG.trace("-- " + this.getClass().getName());
        if (this._readOnly) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        String tempLockOwner = "doUnlock" + System.currentTimeMillis() + req.toString();
        try {
            if (this._resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
                LockedObject lo;
                String lockId = this.getLockIdFromLockTokenHeader(req);
                if (lockId != null && (lo = this._resourceLocks.getLockedObjectByID(transaction, lockId)) != null) {
                    String[] owners = lo.getOwner();
                    String owner = null;
                    if (lo.isShared()) {
                        if (owners != null) {
                            for (int i = 0; i < owners.length; ++i) {
                                lo.removeLockedObjectOwner(owners[i]);
                            }
                        }
                    } else {
                        owner = owners != null ? owners[0] : null;
                    }
                    if (this._resourceLocks.unlock(transaction, lockId, owner)) {
                        StoredObject so = this._store.getStoredObject(transaction, path);
                        if (so.isNullResource()) {
                            this._store.removeObject(transaction, path);
                        }
                        resp.setStatus(204);
                    } else {
                        LOG.trace("DoUnlock failure at " + lo.getPath());
                        resp.sendError(420);
                    }
                } else {
                    resp.sendError(400);
                }
            }
        }
        catch (LockFailedException e) {
            e.printStackTrace();
        }
        finally {
            this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
        }
    }
}

