/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.xml.lib;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import net.revelc.code.formatter.xml.lib.FormattingPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentFormatter {
    private static final Logger logger = LoggerFactory.getLogger(CommentFormatter.class);

    public String format(String tagText, String indent, String lineDelimiter, FormattingPreferences prefs) {
        Object[] lines = tagText.split(lineDelimiter, -1);
        if (logger.isDebugEnabled()) {
            logger.debug("input: {}\n", (Object)Arrays.toString(lines));
        }
        ArrayList<CallSite> newLines = new ArrayList<CallSite>();
        for (Object line : lines) {
            if (lines.length < 2) {
                newLines.add((CallSite)((Object)(indent + (String)line)));
                continue;
            }
            if (((String)line).trim().equals("<!--") || ((String)line).trim().equals("-->") || ((String)line).contains("<!--")) {
                newLines.add((CallSite)((Object)(indent + ((String)line).stripLeading())));
                continue;
            }
            if (indent.equals("") && !((String)line).stripLeading().equals("")) {
                newLines.add((CallSite)((Object)(prefs.getCanonicalIndent() + ((String)line).stripLeading())));
                continue;
            }
            newLines.add((CallSite)((Object)(indent + indent + ((String)line).stripLeading())));
        }
        logger.debug("output: {}\n", newLines);
        return String.join((CharSequence)lineDelimiter, newLines);
    }
}

