/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.semantic.io.json.impl;

import it.tidalwave.util.Id;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.annotation.Nonnull;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.json.me.JSONException;
import org.json.me.JSONObject;
import org.json.me.JSONWriter;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.XMLSchema;

public final class Literals {
    private static final String KEY_DATATYPE = "datatype";
    private static final String KEY_TYPE = "type";
    private static final String KEY_VALUE = "value";
    private static final String TYPE_LITERAL = "literal";
    private static final String TYPE_URI = "uri";
    private static final String TYPE_BNODE = "bnode";
    private static final String DATE_PATTERN = "yyyy-MM-dd'T'hh:mm:ss";
    private static final ValueFactory valueFactory = new ValueFactoryImpl();

    private Literals() {
    }

    public static void marshalLiteral(@Nonnull JSONWriter jw, @Nonnull Value value) throws JSONException {
        if (value instanceof URI) {
            Literals.marshalUri(jw, value.stringValue());
        } else {
            Literal literal = (Literal)value;
            URI dataType = literal.getDatatype();
            if (dataType == null || dataType.equals(XMLSchema.STRING)) {
                Literals.marshalString(jw, literal.stringValue());
            } else if (dataType.stringValue().equals("urn:bnode")) {
                Literals.marshalReference(jw, new Id((Object)literal.stringValue()));
            } else if (dataType.equals(XMLSchema.DATETIME)) {
                Literals.marshalDate(jw, literal.calendarValue().toGregorianCalendar().getTime());
            } else {
                throw new IllegalArgumentException("Unknown dataType: " + dataType);
            }
        }
    }

    public static void marshalReference(@Nonnull JSONWriter jw, @Nonnull Id id) throws JSONException {
        jw.object().key(KEY_VALUE).value((Object)id.stringValue()).key(KEY_TYPE).value((Object)TYPE_BNODE).endObject();
    }

    @Nonnull
    public static Value unmarshalLiteral(@Nonnull JSONObject object) throws JSONException {
        String type = object.getString(KEY_TYPE);
        if (type.equals(TYPE_BNODE)) {
            return valueFactory.createURI(object.getString(KEY_VALUE));
        }
        String dataType = object.optString(KEY_DATATYPE);
        if (dataType.equals(XMLSchema.DATETIME.stringValue())) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(DATE_PATTERN);
                GregorianCalendar gregorianCalendar = (GregorianCalendar)GregorianCalendar.getInstance();
                gregorianCalendar.setTime(df.parse(object.getString(KEY_VALUE)));
                return valueFactory.createLiteral(DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar));
            }
            catch (DatatypeConfigurationException e) {
                throw new JSONException((Throwable)e);
            }
            catch (ParseException e) {
                throw new JSONException((Throwable)e);
            }
        }
        if (dataType.equals("")) {
            return valueFactory.createLiteral(object.getString(KEY_VALUE), XMLSchema.STRING);
        }
        throw new IllegalArgumentException("datatype=" + dataType);
    }

    private static void marshalString(@Nonnull JSONWriter jw, @Nonnull String string) throws JSONException {
        jw.object().key(KEY_VALUE).value((Object)string).key(KEY_TYPE).value((Object)TYPE_LITERAL).endObject();
    }

    private static void marshalDate(@Nonnull JSONWriter jw, @Nonnull Date date) throws JSONException {
        SimpleDateFormat df = new SimpleDateFormat(DATE_PATTERN);
        jw.object().key(KEY_VALUE).value((Object)df.format(date)).key(KEY_TYPE).value((Object)TYPE_LITERAL).key(KEY_DATATYPE).value((Object)XMLSchema.DATETIME.stringValue()).endObject();
    }

    private static void marshalUri(@Nonnull JSONWriter jw, @Nonnull String uri) throws JSONException {
        jw.object().key(KEY_VALUE).value((Object)uri).key(KEY_TYPE).value((Object)TYPE_URI).endObject();
    }
}

