/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.semantic.io.json;

import it.tidalwave.semantic.io.json.impl.Literals;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import org.json.me.JSONArray;
import org.json.me.JSONException;
import org.json.me.JSONObject;
import org.json.me.JSONTokener;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.RDFParserBase;

public class RdfJsonParser
extends RDFParserBase {
    @Nonnull
    public RDFFormat getRDFFormat() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void parse(@Nonnull InputStream is, @Nonnull String string) throws IOException, RDFParseException, RDFHandlerException {
        this.parse(new InputStreamReader(is, "UTF-8"), string);
    }

    public void parse(@Nonnull Reader r, @Nonnull String string) throws IOException, RDFParseException, RDFHandlerException {
        try {
            JSONTokener jt = new JSONTokener(RdfJsonParser.readString(r));
            JSONObject rootObject = (JSONObject)jt.nextValue();
            this.unmarshalGraph(rootObject);
        }
        catch (JSONException e) {
            throw new RDFParseException((Throwable)e);
        }
    }

    @Nonnull
    private void unmarshalGraph(@Nonnull JSONObject parentObject) throws JSONException, RDFParseException, RDFHandlerException {
        this.rdfHandler.startRDF();
        Enumeration e1 = parentObject.keys();
        while (e1.hasMoreElements()) {
            String subject = (String)e1.nextElement();
            JSONObject object1 = parentObject.getJSONObject(subject);
            Enumeration e2 = object1.keys();
            while (e2.hasMoreElements()) {
                String predicate = (String)e2.nextElement();
                JSONArray objects = object1.getJSONArray(predicate);
                for (int i = 0; i < objects.length(); ++i) {
                    Value object = Literals.unmarshalLiteral(objects.getJSONObject(i));
                    Statement statement = this.createStatement((Resource)this.createURI(subject), this.createURI(predicate), object);
                    this.rdfHandler.handleStatement(statement);
                }
            }
        }
        this.rdfHandler.endRDF();
    }

    @Nonnull
    private static String readString(@Nonnull Reader r) throws IOException {
        int c;
        StringBuilder buffer = new StringBuilder();
        while ((c = r.read()) >= 0) {
            buffer.append((char)c);
        }
        return buffer.toString();
    }
}

