/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation.tracecontext;

import brave.propagation.TraceContext;
import brave.propagation.tracecontext.TraceContextPropagation;
import brave.propagation.tracecontext.internal.Nullable;
import brave.propagation.tracecontext.internal.codec.HexCodec;

public final class TraceparentFormat {
    static final TraceparentFormat INSTANCE = new TraceparentFormat(false);
    static final int FORMAT_LENGTH = 55;
    static final int FIELD_VERSION = 1;
    static final int FIELD_TRACE_ID = 2;
    static final int FIELD_PARENT_ID = 3;
    static final int FIELD_TRACE_FLAGS = 4;
    final boolean shouldThrow;
    static final ThreadLocal<char[]> CHAR_BUFFER = new ThreadLocal();

    public static TraceparentFormat get() {
        return INSTANCE;
    }

    TraceparentFormat(boolean shouldThrow) {
        this.shouldThrow = shouldThrow;
    }

    public String write(TraceContext context) {
        char[] buffer = TraceparentFormat.getCharBuffer();
        int length = this.write(context, buffer);
        return new String(buffer, 0, length);
    }

    public byte[] writeAsBytes(TraceContext context) {
        char[] buffer = TraceparentFormat.getCharBuffer();
        int length = this.write(context, buffer);
        return TraceparentFormat.asciiToNewByteArray(buffer, length);
    }

    int write(TraceContext context, char[] result) {
        int pos = 0;
        result[pos++] = 48;
        result[pos++] = 48;
        result[pos++] = 45;
        long traceIdHigh = context.traceIdHigh();
        HexCodec.writeHexLong(result, pos, traceIdHigh);
        HexCodec.writeHexLong(result, pos += 16, context.traceId());
        pos += 16;
        result[pos++] = 45;
        HexCodec.writeHexLong(result, pos, context.spanId());
        pos += 16;
        result[pos++] = 45;
        result[pos++] = 48;
        result[pos++] = Boolean.TRUE.equals(context.sampled()) ? 49 : 48;
        return pos;
    }

    @Nullable
    public TraceContext parse(CharSequence parent) {
        return TraceparentFormat.parse(parent, 0, parent.length(), this.shouldThrow);
    }

    @Nullable
    public TraceContext parse(CharSequence value, int beginIndex, int endIndex) {
        return TraceparentFormat.parse(value, beginIndex, endIndex, this.shouldThrow);
    }

    @Nullable
    static TraceContext parse(CharSequence value, int beginIndex, int endIndex, boolean shouldThrow) {
        int length = endIndex - beginIndex;
        if (length == 0) {
            TraceContextPropagation.logOrThrow("Invalid input: empty", shouldThrow);
            return null;
        }
        TraceContext.Builder builder = TraceContext.newBuilder();
        int version = 0;
        boolean traceIdHighZero = false;
        int currentField = 1;
        int currentFieldLength = 0;
        long buffer = 0L;
        block6: for (int pos = beginIndex; pos <= endIndex; ++pos) {
            int c;
            boolean isEof = pos == endIndex;
            int n = c = isEof ? 45 : (int)value.charAt(pos);
            if (c == 45) {
                if (!TraceparentFormat.validateFieldLength(currentField, currentFieldLength, shouldThrow)) {
                    return null;
                }
                switch (currentField) {
                    case 1: {
                        version = (int)buffer;
                        if (version == 255) {
                            TraceparentFormat.logOrThrow(currentField, "Invalid input: ff {0}", shouldThrow);
                            return null;
                        }
                        if (version == 0 && length > 55) {
                            TraceContextPropagation.logOrThrow("Invalid input: too long", shouldThrow);
                            return null;
                        }
                        currentField = 2;
                        break;
                    }
                    case 2: {
                        if (traceIdHighZero && buffer == 0L) {
                            TraceparentFormat.logReadAllZeros(currentField, shouldThrow);
                            return null;
                        }
                        builder.traceId(buffer);
                        currentField = 3;
                        break;
                    }
                    case 3: {
                        if (buffer == 0L) {
                            TraceparentFormat.logReadAllZeros(currentField, shouldThrow);
                            return null;
                        }
                        builder.spanId(buffer);
                        currentField = 4;
                        break;
                    }
                    case 4: {
                        int traceparentFlags = (int)(buffer & 0xFFL);
                        builder.sampled((traceparentFlags & 1) == 1);
                        if (version != 0) break block6;
                        if ((traceparentFlags & 0xFFFFFFFE) != 0) {
                            TraceparentFormat.logOrThrow(currentField, "Invalid input: only choices are 00 or 01 {0}", shouldThrow);
                            return null;
                        }
                        if (isEof) break block6;
                        TraceContextPropagation.logOrThrow("Invalid input: more than 3 fields exist", shouldThrow);
                        return null;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                buffer = 0L;
                currentFieldLength = 0;
                continue;
            }
            if (currentField == 2 && currentFieldLength == 16) {
                traceIdHighZero = buffer == 0L;
                builder.traceIdHigh(buffer);
                buffer = 0L;
            }
            ++currentFieldLength;
            buffer <<= 4;
            if (c >= 48 && c <= 57) {
                buffer |= (long)(c - 48);
                continue;
            }
            if (c >= 97 && c <= 102) {
                buffer |= (long)(c - 97 + 10);
                continue;
            }
            TraceparentFormat.logOrThrow(currentField, "Invalid input: only valid characters are lower-hex for {0}", shouldThrow);
            return null;
        }
        return builder.build();
    }

    static boolean validateFieldLength(int field, int length, boolean shouldThrow) {
        int expectedLength;
        int n = field == 1 || field == 4 ? 2 : (expectedLength = field == 2 ? 32 : 16);
        if (length == 0) {
            return TraceparentFormat.logOrThrow(field, "Invalid input: empty {0}", shouldThrow);
        }
        if (length < expectedLength) {
            return TraceparentFormat.logOrThrow(field, "Invalid input: {0} is too short", shouldThrow);
        }
        if (length > expectedLength) {
            return TraceparentFormat.logOrThrow(field, "Invalid input: {0} is too long", shouldThrow);
        }
        return true;
    }

    static void logReadAllZeros(int currentField, boolean shouldThrow) {
        TraceparentFormat.logOrThrow(currentField, "Invalid input: read all zeros {0}", shouldThrow);
    }

    static boolean logOrThrow(int fieldCode, String msg, boolean shouldThrow) {
        String field;
        switch (fieldCode) {
            case 1: {
                field = "version";
                break;
            }
            case 2: {
                field = "trace ID";
                break;
            }
            case 3: {
                field = "parent ID";
                break;
            }
            case 4: {
                field = "trace flags";
                break;
            }
            default: {
                throw new AssertionError((Object)("field code unmatched: " + fieldCode));
            }
        }
        return TraceContextPropagation.logOrThrow(msg, field, shouldThrow);
    }

    static byte[] asciiToNewByteArray(char[] buffer, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)buffer[i];
        }
        return result;
    }

    static char[] getCharBuffer() {
        char[] charBuffer = CHAR_BUFFER.get();
        if (charBuffer == null) {
            charBuffer = new char[55];
            CHAR_BUFFER.set(charBuffer);
        }
        return charBuffer;
    }
}

